package io.github.vigoo.zioaws.s3.model
import io.github.vigoo.zioaws.s3.model.primitives.Role
import zio.ZIO
import io.github.vigoo.zioaws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class ReplicationConfiguration(
    role: Role,
    rules: Iterable[io.github.vigoo.zioaws.s3.model.ReplicationRule]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.ReplicationConfiguration = {
    import ReplicationConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.ReplicationConfiguration
      .builder()
      .role(role: java.lang.String)
      .rules(rules.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.s3.model.ReplicationConfiguration.ReadOnly =
    io.github.vigoo.zioaws.s3.model.ReplicationConfiguration
      .wrap(buildAwsValue())
}
object ReplicationConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.ReplicationConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.s3.model.ReplicationConfiguration =
      io.github.vigoo.zioaws.s3.model.ReplicationConfiguration(
        roleValue,
        rulesValue.map { item =>
          item.editable
        }
      )
    def roleValue: Role
    def rulesValue
        : List[io.github.vigoo.zioaws.s3.model.ReplicationRule.ReadOnly]
    def role: ZIO[Any, Nothing, Role] = ZIO.succeed(roleValue)
    def rules: ZIO[Any, Nothing, List[
      io.github.vigoo.zioaws.s3.model.ReplicationRule.ReadOnly
    ]] = ZIO.succeed(rulesValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.ReplicationConfiguration
  ) extends io.github.vigoo.zioaws.s3.model.ReplicationConfiguration.ReadOnly {
    override def roleValue: Role = impl.role(): Role
    override def rulesValue
        : List[io.github.vigoo.zioaws.s3.model.ReplicationRule.ReadOnly] = impl
      .rules()
      .asScala
      .map { item =>
        io.github.vigoo.zioaws.s3.model.ReplicationRule.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.ReplicationConfiguration
  ): io.github.vigoo.zioaws.s3.model.ReplicationConfiguration.ReadOnly =
    new Wrapper(impl)
}
