package io.github.vigoo.zioaws.s3.model
import java.lang.Integer
import io.github.vigoo.zioaws.s3.model.primitives.{Prefix, Priority, ID}
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ReplicationRule(
    id: Option[ID] = None,
    priority: Option[Priority] = None,
    prefix: Option[Prefix] = None,
    filter: Option[io.github.vigoo.zioaws.s3.model.ReplicationRuleFilter] =
      None,
    status: io.github.vigoo.zioaws.s3.model.ReplicationRuleStatus,
    sourceSelectionCriteria: Option[
      io.github.vigoo.zioaws.s3.model.SourceSelectionCriteria
    ] = None,
    existingObjectReplication: Option[
      io.github.vigoo.zioaws.s3.model.ExistingObjectReplication
    ] = None,
    destination: io.github.vigoo.zioaws.s3.model.Destination,
    deleteMarkerReplication: Option[
      io.github.vigoo.zioaws.s3.model.DeleteMarkerReplication
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.ReplicationRule = {
    import ReplicationRule.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.ReplicationRule
      .builder()
      .optionallyWith(id.map(value => value: java.lang.String))(_.id)
      .optionallyWith(priority.map(value => value: Integer))(_.priority)
      .optionallyWith(prefix.map(value => value: java.lang.String))(_.prefix)
      .optionallyWith(filter.map(value => value.buildAwsValue()))(_.filter)
      .status(status.unwrap)
      .optionallyWith(
        sourceSelectionCriteria.map(value => value.buildAwsValue())
      )(_.sourceSelectionCriteria)
      .optionallyWith(
        existingObjectReplication.map(value => value.buildAwsValue())
      )(_.existingObjectReplication)
      .destination(destination.buildAwsValue())
      .optionallyWith(
        deleteMarkerReplication.map(value => value.buildAwsValue())
      )(_.deleteMarkerReplication)
      .build()
  }
  def asReadOnly: io.github.vigoo.zioaws.s3.model.ReplicationRule.ReadOnly =
    io.github.vigoo.zioaws.s3.model.ReplicationRule.wrap(buildAwsValue())
}
object ReplicationRule {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.ReplicationRule
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.s3.model.ReplicationRule =
      io.github.vigoo.zioaws.s3.model.ReplicationRule(
        idValue.map(value => value),
        priorityValue.map(value => value),
        prefixValue.map(value => value),
        filterValue.map(value => value.editable),
        statusValue,
        sourceSelectionCriteriaValue.map(value => value.editable),
        existingObjectReplicationValue.map(value => value.editable),
        destinationValue.editable,
        deleteMarkerReplicationValue.map(value => value.editable)
      )
    def idValue: Option[ID]
    def priorityValue: Option[Priority]
    def prefixValue: Option[Prefix]
    def filterValue
        : Option[io.github.vigoo.zioaws.s3.model.ReplicationRuleFilter.ReadOnly]
    def statusValue: io.github.vigoo.zioaws.s3.model.ReplicationRuleStatus
    def sourceSelectionCriteriaValue: Option[
      io.github.vigoo.zioaws.s3.model.SourceSelectionCriteria.ReadOnly
    ]
    def existingObjectReplicationValue: Option[
      io.github.vigoo.zioaws.s3.model.ExistingObjectReplication.ReadOnly
    ]
    def destinationValue: io.github.vigoo.zioaws.s3.model.Destination.ReadOnly
    def deleteMarkerReplicationValue: Option[
      io.github.vigoo.zioaws.s3.model.DeleteMarkerReplication.ReadOnly
    ]
    def id: ZIO[Any, AwsError, ID] = AwsError.unwrapOptionField("id", idValue)
    def priority: ZIO[Any, AwsError, Priority] =
      AwsError.unwrapOptionField("priority", priorityValue)
    def prefix: ZIO[Any, AwsError, Prefix] =
      AwsError.unwrapOptionField("prefix", prefixValue)
    def filter: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.s3.model.ReplicationRuleFilter.ReadOnly
    ] = AwsError.unwrapOptionField("filter", filterValue)
    def status: ZIO[
      Any,
      Nothing,
      io.github.vigoo.zioaws.s3.model.ReplicationRuleStatus
    ] = ZIO.succeed(statusValue)
    def sourceSelectionCriteria: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.s3.model.SourceSelectionCriteria.ReadOnly
    ] = AwsError.unwrapOptionField(
      "sourceSelectionCriteria",
      sourceSelectionCriteriaValue
    )
    def existingObjectReplication: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.s3.model.ExistingObjectReplication.ReadOnly
    ] = AwsError.unwrapOptionField(
      "existingObjectReplication",
      existingObjectReplicationValue
    )
    def destination: ZIO[
      Any,
      Nothing,
      io.github.vigoo.zioaws.s3.model.Destination.ReadOnly
    ] = ZIO.succeed(destinationValue)
    def deleteMarkerReplication: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.s3.model.DeleteMarkerReplication.ReadOnly
    ] = AwsError.unwrapOptionField(
      "deleteMarkerReplication",
      deleteMarkerReplicationValue
    )
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.ReplicationRule
  ) extends io.github.vigoo.zioaws.s3.model.ReplicationRule.ReadOnly {
    override def idValue: Option[ID] =
      scala.Option(impl.id()).map(value => value: ID)
    override def priorityValue: Option[Priority] =
      scala.Option(impl.priority()).map(value => value: Priority)
    override def prefixValue: Option[Prefix] =
      scala.Option(impl.prefix()).map(value => value: Prefix)
    override def filterValue: Option[
      io.github.vigoo.zioaws.s3.model.ReplicationRuleFilter.ReadOnly
    ] = scala
      .Option(impl.filter())
      .map(value =>
        io.github.vigoo.zioaws.s3.model.ReplicationRuleFilter.wrap(value)
      )
    override def statusValue
        : io.github.vigoo.zioaws.s3.model.ReplicationRuleStatus =
      io.github.vigoo.zioaws.s3.model.ReplicationRuleStatus.wrap(impl.status())
    override def sourceSelectionCriteriaValue: Option[
      io.github.vigoo.zioaws.s3.model.SourceSelectionCriteria.ReadOnly
    ] = scala
      .Option(impl.sourceSelectionCriteria())
      .map(value =>
        io.github.vigoo.zioaws.s3.model.SourceSelectionCriteria.wrap(value)
      )
    override def existingObjectReplicationValue: Option[
      io.github.vigoo.zioaws.s3.model.ExistingObjectReplication.ReadOnly
    ] = scala
      .Option(impl.existingObjectReplication())
      .map(value =>
        io.github.vigoo.zioaws.s3.model.ExistingObjectReplication.wrap(value)
      )
    override def destinationValue
        : io.github.vigoo.zioaws.s3.model.Destination.ReadOnly =
      io.github.vigoo.zioaws.s3.model.Destination.wrap(impl.destination())
    override def deleteMarkerReplicationValue: Option[
      io.github.vigoo.zioaws.s3.model.DeleteMarkerReplication.ReadOnly
    ] = scala
      .Option(impl.deleteMarkerReplication())
      .map(value =>
        io.github.vigoo.zioaws.s3.model.DeleteMarkerReplication.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.ReplicationRule
  ): io.github.vigoo.zioaws.s3.model.ReplicationRule.ReadOnly = new Wrapper(
    impl
  )
}
