package io.github.vigoo.zioaws.s3.model
import zio.ZIO
import io.github.vigoo.zioaws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class ReplicationTime(
    status: io.github.vigoo.zioaws.s3.model.ReplicationTimeStatus,
    time: io.github.vigoo.zioaws.s3.model.ReplicationTimeValue
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.ReplicationTime = {
    import ReplicationTime.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.ReplicationTime
      .builder()
      .status(status.unwrap)
      .time(time.buildAwsValue())
      .build()
  }
  def asReadOnly: io.github.vigoo.zioaws.s3.model.ReplicationTime.ReadOnly =
    io.github.vigoo.zioaws.s3.model.ReplicationTime.wrap(buildAwsValue())
}
object ReplicationTime {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.ReplicationTime
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.s3.model.ReplicationTime =
      io.github.vigoo.zioaws.s3.model
        .ReplicationTime(statusValue, timeValue.editable)
    def statusValue: io.github.vigoo.zioaws.s3.model.ReplicationTimeStatus
    def timeValue: io.github.vigoo.zioaws.s3.model.ReplicationTimeValue.ReadOnly
    def status: ZIO[
      Any,
      Nothing,
      io.github.vigoo.zioaws.s3.model.ReplicationTimeStatus
    ] = ZIO.succeed(statusValue)
    def time: ZIO[
      Any,
      Nothing,
      io.github.vigoo.zioaws.s3.model.ReplicationTimeValue.ReadOnly
    ] = ZIO.succeed(timeValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.ReplicationTime
  ) extends io.github.vigoo.zioaws.s3.model.ReplicationTime.ReadOnly {
    override def statusValue
        : io.github.vigoo.zioaws.s3.model.ReplicationTimeStatus =
      io.github.vigoo.zioaws.s3.model.ReplicationTimeStatus.wrap(impl.status())
    override def timeValue
        : io.github.vigoo.zioaws.s3.model.ReplicationTimeValue.ReadOnly =
      io.github.vigoo.zioaws.s3.model.ReplicationTimeValue.wrap(impl.time())
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.ReplicationTime
  ): io.github.vigoo.zioaws.s3.model.ReplicationTime.ReadOnly = new Wrapper(
    impl
  )
}
