package io.github.vigoo.zioaws.s3.model
import scala.jdk.CollectionConverters._
sealed trait ReplicationTimeStatus {
  def unwrap: software.amazon.awssdk.services.s3.model.ReplicationTimeStatus
}
object ReplicationTimeStatus {
  def wrap(
      value: software.amazon.awssdk.services.s3.model.ReplicationTimeStatus
  ): io.github.vigoo.zioaws.s3.model.ReplicationTimeStatus = value match {
    case software.amazon.awssdk.services.s3.model.ReplicationTimeStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.s3.model.ReplicationTimeStatus.ENABLED =>
      val r = Enabled
      r
    case software.amazon.awssdk.services.s3.model.ReplicationTimeStatus.DISABLED =>
      val r = Disabled
      r
  }
  case object unknownToSdkVersion
      extends io.github.vigoo.zioaws.s3.model.ReplicationTimeStatus {
    override def unwrap
        : software.amazon.awssdk.services.s3.model.ReplicationTimeStatus =
      software.amazon.awssdk.services.s3.model.ReplicationTimeStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object Enabled
      extends io.github.vigoo.zioaws.s3.model.ReplicationTimeStatus {
    override def unwrap
        : software.amazon.awssdk.services.s3.model.ReplicationTimeStatus =
      software.amazon.awssdk.services.s3.model.ReplicationTimeStatus.ENABLED
  }
  case object Disabled
      extends io.github.vigoo.zioaws.s3.model.ReplicationTimeStatus {
    override def unwrap
        : software.amazon.awssdk.services.s3.model.ReplicationTimeStatus =
      software.amazon.awssdk.services.s3.model.ReplicationTimeStatus.DISABLED
  }
}
