package io.github.vigoo.zioaws.s3.model
import java.lang.Integer
import io.github.vigoo.zioaws.s3.model.primitives.Minutes
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ReplicationTimeValue(minutes: Option[Minutes] = None) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.ReplicationTimeValue = {
    import ReplicationTimeValue.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.ReplicationTimeValue
      .builder()
      .optionallyWith(minutes.map(value => value: Integer))(_.minutes)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.s3.model.ReplicationTimeValue.ReadOnly =
    io.github.vigoo.zioaws.s3.model.ReplicationTimeValue.wrap(buildAwsValue())
}
object ReplicationTimeValue {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.ReplicationTimeValue
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.s3.model.ReplicationTimeValue =
      io.github.vigoo.zioaws.s3.model
        .ReplicationTimeValue(minutesValue.map(value => value))
    def minutesValue: Option[Minutes]
    def minutes: ZIO[Any, AwsError, Minutes] =
      AwsError.unwrapOptionField("minutes", minutesValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.ReplicationTimeValue
  ) extends io.github.vigoo.zioaws.s3.model.ReplicationTimeValue.ReadOnly {
    override def minutesValue: Option[Minutes] =
      scala.Option(impl.minutes()).map(value => value: Minutes)
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.ReplicationTimeValue
  ): io.github.vigoo.zioaws.s3.model.ReplicationTimeValue.ReadOnly =
    new Wrapper(impl)
}
