package io.github.vigoo.zioaws.s3.model
import scala.jdk.CollectionConverters._
sealed trait RequestPayer {
  def unwrap: software.amazon.awssdk.services.s3.model.RequestPayer
}
object RequestPayer {
  def wrap(
      value: software.amazon.awssdk.services.s3.model.RequestPayer
  ): io.github.vigoo.zioaws.s3.model.RequestPayer = value match {
    case software.amazon.awssdk.services.s3.model.RequestPayer.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.s3.model.RequestPayer.REQUESTER =>
      val r = requester
      r
  }
  case object unknownToSdkVersion
      extends io.github.vigoo.zioaws.s3.model.RequestPayer {
    override def unwrap: software.amazon.awssdk.services.s3.model.RequestPayer =
      software.amazon.awssdk.services.s3.model.RequestPayer.UNKNOWN_TO_SDK_VERSION
  }
  case object requester extends io.github.vigoo.zioaws.s3.model.RequestPayer {
    override def unwrap: software.amazon.awssdk.services.s3.model.RequestPayer =
      software.amazon.awssdk.services.s3.model.RequestPayer.REQUESTER
  }
}
