package io.github.vigoo.zioaws.s3.model
import zio.ZIO
import io.github.vigoo.zioaws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class RequestPaymentConfiguration(
    payer: io.github.vigoo.zioaws.s3.model.Payer
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.RequestPaymentConfiguration = {
    import RequestPaymentConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.RequestPaymentConfiguration
      .builder()
      .payer(payer.unwrap)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.s3.model.RequestPaymentConfiguration.ReadOnly =
    io.github.vigoo.zioaws.s3.model.RequestPaymentConfiguration
      .wrap(buildAwsValue())
}
object RequestPaymentConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.RequestPaymentConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.s3.model.RequestPaymentConfiguration =
      io.github.vigoo.zioaws.s3.model.RequestPaymentConfiguration(payerValue)
    def payerValue: io.github.vigoo.zioaws.s3.model.Payer
    def payer: ZIO[Any, Nothing, io.github.vigoo.zioaws.s3.model.Payer] =
      ZIO.succeed(payerValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.RequestPaymentConfiguration
  ) extends io.github.vigoo.zioaws.s3.model.RequestPaymentConfiguration.ReadOnly {
    override def payerValue: io.github.vigoo.zioaws.s3.model.Payer =
      io.github.vigoo.zioaws.s3.model.Payer.wrap(impl.payer())
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.RequestPaymentConfiguration
  ): io.github.vigoo.zioaws.s3.model.RequestPaymentConfiguration.ReadOnly =
    new Wrapper(impl)
}
