package io.github.vigoo.zioaws.s3.model
import io.github.vigoo.zioaws.s3.model.primitives.EnableRequestProgress
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class RequestProgress(
    enabled: Option[EnableRequestProgress] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.RequestProgress = {
    import RequestProgress.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.RequestProgress
      .builder()
      .optionallyWith(enabled.map(value => value: java.lang.Boolean))(_.enabled)
      .build()
  }
  def asReadOnly: io.github.vigoo.zioaws.s3.model.RequestProgress.ReadOnly =
    io.github.vigoo.zioaws.s3.model.RequestProgress.wrap(buildAwsValue())
}
object RequestProgress {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.RequestProgress
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.s3.model.RequestProgress =
      io.github.vigoo.zioaws.s3.model
        .RequestProgress(enabledValue.map(value => value))
    def enabledValue: Option[EnableRequestProgress]
    def enabled: ZIO[Any, AwsError, EnableRequestProgress] =
      AwsError.unwrapOptionField("enabled", enabledValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.RequestProgress
  ) extends io.github.vigoo.zioaws.s3.model.RequestProgress.ReadOnly {
    override def enabledValue: Option[EnableRequestProgress] =
      scala.Option(impl.enabled()).map(value => value: EnableRequestProgress)
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.RequestProgress
  ): io.github.vigoo.zioaws.s3.model.RequestProgress.ReadOnly = new Wrapper(
    impl
  )
}
