package io.github.vigoo.zioaws.s3.model
import io.github.vigoo.zioaws.s3.model.primitives.{
  AccountId,
  ObjectVersionId,
  ObjectKey,
  BucketName
}
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class RestoreObjectRequest(
    bucket: BucketName,
    key: ObjectKey,
    versionId: Option[ObjectVersionId] = None,
    restoreRequest: Option[io.github.vigoo.zioaws.s3.model.RestoreRequest] =
      None,
    requestPayer: Option[io.github.vigoo.zioaws.s3.model.RequestPayer] = None,
    checksumAlgorithm: Option[
      io.github.vigoo.zioaws.s3.model.ChecksumAlgorithm
    ] = None,
    expectedBucketOwner: Option[AccountId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.RestoreObjectRequest = {
    import RestoreObjectRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.RestoreObjectRequest
      .builder()
      .bucket(bucket: java.lang.String)
      .key(key: java.lang.String)
      .optionallyWith(versionId.map(value => value: java.lang.String))(
        _.versionId
      )
      .optionallyWith(restoreRequest.map(value => value.buildAwsValue()))(
        _.restoreRequest
      )
      .optionallyWith(requestPayer.map(value => value.unwrap))(_.requestPayer)
      .optionallyWith(checksumAlgorithm.map(value => value.unwrap))(
        _.checksumAlgorithm
      )
      .optionallyWith(
        expectedBucketOwner.map(value => value: java.lang.String)
      )(_.expectedBucketOwner)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.s3.model.RestoreObjectRequest.ReadOnly =
    io.github.vigoo.zioaws.s3.model.RestoreObjectRequest.wrap(buildAwsValue())
}
object RestoreObjectRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.RestoreObjectRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.s3.model.RestoreObjectRequest =
      io.github.vigoo.zioaws.s3.model.RestoreObjectRequest(
        bucketValue,
        keyValue,
        versionIdValue.map(value => value),
        restoreRequestValue.map(value => value.editable),
        requestPayerValue.map(value => value),
        checksumAlgorithmValue.map(value => value),
        expectedBucketOwnerValue.map(value => value)
      )
    def bucketValue: BucketName
    def keyValue: ObjectKey
    def versionIdValue: Option[ObjectVersionId]
    def restoreRequestValue
        : Option[io.github.vigoo.zioaws.s3.model.RestoreRequest.ReadOnly]
    def requestPayerValue: Option[io.github.vigoo.zioaws.s3.model.RequestPayer]
    def checksumAlgorithmValue
        : Option[io.github.vigoo.zioaws.s3.model.ChecksumAlgorithm]
    def expectedBucketOwnerValue: Option[AccountId]
    def bucket: ZIO[Any, Nothing, BucketName] = ZIO.succeed(bucketValue)
    def key: ZIO[Any, Nothing, ObjectKey] = ZIO.succeed(keyValue)
    def versionId: ZIO[Any, AwsError, ObjectVersionId] =
      AwsError.unwrapOptionField("versionId", versionIdValue)
    def restoreRequest: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.s3.model.RestoreRequest.ReadOnly
    ] = AwsError.unwrapOptionField("restoreRequest", restoreRequestValue)
    def requestPayer
        : ZIO[Any, AwsError, io.github.vigoo.zioaws.s3.model.RequestPayer] =
      AwsError.unwrapOptionField("requestPayer", requestPayerValue)
    def checksumAlgorithm: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.s3.model.ChecksumAlgorithm
    ] = AwsError.unwrapOptionField("checksumAlgorithm", checksumAlgorithmValue)
    def expectedBucketOwner: ZIO[Any, AwsError, AccountId] = AwsError
      .unwrapOptionField("expectedBucketOwner", expectedBucketOwnerValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.RestoreObjectRequest
  ) extends io.github.vigoo.zioaws.s3.model.RestoreObjectRequest.ReadOnly {
    override def bucketValue: BucketName = impl.bucket(): BucketName
    override def keyValue: ObjectKey = impl.key(): ObjectKey
    override def versionIdValue: Option[ObjectVersionId] =
      scala.Option(impl.versionId()).map(value => value: ObjectVersionId)
    override def restoreRequestValue
        : Option[io.github.vigoo.zioaws.s3.model.RestoreRequest.ReadOnly] =
      scala
        .Option(impl.restoreRequest())
        .map(value =>
          io.github.vigoo.zioaws.s3.model.RestoreRequest.wrap(value)
        )
    override def requestPayerValue
        : Option[io.github.vigoo.zioaws.s3.model.RequestPayer] = scala
      .Option(impl.requestPayer())
      .map(value => io.github.vigoo.zioaws.s3.model.RequestPayer.wrap(value))
    override def checksumAlgorithmValue
        : Option[io.github.vigoo.zioaws.s3.model.ChecksumAlgorithm] = scala
      .Option(impl.checksumAlgorithm())
      .map(value =>
        io.github.vigoo.zioaws.s3.model.ChecksumAlgorithm.wrap(value)
      )
    override def expectedBucketOwnerValue: Option[AccountId] =
      scala.Option(impl.expectedBucketOwner()).map(value => value: AccountId)
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.RestoreObjectRequest
  ): io.github.vigoo.zioaws.s3.model.RestoreObjectRequest.ReadOnly =
    new Wrapper(impl)
}
