package io.github.vigoo.zioaws.s3.model
import io.github.vigoo.zioaws.s3.model.primitives.RestoreOutputPath
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class RestoreObjectResponse(
    requestCharged: Option[io.github.vigoo.zioaws.s3.model.RequestCharged] =
      None,
    restoreOutputPath: Option[RestoreOutputPath] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.RestoreObjectResponse = {
    import RestoreObjectResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.RestoreObjectResponse
      .builder()
      .optionallyWith(requestCharged.map(value => value.unwrap))(
        _.requestCharged
      )
      .optionallyWith(restoreOutputPath.map(value => value: java.lang.String))(
        _.restoreOutputPath
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.s3.model.RestoreObjectResponse.ReadOnly =
    io.github.vigoo.zioaws.s3.model.RestoreObjectResponse.wrap(buildAwsValue())
}
object RestoreObjectResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.RestoreObjectResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.s3.model.RestoreObjectResponse =
      io.github.vigoo.zioaws.s3.model.RestoreObjectResponse(
        requestChargedValue.map(value => value),
        restoreOutputPathValue.map(value => value)
      )
    def requestChargedValue
        : Option[io.github.vigoo.zioaws.s3.model.RequestCharged]
    def restoreOutputPathValue: Option[RestoreOutputPath]
    def requestCharged
        : ZIO[Any, AwsError, io.github.vigoo.zioaws.s3.model.RequestCharged] =
      AwsError.unwrapOptionField("requestCharged", requestChargedValue)
    def restoreOutputPath: ZIO[Any, AwsError, RestoreOutputPath] =
      AwsError.unwrapOptionField("restoreOutputPath", restoreOutputPathValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.RestoreObjectResponse
  ) extends io.github.vigoo.zioaws.s3.model.RestoreObjectResponse.ReadOnly {
    override def requestChargedValue
        : Option[io.github.vigoo.zioaws.s3.model.RequestCharged] = scala
      .Option(impl.requestCharged())
      .map(value => io.github.vigoo.zioaws.s3.model.RequestCharged.wrap(value))
    override def restoreOutputPathValue: Option[RestoreOutputPath] = scala
      .Option(impl.restoreOutputPath())
      .map(value => value: RestoreOutputPath)
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.RestoreObjectResponse
  ): io.github.vigoo.zioaws.s3.model.RestoreObjectResponse.ReadOnly =
    new Wrapper(impl)
}
