package io.github.vigoo.zioaws.s3.model
import java.lang.Integer
import io.github.vigoo.zioaws.s3.model.primitives.{Description, Days}
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class RestoreRequest(
    days: Option[Days] = None,
    glacierJobParameters: Option[
      io.github.vigoo.zioaws.s3.model.GlacierJobParameters
    ] = None,
    `type`: Option[io.github.vigoo.zioaws.s3.model.RestoreRequestType] = None,
    tier: Option[io.github.vigoo.zioaws.s3.model.Tier] = None,
    description: Option[Description] = None,
    selectParameters: Option[io.github.vigoo.zioaws.s3.model.SelectParameters] =
      None,
    outputLocation: Option[io.github.vigoo.zioaws.s3.model.OutputLocation] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.RestoreRequest = {
    import RestoreRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.RestoreRequest
      .builder()
      .optionallyWith(days.map(value => value: Integer))(_.days)
      .optionallyWith(glacierJobParameters.map(value => value.buildAwsValue()))(
        _.glacierJobParameters
      )
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(tier.map(value => value.unwrap))(_.tier)
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(selectParameters.map(value => value.buildAwsValue()))(
        _.selectParameters
      )
      .optionallyWith(outputLocation.map(value => value.buildAwsValue()))(
        _.outputLocation
      )
      .build()
  }
  def asReadOnly: io.github.vigoo.zioaws.s3.model.RestoreRequest.ReadOnly =
    io.github.vigoo.zioaws.s3.model.RestoreRequest.wrap(buildAwsValue())
}
object RestoreRequest {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.s3.model.RestoreRequest] =
    BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.s3.model.RestoreRequest =
      io.github.vigoo.zioaws.s3.model.RestoreRequest(
        daysValue.map(value => value),
        glacierJobParametersValue.map(value => value.editable),
        typeValue.map(value => value),
        tierValue.map(value => value),
        descriptionValue.map(value => value),
        selectParametersValue.map(value => value.editable),
        outputLocationValue.map(value => value.editable)
      )
    def daysValue: Option[Days]
    def glacierJobParametersValue
        : Option[io.github.vigoo.zioaws.s3.model.GlacierJobParameters.ReadOnly]
    def typeValue: Option[io.github.vigoo.zioaws.s3.model.RestoreRequestType]
    def tierValue: Option[io.github.vigoo.zioaws.s3.model.Tier]
    def descriptionValue: Option[Description]
    def selectParametersValue
        : Option[io.github.vigoo.zioaws.s3.model.SelectParameters.ReadOnly]
    def outputLocationValue
        : Option[io.github.vigoo.zioaws.s3.model.OutputLocation.ReadOnly]
    def days: ZIO[Any, AwsError, Days] =
      AwsError.unwrapOptionField("days", daysValue)
    def glacierJobParameters: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.s3.model.GlacierJobParameters.ReadOnly
    ] = AwsError.unwrapOptionField(
      "glacierJobParameters",
      glacierJobParametersValue
    )
    def `type`: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.s3.model.RestoreRequestType
    ] = AwsError.unwrapOptionField("type", typeValue)
    def tier: ZIO[Any, AwsError, io.github.vigoo.zioaws.s3.model.Tier] =
      AwsError.unwrapOptionField("tier", tierValue)
    def description: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", descriptionValue)
    def selectParameters: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.s3.model.SelectParameters.ReadOnly
    ] = AwsError.unwrapOptionField("selectParameters", selectParametersValue)
    def outputLocation: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.s3.model.OutputLocation.ReadOnly
    ] = AwsError.unwrapOptionField("outputLocation", outputLocationValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.RestoreRequest
  ) extends io.github.vigoo.zioaws.s3.model.RestoreRequest.ReadOnly {
    override def daysValue: Option[Days] =
      scala.Option(impl.days()).map(value => value: Days)
    override def glacierJobParametersValue: Option[
      io.github.vigoo.zioaws.s3.model.GlacierJobParameters.ReadOnly
    ] = scala
      .Option(impl.glacierJobParameters())
      .map(value =>
        io.github.vigoo.zioaws.s3.model.GlacierJobParameters.wrap(value)
      )
    override def typeValue
        : Option[io.github.vigoo.zioaws.s3.model.RestoreRequestType] = scala
      .Option(impl.`type`())
      .map(value =>
        io.github.vigoo.zioaws.s3.model.RestoreRequestType.wrap(value)
      )
    override def tierValue: Option[io.github.vigoo.zioaws.s3.model.Tier] = scala
      .Option(impl.tier())
      .map(value => io.github.vigoo.zioaws.s3.model.Tier.wrap(value))
    override def descriptionValue: Option[Description] =
      scala.Option(impl.description()).map(value => value: Description)
    override def selectParametersValue
        : Option[io.github.vigoo.zioaws.s3.model.SelectParameters.ReadOnly] =
      scala
        .Option(impl.selectParameters())
        .map(value =>
          io.github.vigoo.zioaws.s3.model.SelectParameters.wrap(value)
        )
    override def outputLocationValue
        : Option[io.github.vigoo.zioaws.s3.model.OutputLocation.ReadOnly] =
      scala
        .Option(impl.outputLocation())
        .map(value =>
          io.github.vigoo.zioaws.s3.model.OutputLocation.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.RestoreRequest
  ): io.github.vigoo.zioaws.s3.model.RestoreRequest.ReadOnly = new Wrapper(impl)
}
