package io.github.vigoo.zioaws.s3.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class RoutingRule(
    condition: Option[io.github.vigoo.zioaws.s3.model.Condition] = None,
    redirect: io.github.vigoo.zioaws.s3.model.Redirect
) {
  def buildAwsValue(): software.amazon.awssdk.services.s3.model.RoutingRule = {
    import RoutingRule.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.RoutingRule
      .builder()
      .optionallyWith(condition.map(value => value.buildAwsValue()))(
        _.condition
      )
      .redirect(redirect.buildAwsValue())
      .build()
  }
  def asReadOnly: io.github.vigoo.zioaws.s3.model.RoutingRule.ReadOnly =
    io.github.vigoo.zioaws.s3.model.RoutingRule.wrap(buildAwsValue())
}
object RoutingRule {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.s3.model.RoutingRule] =
    BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.s3.model.RoutingRule =
      io.github.vigoo.zioaws.s3.model.RoutingRule(
        conditionValue.map(value => value.editable),
        redirectValue.editable
      )
    def conditionValue
        : Option[io.github.vigoo.zioaws.s3.model.Condition.ReadOnly]
    def redirectValue: io.github.vigoo.zioaws.s3.model.Redirect.ReadOnly
    def condition: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.s3.model.Condition.ReadOnly
    ] = AwsError.unwrapOptionField("condition", conditionValue)
    def redirect
        : ZIO[Any, Nothing, io.github.vigoo.zioaws.s3.model.Redirect.ReadOnly] =
      ZIO.succeed(redirectValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.RoutingRule
  ) extends io.github.vigoo.zioaws.s3.model.RoutingRule.ReadOnly {
    override def conditionValue
        : Option[io.github.vigoo.zioaws.s3.model.Condition.ReadOnly] = scala
      .Option(impl.condition())
      .map(value => io.github.vigoo.zioaws.s3.model.Condition.wrap(value))
    override def redirectValue
        : io.github.vigoo.zioaws.s3.model.Redirect.ReadOnly =
      io.github.vigoo.zioaws.s3.model.Redirect.wrap(impl.redirect())
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.RoutingRule
  ): io.github.vigoo.zioaws.s3.model.RoutingRule.ReadOnly = new Wrapper(impl)
}
