package io.github.vigoo.zioaws.s3.model
import io.github.vigoo.zioaws.s3.model.primitives.{
  Message,
  Code,
  ObjectVersionId,
  ObjectKey
}
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class S3Error(
    key: Option[ObjectKey] = None,
    versionId: Option[ObjectVersionId] = None,
    code: Option[Code] = None,
    message: Option[Message] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.s3.model.S3Error = {
    import S3Error.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.S3Error
      .builder()
      .optionallyWith(key.map(value => value: java.lang.String))(_.key)
      .optionallyWith(versionId.map(value => value: java.lang.String))(
        _.versionId
      )
      .optionallyWith(code.map(value => value: java.lang.String))(_.code)
      .optionallyWith(message.map(value => value: java.lang.String))(_.message)
      .build()
  }
  def asReadOnly: io.github.vigoo.zioaws.s3.model.S3Error.ReadOnly =
    io.github.vigoo.zioaws.s3.model.S3Error.wrap(buildAwsValue())
}
object S3Error {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.s3.model.S3Error] =
    BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.s3.model.S3Error =
      io.github.vigoo.zioaws.s3.model.S3Error(
        keyValue.map(value => value),
        versionIdValue.map(value => value),
        codeValue.map(value => value),
        messageValue.map(value => value)
      )
    def keyValue: Option[ObjectKey]
    def versionIdValue: Option[ObjectVersionId]
    def codeValue: Option[Code]
    def messageValue: Option[Message]
    def key: ZIO[Any, AwsError, ObjectKey] =
      AwsError.unwrapOptionField("key", keyValue)
    def versionId: ZIO[Any, AwsError, ObjectVersionId] =
      AwsError.unwrapOptionField("versionId", versionIdValue)
    def code: ZIO[Any, AwsError, Code] =
      AwsError.unwrapOptionField("code", codeValue)
    def message: ZIO[Any, AwsError, Message] =
      AwsError.unwrapOptionField("message", messageValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.s3.model.S3Error)
      extends io.github.vigoo.zioaws.s3.model.S3Error.ReadOnly {
    override def keyValue: Option[ObjectKey] =
      scala.Option(impl.key()).map(value => value: ObjectKey)
    override def versionIdValue: Option[ObjectVersionId] =
      scala.Option(impl.versionId()).map(value => value: ObjectVersionId)
    override def codeValue: Option[Code] =
      scala.Option(impl.code()).map(value => value: Code)
    override def messageValue: Option[Message] =
      scala.Option(impl.message()).map(value => value: Message)
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.S3Error
  ): io.github.vigoo.zioaws.s3.model.S3Error.ReadOnly = new Wrapper(impl)
}
