package io.github.vigoo.zioaws.s3.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class S3KeyFilter(
    filterRules: Option[Iterable[io.github.vigoo.zioaws.s3.model.FilterRule]] =
      None
) {
  def buildAwsValue(): software.amazon.awssdk.services.s3.model.S3KeyFilter = {
    import S3KeyFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.S3KeyFilter
      .builder()
      .optionallyWith(
        filterRules.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filterRules)
      .build()
  }
  def asReadOnly: io.github.vigoo.zioaws.s3.model.S3KeyFilter.ReadOnly =
    io.github.vigoo.zioaws.s3.model.S3KeyFilter.wrap(buildAwsValue())
}
object S3KeyFilter {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.s3.model.S3KeyFilter] =
    BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.s3.model.S3KeyFilter =
      io.github.vigoo.zioaws.s3.model.S3KeyFilter(
        filterRulesValue.map(value =>
          value.map { item =>
            item.editable
          }
        )
      )
    def filterRulesValue
        : Option[List[io.github.vigoo.zioaws.s3.model.FilterRule.ReadOnly]]
    def filterRules: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.s3.model.FilterRule.ReadOnly
    ]] = AwsError.unwrapOptionField("filterRules", filterRulesValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.S3KeyFilter
  ) extends io.github.vigoo.zioaws.s3.model.S3KeyFilter.ReadOnly {
    override def filterRulesValue
        : Option[List[io.github.vigoo.zioaws.s3.model.FilterRule.ReadOnly]] =
      scala
        .Option(impl.filterRules())
        .map(value =>
          value.asScala.map { item =>
            io.github.vigoo.zioaws.s3.model.FilterRule.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.S3KeyFilter
  ): io.github.vigoo.zioaws.s3.model.S3KeyFilter.ReadOnly = new Wrapper(impl)
}
