package io.github.vigoo.zioaws.s3.model
import io.github.vigoo.zioaws.s3.model.primitives.{LocationPrefix, BucketName}
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class S3Location(
    bucketName: BucketName,
    prefix: LocationPrefix,
    encryption: Option[io.github.vigoo.zioaws.s3.model.Encryption] = None,
    cannedACL: Option[io.github.vigoo.zioaws.s3.model.ObjectCannedACL] = None,
    accessControlList: Option[Iterable[io.github.vigoo.zioaws.s3.model.Grant]] =
      None,
    tagging: Option[io.github.vigoo.zioaws.s3.model.Tagging] = None,
    userMetadata: Option[
      Iterable[io.github.vigoo.zioaws.s3.model.MetadataEntry]
    ] = None,
    storageClass: Option[io.github.vigoo.zioaws.s3.model.StorageClass] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.s3.model.S3Location = {
    import S3Location.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.S3Location
      .builder()
      .bucketName(bucketName: java.lang.String)
      .prefix(prefix: java.lang.String)
      .optionallyWith(encryption.map(value => value.buildAwsValue()))(
        _.encryption
      )
      .optionallyWith(cannedACL.map(value => value.unwrap))(_.cannedACL)
      .optionallyWith(
        accessControlList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.accessControlList)
      .optionallyWith(tagging.map(value => value.buildAwsValue()))(_.tagging)
      .optionallyWith(
        userMetadata.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.userMetadata)
      .optionallyWith(storageClass.map(value => value.unwrap))(_.storageClass)
      .build()
  }
  def asReadOnly: io.github.vigoo.zioaws.s3.model.S3Location.ReadOnly =
    io.github.vigoo.zioaws.s3.model.S3Location.wrap(buildAwsValue())
}
object S3Location {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.s3.model.S3Location] =
    BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.s3.model.S3Location =
      io.github.vigoo.zioaws.s3.model.S3Location(
        bucketNameValue,
        prefixValue,
        encryptionValue.map(value => value.editable),
        cannedACLValue.map(value => value),
        accessControlListValue.map(value =>
          value.map { item =>
            item.editable
          }
        ),
        taggingValue.map(value => value.editable),
        userMetadataValue.map(value =>
          value.map { item =>
            item.editable
          }
        ),
        storageClassValue.map(value => value)
      )
    def bucketNameValue: BucketName
    def prefixValue: LocationPrefix
    def encryptionValue
        : Option[io.github.vigoo.zioaws.s3.model.Encryption.ReadOnly]
    def cannedACLValue: Option[io.github.vigoo.zioaws.s3.model.ObjectCannedACL]
    def accessControlListValue
        : Option[List[io.github.vigoo.zioaws.s3.model.Grant.ReadOnly]]
    def taggingValue: Option[io.github.vigoo.zioaws.s3.model.Tagging.ReadOnly]
    def userMetadataValue
        : Option[List[io.github.vigoo.zioaws.s3.model.MetadataEntry.ReadOnly]]
    def storageClassValue: Option[io.github.vigoo.zioaws.s3.model.StorageClass]
    def bucketName: ZIO[Any, Nothing, BucketName] = ZIO.succeed(bucketNameValue)
    def prefix: ZIO[Any, Nothing, LocationPrefix] = ZIO.succeed(prefixValue)
    def encryption: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.s3.model.Encryption.ReadOnly
    ] = AwsError.unwrapOptionField("encryption", encryptionValue)
    def cannedACL
        : ZIO[Any, AwsError, io.github.vigoo.zioaws.s3.model.ObjectCannedACL] =
      AwsError.unwrapOptionField("cannedACL", cannedACLValue)
    def accessControlList: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.s3.model.Grant.ReadOnly
    ]] = AwsError.unwrapOptionField("accessControlList", accessControlListValue)
    def tagging
        : ZIO[Any, AwsError, io.github.vigoo.zioaws.s3.model.Tagging.ReadOnly] =
      AwsError.unwrapOptionField("tagging", taggingValue)
    def userMetadata: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.s3.model.MetadataEntry.ReadOnly
    ]] = AwsError.unwrapOptionField("userMetadata", userMetadataValue)
    def storageClass
        : ZIO[Any, AwsError, io.github.vigoo.zioaws.s3.model.StorageClass] =
      AwsError.unwrapOptionField("storageClass", storageClassValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.S3Location
  ) extends io.github.vigoo.zioaws.s3.model.S3Location.ReadOnly {
    override def bucketNameValue: BucketName = impl.bucketName(): BucketName
    override def prefixValue: LocationPrefix = impl.prefix(): LocationPrefix
    override def encryptionValue
        : Option[io.github.vigoo.zioaws.s3.model.Encryption.ReadOnly] = scala
      .Option(impl.encryption())
      .map(value => io.github.vigoo.zioaws.s3.model.Encryption.wrap(value))
    override def cannedACLValue
        : Option[io.github.vigoo.zioaws.s3.model.ObjectCannedACL] = scala
      .Option(impl.cannedACL())
      .map(value => io.github.vigoo.zioaws.s3.model.ObjectCannedACL.wrap(value))
    override def accessControlListValue
        : Option[List[io.github.vigoo.zioaws.s3.model.Grant.ReadOnly]] = scala
      .Option(impl.accessControlList())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.s3.model.Grant.wrap(item)
        }.toList
      )
    override def taggingValue
        : Option[io.github.vigoo.zioaws.s3.model.Tagging.ReadOnly] = scala
      .Option(impl.tagging())
      .map(value => io.github.vigoo.zioaws.s3.model.Tagging.wrap(value))
    override def userMetadataValue
        : Option[List[io.github.vigoo.zioaws.s3.model.MetadataEntry.ReadOnly]] =
      scala
        .Option(impl.userMetadata())
        .map(value =>
          value.asScala.map { item =>
            io.github.vigoo.zioaws.s3.model.MetadataEntry.wrap(item)
          }.toList
        )
    override def storageClassValue
        : Option[io.github.vigoo.zioaws.s3.model.StorageClass] = scala
      .Option(impl.storageClass())
      .map(value => io.github.vigoo.zioaws.s3.model.StorageClass.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.S3Location
  ): io.github.vigoo.zioaws.s3.model.S3Location.ReadOnly = new Wrapper(impl)
}
