package io.github.vigoo.zioaws.s3.model
import io.github.vigoo.zioaws.s3.model.primitives.{
  ETag,
  LastModified,
  ObjectKey
}
import zio.ZIO
import java.time.Instant
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class S3Object(
    key: Option[ObjectKey] = None,
    lastModified: Option[LastModified] = None,
    eTag: Option[ETag] = None,
    checksumAlgorithm: Option[
      Iterable[io.github.vigoo.zioaws.s3.model.ChecksumAlgorithm]
    ] = None,
    size: Option[Long] = None,
    storageClass: Option[io.github.vigoo.zioaws.s3.model.ObjectStorageClass] =
      None,
    owner: Option[io.github.vigoo.zioaws.s3.model.Owner] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.s3.model.S3Object = {
    import S3Object.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.S3Object
      .builder()
      .optionallyWith(key.map(value => value: java.lang.String))(_.key)
      .optionallyWith(lastModified.map(value => value: Instant))(_.lastModified)
      .optionallyWith(eTag.map(value => value: java.lang.String))(_.eTag)
      .optionallyWith(
        checksumAlgorithm.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.checksumAlgorithmWithStrings)
      .optionallyWith(size.map(value => value: java.lang.Long))(_.size)
      .optionallyWith(storageClass.map(value => value.unwrap))(_.storageClass)
      .optionallyWith(owner.map(value => value.buildAwsValue()))(_.owner)
      .build()
  }
  def asReadOnly: io.github.vigoo.zioaws.s3.model.S3Object.ReadOnly =
    io.github.vigoo.zioaws.s3.model.S3Object.wrap(buildAwsValue())
}
object S3Object {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.s3.model.S3Object] =
    BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.s3.model.S3Object =
      io.github.vigoo.zioaws.s3.model.S3Object(
        keyValue.map(value => value),
        lastModifiedValue.map(value => value),
        eTagValue.map(value => value),
        checksumAlgorithmValue.map(value => value),
        sizeValue.map(value => value),
        storageClassValue.map(value => value),
        ownerValue.map(value => value.editable)
      )
    def keyValue: Option[ObjectKey]
    def lastModifiedValue: Option[LastModified]
    def eTagValue: Option[ETag]
    def checksumAlgorithmValue
        : Option[List[io.github.vigoo.zioaws.s3.model.ChecksumAlgorithm]]
    def sizeValue: Option[Long]
    def storageClassValue
        : Option[io.github.vigoo.zioaws.s3.model.ObjectStorageClass]
    def ownerValue: Option[io.github.vigoo.zioaws.s3.model.Owner.ReadOnly]
    def key: ZIO[Any, AwsError, ObjectKey] =
      AwsError.unwrapOptionField("key", keyValue)
    def lastModified: ZIO[Any, AwsError, LastModified] =
      AwsError.unwrapOptionField("lastModified", lastModifiedValue)
    def eTag: ZIO[Any, AwsError, ETag] =
      AwsError.unwrapOptionField("eTag", eTagValue)
    def checksumAlgorithm: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.s3.model.ChecksumAlgorithm
    ]] = AwsError.unwrapOptionField("checksumAlgorithm", checksumAlgorithmValue)
    def size: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("size", sizeValue)
    def storageClass: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.s3.model.ObjectStorageClass
    ] = AwsError.unwrapOptionField("storageClass", storageClassValue)
    def owner
        : ZIO[Any, AwsError, io.github.vigoo.zioaws.s3.model.Owner.ReadOnly] =
      AwsError.unwrapOptionField("owner", ownerValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.s3.model.S3Object)
      extends io.github.vigoo.zioaws.s3.model.S3Object.ReadOnly {
    override def keyValue: Option[ObjectKey] =
      scala.Option(impl.key()).map(value => value: ObjectKey)
    override def lastModifiedValue: Option[LastModified] =
      scala.Option(impl.lastModified()).map(value => value: LastModified)
    override def eTagValue: Option[ETag] =
      scala.Option(impl.eTag()).map(value => value: ETag)
    override def checksumAlgorithmValue
        : Option[List[io.github.vigoo.zioaws.s3.model.ChecksumAlgorithm]] =
      scala
        .Option(impl.checksumAlgorithm())
        .map(value =>
          value.asScala.map { item =>
            io.github.vigoo.zioaws.s3.model.ChecksumAlgorithm.wrap(item)
          }.toList
        )
    override def sizeValue: Option[Long] =
      scala.Option(impl.size()).map(value => value: Long)
    override def storageClassValue
        : Option[io.github.vigoo.zioaws.s3.model.ObjectStorageClass] = scala
      .Option(impl.storageClass())
      .map(value =>
        io.github.vigoo.zioaws.s3.model.ObjectStorageClass.wrap(value)
      )
    override def ownerValue
        : Option[io.github.vigoo.zioaws.s3.model.Owner.ReadOnly] = scala
      .Option(impl.owner())
      .map(value => io.github.vigoo.zioaws.s3.model.Owner.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.S3Object
  ): io.github.vigoo.zioaws.s3.model.S3Object.ReadOnly = new Wrapper(impl)
}
