package io.github.vigoo.zioaws.s3.model
import io.github.vigoo.zioaws.s3.model.primitives.SSEKMSKeyId
import zio.ZIO
import io.github.vigoo.zioaws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class SSEKMS(keyId: SSEKMSKeyId) {
  def buildAwsValue(): software.amazon.awssdk.services.s3.model.SSEKMS = {
    import SSEKMS.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.SSEKMS
      .builder()
      .keyId(keyId: java.lang.String)
      .build()
  }
  def asReadOnly: io.github.vigoo.zioaws.s3.model.SSEKMS.ReadOnly =
    io.github.vigoo.zioaws.s3.model.SSEKMS.wrap(buildAwsValue())
}
object SSEKMS {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.s3.model.SSEKMS] =
    BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.s3.model.SSEKMS =
      io.github.vigoo.zioaws.s3.model.SSEKMS(keyIdValue)
    def keyIdValue: SSEKMSKeyId
    def keyId: ZIO[Any, Nothing, SSEKMSKeyId] = ZIO.succeed(keyIdValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.s3.model.SSEKMS)
      extends io.github.vigoo.zioaws.s3.model.SSEKMS.ReadOnly {
    override def keyIdValue: SSEKMSKeyId = impl.keyId(): SSEKMSKeyId
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.SSEKMS
  ): io.github.vigoo.zioaws.s3.model.SSEKMS.ReadOnly = new Wrapper(impl)
}
