package io.github.vigoo.zioaws.s3.model
import io.github.vigoo.zioaws.s3.model.primitives.{End, Start}
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ScanRange(
    start: Option[Start] = None,
    end: Option[End] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.s3.model.ScanRange = {
    import ScanRange.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.ScanRange
      .builder()
      .optionallyWith(start.map(value => value: java.lang.Long))(_.start)
      .optionallyWith(end.map(value => value: java.lang.Long))(_.end)
      .build()
  }
  def asReadOnly: io.github.vigoo.zioaws.s3.model.ScanRange.ReadOnly =
    io.github.vigoo.zioaws.s3.model.ScanRange.wrap(buildAwsValue())
}
object ScanRange {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.s3.model.ScanRange] =
    BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.s3.model.ScanRange =
      io.github.vigoo.zioaws.s3.model
        .ScanRange(startValue.map(value => value), endValue.map(value => value))
    def startValue: Option[Start]
    def endValue: Option[End]
    def start: ZIO[Any, AwsError, Start] =
      AwsError.unwrapOptionField("start", startValue)
    def end: ZIO[Any, AwsError, End] =
      AwsError.unwrapOptionField("end", endValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.ScanRange
  ) extends io.github.vigoo.zioaws.s3.model.ScanRange.ReadOnly {
    override def startValue: Option[Start] =
      scala.Option(impl.start()).map(value => value: Start)
    override def endValue: Option[End] =
      scala.Option(impl.end()).map(value => value: End)
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.ScanRange
  ): io.github.vigoo.zioaws.s3.model.ScanRange.ReadOnly = new Wrapper(impl)
}
