package io.github.vigoo.zioaws.s3.model
import io.github.vigoo.zioaws.s3.model.primitives.{
  SSECustomerKey,
  AccountId,
  SSECustomerAlgorithm,
  SSECustomerKeyMD5,
  Expression,
  ObjectKey,
  BucketName
}
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class SelectObjectContentRequest(
    bucket: BucketName,
    key: ObjectKey,
    sseCustomerAlgorithm: Option[SSECustomerAlgorithm] = None,
    sseCustomerKey: Option[SSECustomerKey] = None,
    sseCustomerKeyMD5: Option[SSECustomerKeyMD5] = None,
    expression: Expression,
    expressionType: io.github.vigoo.zioaws.s3.model.ExpressionType,
    requestProgress: Option[io.github.vigoo.zioaws.s3.model.RequestProgress] =
      None,
    inputSerialization: io.github.vigoo.zioaws.s3.model.InputSerialization,
    outputSerialization: io.github.vigoo.zioaws.s3.model.OutputSerialization,
    scanRange: Option[io.github.vigoo.zioaws.s3.model.ScanRange] = None,
    expectedBucketOwner: Option[AccountId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.SelectObjectContentRequest = {
    import SelectObjectContentRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.SelectObjectContentRequest
      .builder()
      .bucket(bucket: java.lang.String)
      .key(key: java.lang.String)
      .optionallyWith(
        sseCustomerAlgorithm.map(value => value: java.lang.String)
      )(_.sseCustomerAlgorithm)
      .optionallyWith(sseCustomerKey.map(value => value: java.lang.String))(
        _.sseCustomerKey
      )
      .optionallyWith(sseCustomerKeyMD5.map(value => value: java.lang.String))(
        _.sseCustomerKeyMD5
      )
      .expression(expression: java.lang.String)
      .expressionType(expressionType.unwrap)
      .optionallyWith(requestProgress.map(value => value.buildAwsValue()))(
        _.requestProgress
      )
      .inputSerialization(inputSerialization.buildAwsValue())
      .outputSerialization(outputSerialization.buildAwsValue())
      .optionallyWith(scanRange.map(value => value.buildAwsValue()))(
        _.scanRange
      )
      .optionallyWith(
        expectedBucketOwner.map(value => value: java.lang.String)
      )(_.expectedBucketOwner)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.s3.model.SelectObjectContentRequest.ReadOnly =
    io.github.vigoo.zioaws.s3.model.SelectObjectContentRequest
      .wrap(buildAwsValue())
}
object SelectObjectContentRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.SelectObjectContentRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.s3.model.SelectObjectContentRequest =
      io.github.vigoo.zioaws.s3.model.SelectObjectContentRequest(
        bucketValue,
        keyValue,
        sseCustomerAlgorithmValue.map(value => value),
        sseCustomerKeyValue.map(value => value),
        sseCustomerKeyMD5Value.map(value => value),
        expressionValue,
        expressionTypeValue,
        requestProgressValue.map(value => value.editable),
        inputSerializationValue.editable,
        outputSerializationValue.editable,
        scanRangeValue.map(value => value.editable),
        expectedBucketOwnerValue.map(value => value)
      )
    def bucketValue: BucketName
    def keyValue: ObjectKey
    def sseCustomerAlgorithmValue: Option[SSECustomerAlgorithm]
    def sseCustomerKeyValue: Option[SSECustomerKey]
    def sseCustomerKeyMD5Value: Option[SSECustomerKeyMD5]
    def expressionValue: Expression
    def expressionTypeValue: io.github.vigoo.zioaws.s3.model.ExpressionType
    def requestProgressValue
        : Option[io.github.vigoo.zioaws.s3.model.RequestProgress.ReadOnly]
    def inputSerializationValue
        : io.github.vigoo.zioaws.s3.model.InputSerialization.ReadOnly
    def outputSerializationValue
        : io.github.vigoo.zioaws.s3.model.OutputSerialization.ReadOnly
    def scanRangeValue
        : Option[io.github.vigoo.zioaws.s3.model.ScanRange.ReadOnly]
    def expectedBucketOwnerValue: Option[AccountId]
    def bucket: ZIO[Any, Nothing, BucketName] = ZIO.succeed(bucketValue)
    def key: ZIO[Any, Nothing, ObjectKey] = ZIO.succeed(keyValue)
    def sseCustomerAlgorithm: ZIO[Any, AwsError, SSECustomerAlgorithm] =
      AwsError.unwrapOptionField(
        "sseCustomerAlgorithm",
        sseCustomerAlgorithmValue
      )
    def sseCustomerKey: ZIO[Any, AwsError, SSECustomerKey] =
      AwsError.unwrapOptionField("sseCustomerKey", sseCustomerKeyValue)
    def sseCustomerKeyMD5: ZIO[Any, AwsError, SSECustomerKeyMD5] =
      AwsError.unwrapOptionField("sseCustomerKeyMD5", sseCustomerKeyMD5Value)
    def expression: ZIO[Any, Nothing, Expression] = ZIO.succeed(expressionValue)
    def expressionType
        : ZIO[Any, Nothing, io.github.vigoo.zioaws.s3.model.ExpressionType] =
      ZIO.succeed(expressionTypeValue)
    def requestProgress: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.s3.model.RequestProgress.ReadOnly
    ] = AwsError.unwrapOptionField("requestProgress", requestProgressValue)
    def inputSerialization: ZIO[
      Any,
      Nothing,
      io.github.vigoo.zioaws.s3.model.InputSerialization.ReadOnly
    ] = ZIO.succeed(inputSerializationValue)
    def outputSerialization: ZIO[
      Any,
      Nothing,
      io.github.vigoo.zioaws.s3.model.OutputSerialization.ReadOnly
    ] = ZIO.succeed(outputSerializationValue)
    def scanRange: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.s3.model.ScanRange.ReadOnly
    ] = AwsError.unwrapOptionField("scanRange", scanRangeValue)
    def expectedBucketOwner: ZIO[Any, AwsError, AccountId] = AwsError
      .unwrapOptionField("expectedBucketOwner", expectedBucketOwnerValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.SelectObjectContentRequest
  ) extends io.github.vigoo.zioaws.s3.model.SelectObjectContentRequest.ReadOnly {
    override def bucketValue: BucketName = impl.bucket(): BucketName
    override def keyValue: ObjectKey = impl.key(): ObjectKey
    override def sseCustomerAlgorithmValue: Option[SSECustomerAlgorithm] = scala
      .Option(impl.sseCustomerAlgorithm())
      .map(value => value: SSECustomerAlgorithm)
    override def sseCustomerKeyValue: Option[SSECustomerKey] =
      scala.Option(impl.sseCustomerKey()).map(value => value: SSECustomerKey)
    override def sseCustomerKeyMD5Value: Option[SSECustomerKeyMD5] = scala
      .Option(impl.sseCustomerKeyMD5())
      .map(value => value: SSECustomerKeyMD5)
    override def expressionValue: Expression = impl.expression(): Expression
    override def expressionTypeValue
        : io.github.vigoo.zioaws.s3.model.ExpressionType =
      io.github.vigoo.zioaws.s3.model.ExpressionType.wrap(impl.expressionType())
    override def requestProgressValue
        : Option[io.github.vigoo.zioaws.s3.model.RequestProgress.ReadOnly] =
      scala
        .Option(impl.requestProgress())
        .map(value =>
          io.github.vigoo.zioaws.s3.model.RequestProgress.wrap(value)
        )
    override def inputSerializationValue
        : io.github.vigoo.zioaws.s3.model.InputSerialization.ReadOnly =
      io.github.vigoo.zioaws.s3.model.InputSerialization
        .wrap(impl.inputSerialization())
    override def outputSerializationValue
        : io.github.vigoo.zioaws.s3.model.OutputSerialization.ReadOnly =
      io.github.vigoo.zioaws.s3.model.OutputSerialization
        .wrap(impl.outputSerialization())
    override def scanRangeValue
        : Option[io.github.vigoo.zioaws.s3.model.ScanRange.ReadOnly] = scala
      .Option(impl.scanRange())
      .map(value => io.github.vigoo.zioaws.s3.model.ScanRange.wrap(value))
    override def expectedBucketOwnerValue: Option[AccountId] =
      scala.Option(impl.expectedBucketOwner()).map(value => value: AccountId)
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.SelectObjectContentRequest
  ): io.github.vigoo.zioaws.s3.model.SelectObjectContentRequest.ReadOnly =
    new Wrapper(impl)
}
