package io.github.vigoo.zioaws.s3.model
import io.github.vigoo.zioaws.s3.model.primitives.Expression
import zio.ZIO
import io.github.vigoo.zioaws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class SelectParameters(
    inputSerialization: io.github.vigoo.zioaws.s3.model.InputSerialization,
    expressionType: io.github.vigoo.zioaws.s3.model.ExpressionType,
    expression: Expression,
    outputSerialization: io.github.vigoo.zioaws.s3.model.OutputSerialization
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.SelectParameters = {
    import SelectParameters.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.SelectParameters
      .builder()
      .inputSerialization(inputSerialization.buildAwsValue())
      .expressionType(expressionType.unwrap)
      .expression(expression: java.lang.String)
      .outputSerialization(outputSerialization.buildAwsValue())
      .build()
  }
  def asReadOnly: io.github.vigoo.zioaws.s3.model.SelectParameters.ReadOnly =
    io.github.vigoo.zioaws.s3.model.SelectParameters.wrap(buildAwsValue())
}
object SelectParameters {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.SelectParameters
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.s3.model.SelectParameters =
      io.github.vigoo.zioaws.s3.model.SelectParameters(
        inputSerializationValue.editable,
        expressionTypeValue,
        expressionValue,
        outputSerializationValue.editable
      )
    def inputSerializationValue
        : io.github.vigoo.zioaws.s3.model.InputSerialization.ReadOnly
    def expressionTypeValue: io.github.vigoo.zioaws.s3.model.ExpressionType
    def expressionValue: Expression
    def outputSerializationValue
        : io.github.vigoo.zioaws.s3.model.OutputSerialization.ReadOnly
    def inputSerialization: ZIO[
      Any,
      Nothing,
      io.github.vigoo.zioaws.s3.model.InputSerialization.ReadOnly
    ] = ZIO.succeed(inputSerializationValue)
    def expressionType
        : ZIO[Any, Nothing, io.github.vigoo.zioaws.s3.model.ExpressionType] =
      ZIO.succeed(expressionTypeValue)
    def expression: ZIO[Any, Nothing, Expression] = ZIO.succeed(expressionValue)
    def outputSerialization: ZIO[
      Any,
      Nothing,
      io.github.vigoo.zioaws.s3.model.OutputSerialization.ReadOnly
    ] = ZIO.succeed(outputSerializationValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.SelectParameters
  ) extends io.github.vigoo.zioaws.s3.model.SelectParameters.ReadOnly {
    override def inputSerializationValue
        : io.github.vigoo.zioaws.s3.model.InputSerialization.ReadOnly =
      io.github.vigoo.zioaws.s3.model.InputSerialization
        .wrap(impl.inputSerialization())
    override def expressionTypeValue
        : io.github.vigoo.zioaws.s3.model.ExpressionType =
      io.github.vigoo.zioaws.s3.model.ExpressionType.wrap(impl.expressionType())
    override def expressionValue: Expression = impl.expression(): Expression
    override def outputSerializationValue
        : io.github.vigoo.zioaws.s3.model.OutputSerialization.ReadOnly =
      io.github.vigoo.zioaws.s3.model.OutputSerialization
        .wrap(impl.outputSerialization())
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.SelectParameters
  ): io.github.vigoo.zioaws.s3.model.SelectParameters.ReadOnly = new Wrapper(
    impl
  )
}
