package io.github.vigoo.zioaws.s3.model
import io.github.vigoo.zioaws.s3.model.primitives.SSEKMSKeyId
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ServerSideEncryptionByDefault(
    sseAlgorithm: io.github.vigoo.zioaws.s3.model.ServerSideEncryption,
    kmsMasterKeyID: Option[SSEKMSKeyId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.ServerSideEncryptionByDefault = {
    import ServerSideEncryptionByDefault.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.ServerSideEncryptionByDefault
      .builder()
      .sseAlgorithm(sseAlgorithm.unwrap)
      .optionallyWith(kmsMasterKeyID.map(value => value: java.lang.String))(
        _.kmsMasterKeyID
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.s3.model.ServerSideEncryptionByDefault.ReadOnly =
    io.github.vigoo.zioaws.s3.model.ServerSideEncryptionByDefault
      .wrap(buildAwsValue())
}
object ServerSideEncryptionByDefault {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.ServerSideEncryptionByDefault
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.s3.model.ServerSideEncryptionByDefault =
      io.github.vigoo.zioaws.s3.model.ServerSideEncryptionByDefault(
        sseAlgorithmValue,
        kmsMasterKeyIDValue.map(value => value)
      )
    def sseAlgorithmValue: io.github.vigoo.zioaws.s3.model.ServerSideEncryption
    def kmsMasterKeyIDValue: Option[SSEKMSKeyId]
    def sseAlgorithm: ZIO[
      Any,
      Nothing,
      io.github.vigoo.zioaws.s3.model.ServerSideEncryption
    ] = ZIO.succeed(sseAlgorithmValue)
    def kmsMasterKeyID: ZIO[Any, AwsError, SSEKMSKeyId] =
      AwsError.unwrapOptionField("kmsMasterKeyID", kmsMasterKeyIDValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.ServerSideEncryptionByDefault
  ) extends io.github.vigoo.zioaws.s3.model.ServerSideEncryptionByDefault.ReadOnly {
    override def sseAlgorithmValue
        : io.github.vigoo.zioaws.s3.model.ServerSideEncryption =
      io.github.vigoo.zioaws.s3.model.ServerSideEncryption
        .wrap(impl.sseAlgorithm())
    override def kmsMasterKeyIDValue: Option[SSEKMSKeyId] =
      scala.Option(impl.kmsMasterKeyID()).map(value => value: SSEKMSKeyId)
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.ServerSideEncryptionByDefault
  ): io.github.vigoo.zioaws.s3.model.ServerSideEncryptionByDefault.ReadOnly =
    new Wrapper(impl)
}
