package io.github.vigoo.zioaws.s3.model
import zio.ZIO
import io.github.vigoo.zioaws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class ServerSideEncryptionConfiguration(
    rules: Iterable[io.github.vigoo.zioaws.s3.model.ServerSideEncryptionRule]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.ServerSideEncryptionConfiguration = {
    import ServerSideEncryptionConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.ServerSideEncryptionConfiguration
      .builder()
      .rules(rules.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.s3.model.ServerSideEncryptionConfiguration.ReadOnly =
    io.github.vigoo.zioaws.s3.model.ServerSideEncryptionConfiguration
      .wrap(buildAwsValue())
}
object ServerSideEncryptionConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.ServerSideEncryptionConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.s3.model.ServerSideEncryptionConfiguration =
      io.github.vigoo.zioaws.s3.model
        .ServerSideEncryptionConfiguration(rulesValue.map { item =>
          item.editable
        })
    def rulesValue: List[
      io.github.vigoo.zioaws.s3.model.ServerSideEncryptionRule.ReadOnly
    ]
    def rules: ZIO[Any, Nothing, List[
      io.github.vigoo.zioaws.s3.model.ServerSideEncryptionRule.ReadOnly
    ]] = ZIO.succeed(rulesValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.ServerSideEncryptionConfiguration
  ) extends io.github.vigoo.zioaws.s3.model.ServerSideEncryptionConfiguration.ReadOnly {
    override def rulesValue: List[
      io.github.vigoo.zioaws.s3.model.ServerSideEncryptionRule.ReadOnly
    ] = impl
      .rules()
      .asScala
      .map { item =>
        io.github.vigoo.zioaws.s3.model.ServerSideEncryptionRule.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.ServerSideEncryptionConfiguration
  ): io.github.vigoo.zioaws.s3.model.ServerSideEncryptionConfiguration.ReadOnly =
    new Wrapper(impl)
}
