package io.github.vigoo.zioaws.s3.model
import io.github.vigoo.zioaws.s3.model.primitives.BucketKeyEnabled
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ServerSideEncryptionRule(
    applyServerSideEncryptionByDefault: Option[
      io.github.vigoo.zioaws.s3.model.ServerSideEncryptionByDefault
    ] = None,
    bucketKeyEnabled: Option[BucketKeyEnabled] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.ServerSideEncryptionRule = {
    import ServerSideEncryptionRule.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.ServerSideEncryptionRule
      .builder()
      .optionallyWith(
        applyServerSideEncryptionByDefault.map(value => value.buildAwsValue())
      )(_.applyServerSideEncryptionByDefault)
      .optionallyWith(bucketKeyEnabled.map(value => value: java.lang.Boolean))(
        _.bucketKeyEnabled
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.s3.model.ServerSideEncryptionRule.ReadOnly =
    io.github.vigoo.zioaws.s3.model.ServerSideEncryptionRule
      .wrap(buildAwsValue())
}
object ServerSideEncryptionRule {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.ServerSideEncryptionRule
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.s3.model.ServerSideEncryptionRule =
      io.github.vigoo.zioaws.s3.model.ServerSideEncryptionRule(
        applyServerSideEncryptionByDefaultValue.map(value => value.editable),
        bucketKeyEnabledValue.map(value => value)
      )
    def applyServerSideEncryptionByDefaultValue: Option[
      io.github.vigoo.zioaws.s3.model.ServerSideEncryptionByDefault.ReadOnly
    ]
    def bucketKeyEnabledValue: Option[BucketKeyEnabled]
    def applyServerSideEncryptionByDefault: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.s3.model.ServerSideEncryptionByDefault.ReadOnly
    ] = AwsError.unwrapOptionField(
      "applyServerSideEncryptionByDefault",
      applyServerSideEncryptionByDefaultValue
    )
    def bucketKeyEnabled: ZIO[Any, AwsError, BucketKeyEnabled] =
      AwsError.unwrapOptionField("bucketKeyEnabled", bucketKeyEnabledValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.ServerSideEncryptionRule
  ) extends io.github.vigoo.zioaws.s3.model.ServerSideEncryptionRule.ReadOnly {
    override def applyServerSideEncryptionByDefaultValue: Option[
      io.github.vigoo.zioaws.s3.model.ServerSideEncryptionByDefault.ReadOnly
    ] = scala
      .Option(impl.applyServerSideEncryptionByDefault())
      .map(value =>
        io.github.vigoo.zioaws.s3.model.ServerSideEncryptionByDefault
          .wrap(value)
      )
    override def bucketKeyEnabledValue: Option[BucketKeyEnabled] = scala
      .Option(impl.bucketKeyEnabled())
      .map(value => value: BucketKeyEnabled)
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.ServerSideEncryptionRule
  ): io.github.vigoo.zioaws.s3.model.ServerSideEncryptionRule.ReadOnly =
    new Wrapper(impl)
}
