package io.github.vigoo.zioaws.s3.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class SourceSelectionCriteria(
    sseKmsEncryptedObjects: Option[
      io.github.vigoo.zioaws.s3.model.SseKmsEncryptedObjects
    ] = None,
    replicaModifications: Option[
      io.github.vigoo.zioaws.s3.model.ReplicaModifications
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.SourceSelectionCriteria = {
    import SourceSelectionCriteria.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.SourceSelectionCriteria
      .builder()
      .optionallyWith(
        sseKmsEncryptedObjects.map(value => value.buildAwsValue())
      )(_.sseKmsEncryptedObjects)
      .optionallyWith(replicaModifications.map(value => value.buildAwsValue()))(
        _.replicaModifications
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.s3.model.SourceSelectionCriteria.ReadOnly =
    io.github.vigoo.zioaws.s3.model.SourceSelectionCriteria
      .wrap(buildAwsValue())
}
object SourceSelectionCriteria {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.SourceSelectionCriteria
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.s3.model.SourceSelectionCriteria =
      io.github.vigoo.zioaws.s3.model.SourceSelectionCriteria(
        sseKmsEncryptedObjectsValue.map(value => value.editable),
        replicaModificationsValue.map(value => value.editable)
      )
    def sseKmsEncryptedObjectsValue: Option[
      io.github.vigoo.zioaws.s3.model.SseKmsEncryptedObjects.ReadOnly
    ]
    def replicaModificationsValue
        : Option[io.github.vigoo.zioaws.s3.model.ReplicaModifications.ReadOnly]
    def sseKmsEncryptedObjects: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.s3.model.SseKmsEncryptedObjects.ReadOnly
    ] = AwsError.unwrapOptionField(
      "sseKmsEncryptedObjects",
      sseKmsEncryptedObjectsValue
    )
    def replicaModifications: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.s3.model.ReplicaModifications.ReadOnly
    ] = AwsError.unwrapOptionField(
      "replicaModifications",
      replicaModificationsValue
    )
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.SourceSelectionCriteria
  ) extends io.github.vigoo.zioaws.s3.model.SourceSelectionCriteria.ReadOnly {
    override def sseKmsEncryptedObjectsValue: Option[
      io.github.vigoo.zioaws.s3.model.SseKmsEncryptedObjects.ReadOnly
    ] = scala
      .Option(impl.sseKmsEncryptedObjects())
      .map(value =>
        io.github.vigoo.zioaws.s3.model.SseKmsEncryptedObjects.wrap(value)
      )
    override def replicaModificationsValue: Option[
      io.github.vigoo.zioaws.s3.model.ReplicaModifications.ReadOnly
    ] = scala
      .Option(impl.replicaModifications())
      .map(value =>
        io.github.vigoo.zioaws.s3.model.ReplicaModifications.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.SourceSelectionCriteria
  ): io.github.vigoo.zioaws.s3.model.SourceSelectionCriteria.ReadOnly =
    new Wrapper(impl)
}
