package io.github.vigoo.zioaws.s3.model
import zio.ZIO
import io.github.vigoo.zioaws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class SseKmsEncryptedObjects(
    status: io.github.vigoo.zioaws.s3.model.SseKmsEncryptedObjectsStatus
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.SseKmsEncryptedObjects = {
    import SseKmsEncryptedObjects.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.SseKmsEncryptedObjects
      .builder()
      .status(status.unwrap)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.s3.model.SseKmsEncryptedObjects.ReadOnly =
    io.github.vigoo.zioaws.s3.model.SseKmsEncryptedObjects.wrap(buildAwsValue())
}
object SseKmsEncryptedObjects {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.SseKmsEncryptedObjects
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.s3.model.SseKmsEncryptedObjects =
      io.github.vigoo.zioaws.s3.model.SseKmsEncryptedObjects(statusValue)
    def statusValue
        : io.github.vigoo.zioaws.s3.model.SseKmsEncryptedObjectsStatus
    def status: ZIO[
      Any,
      Nothing,
      io.github.vigoo.zioaws.s3.model.SseKmsEncryptedObjectsStatus
    ] = ZIO.succeed(statusValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.SseKmsEncryptedObjects
  ) extends io.github.vigoo.zioaws.s3.model.SseKmsEncryptedObjects.ReadOnly {
    override def statusValue
        : io.github.vigoo.zioaws.s3.model.SseKmsEncryptedObjectsStatus =
      io.github.vigoo.zioaws.s3.model.SseKmsEncryptedObjectsStatus
        .wrap(impl.status())
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.SseKmsEncryptedObjects
  ): io.github.vigoo.zioaws.s3.model.SseKmsEncryptedObjects.ReadOnly =
    new Wrapper(impl)
}
