package io.github.vigoo.zioaws.s3.model
import scala.jdk.CollectionConverters._
sealed trait SseKmsEncryptedObjectsStatus {
  def unwrap
      : software.amazon.awssdk.services.s3.model.SseKmsEncryptedObjectsStatus
}
object SseKmsEncryptedObjectsStatus {
  def wrap(
      value: software.amazon.awssdk.services.s3.model.SseKmsEncryptedObjectsStatus
  ): io.github.vigoo.zioaws.s3.model.SseKmsEncryptedObjectsStatus =
    value match {
      case software.amazon.awssdk.services.s3.model.SseKmsEncryptedObjectsStatus.UNKNOWN_TO_SDK_VERSION =>
        val r = unknownToSdkVersion
        r
      case software.amazon.awssdk.services.s3.model.SseKmsEncryptedObjectsStatus.ENABLED =>
        val r = Enabled
        r
      case software.amazon.awssdk.services.s3.model.SseKmsEncryptedObjectsStatus.DISABLED =>
        val r = Disabled
        r
    }
  case object unknownToSdkVersion
      extends io.github.vigoo.zioaws.s3.model.SseKmsEncryptedObjectsStatus {
    override def unwrap
        : software.amazon.awssdk.services.s3.model.SseKmsEncryptedObjectsStatus =
      software.amazon.awssdk.services.s3.model.SseKmsEncryptedObjectsStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object Enabled
      extends io.github.vigoo.zioaws.s3.model.SseKmsEncryptedObjectsStatus {
    override def unwrap
        : software.amazon.awssdk.services.s3.model.SseKmsEncryptedObjectsStatus =
      software.amazon.awssdk.services.s3.model.SseKmsEncryptedObjectsStatus.ENABLED
  }
  case object Disabled
      extends io.github.vigoo.zioaws.s3.model.SseKmsEncryptedObjectsStatus {
    override def unwrap
        : software.amazon.awssdk.services.s3.model.SseKmsEncryptedObjectsStatus =
      software.amazon.awssdk.services.s3.model.SseKmsEncryptedObjectsStatus.DISABLED
  }
}
