package io.github.vigoo.zioaws.s3.model
import scala.jdk.CollectionConverters._
sealed trait StorageClass {
  def unwrap: software.amazon.awssdk.services.s3.model.StorageClass
}
object StorageClass {
  def wrap(
      value: software.amazon.awssdk.services.s3.model.StorageClass
  ): io.github.vigoo.zioaws.s3.model.StorageClass = value match {
    case software.amazon.awssdk.services.s3.model.StorageClass.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.s3.model.StorageClass.STANDARD =>
      val r = STANDARD
      r
    case software.amazon.awssdk.services.s3.model.StorageClass.REDUCED_REDUNDANCY =>
      val r = REDUCED_REDUNDANCY
      r
    case software.amazon.awssdk.services.s3.model.StorageClass.STANDARD_IA =>
      val r = STANDARD_IA
      r
    case software.amazon.awssdk.services.s3.model.StorageClass.ONEZONE_IA =>
      val r = ONEZONE_IA
      r
    case software.amazon.awssdk.services.s3.model.StorageClass.INTELLIGENT_TIERING =>
      val r = INTELLIGENT_TIERING
      r
    case software.amazon.awssdk.services.s3.model.StorageClass.GLACIER =>
      val r = GLACIER
      r
    case software.amazon.awssdk.services.s3.model.StorageClass.DEEP_ARCHIVE =>
      val r = DEEP_ARCHIVE
      r
    case software.amazon.awssdk.services.s3.model.StorageClass.OUTPOSTS =>
      val r = OUTPOSTS
      r
    case software.amazon.awssdk.services.s3.model.StorageClass.GLACIER_IR =>
      val r = GLACIER_IR
      r
  }
  case object unknownToSdkVersion
      extends io.github.vigoo.zioaws.s3.model.StorageClass {
    override def unwrap: software.amazon.awssdk.services.s3.model.StorageClass =
      software.amazon.awssdk.services.s3.model.StorageClass.UNKNOWN_TO_SDK_VERSION
  }
  case object STANDARD extends io.github.vigoo.zioaws.s3.model.StorageClass {
    override def unwrap: software.amazon.awssdk.services.s3.model.StorageClass =
      software.amazon.awssdk.services.s3.model.StorageClass.STANDARD
  }
  case object REDUCED_REDUNDANCY
      extends io.github.vigoo.zioaws.s3.model.StorageClass {
    override def unwrap: software.amazon.awssdk.services.s3.model.StorageClass =
      software.amazon.awssdk.services.s3.model.StorageClass.REDUCED_REDUNDANCY
  }
  case object STANDARD_IA extends io.github.vigoo.zioaws.s3.model.StorageClass {
    override def unwrap: software.amazon.awssdk.services.s3.model.StorageClass =
      software.amazon.awssdk.services.s3.model.StorageClass.STANDARD_IA
  }
  case object ONEZONE_IA extends io.github.vigoo.zioaws.s3.model.StorageClass {
    override def unwrap: software.amazon.awssdk.services.s3.model.StorageClass =
      software.amazon.awssdk.services.s3.model.StorageClass.ONEZONE_IA
  }
  case object INTELLIGENT_TIERING
      extends io.github.vigoo.zioaws.s3.model.StorageClass {
    override def unwrap: software.amazon.awssdk.services.s3.model.StorageClass =
      software.amazon.awssdk.services.s3.model.StorageClass.INTELLIGENT_TIERING
  }
  case object GLACIER extends io.github.vigoo.zioaws.s3.model.StorageClass {
    override def unwrap: software.amazon.awssdk.services.s3.model.StorageClass =
      software.amazon.awssdk.services.s3.model.StorageClass.GLACIER
  }
  case object DEEP_ARCHIVE
      extends io.github.vigoo.zioaws.s3.model.StorageClass {
    override def unwrap: software.amazon.awssdk.services.s3.model.StorageClass =
      software.amazon.awssdk.services.s3.model.StorageClass.DEEP_ARCHIVE
  }
  case object OUTPOSTS extends io.github.vigoo.zioaws.s3.model.StorageClass {
    override def unwrap: software.amazon.awssdk.services.s3.model.StorageClass =
      software.amazon.awssdk.services.s3.model.StorageClass.OUTPOSTS
  }
  case object GLACIER_IR extends io.github.vigoo.zioaws.s3.model.StorageClass {
    override def unwrap: software.amazon.awssdk.services.s3.model.StorageClass =
      software.amazon.awssdk.services.s3.model.StorageClass.GLACIER_IR
  }
}
