package io.github.vigoo.zioaws.s3.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class StorageClassAnalysis(
    dataExport: Option[
      io.github.vigoo.zioaws.s3.model.StorageClassAnalysisDataExport
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.StorageClassAnalysis = {
    import StorageClassAnalysis.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.StorageClassAnalysis
      .builder()
      .optionallyWith(dataExport.map(value => value.buildAwsValue()))(
        _.dataExport
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.s3.model.StorageClassAnalysis.ReadOnly =
    io.github.vigoo.zioaws.s3.model.StorageClassAnalysis.wrap(buildAwsValue())
}
object StorageClassAnalysis {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.StorageClassAnalysis
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.s3.model.StorageClassAnalysis =
      io.github.vigoo.zioaws.s3.model
        .StorageClassAnalysis(dataExportValue.map(value => value.editable))
    def dataExportValue: Option[
      io.github.vigoo.zioaws.s3.model.StorageClassAnalysisDataExport.ReadOnly
    ]
    def dataExport: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.s3.model.StorageClassAnalysisDataExport.ReadOnly
    ] = AwsError.unwrapOptionField("dataExport", dataExportValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.StorageClassAnalysis
  ) extends io.github.vigoo.zioaws.s3.model.StorageClassAnalysis.ReadOnly {
    override def dataExportValue: Option[
      io.github.vigoo.zioaws.s3.model.StorageClassAnalysisDataExport.ReadOnly
    ] = scala
      .Option(impl.dataExport())
      .map(value =>
        io.github.vigoo.zioaws.s3.model.StorageClassAnalysisDataExport
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.StorageClassAnalysis
  ): io.github.vigoo.zioaws.s3.model.StorageClassAnalysis.ReadOnly =
    new Wrapper(impl)
}
