package io.github.vigoo.zioaws.s3.model
import zio.ZIO
import io.github.vigoo.zioaws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class StorageClassAnalysisDataExport(
    outputSchemaVersion: io.github.vigoo.zioaws.s3.model.StorageClassAnalysisSchemaVersion,
    destination: io.github.vigoo.zioaws.s3.model.AnalyticsExportDestination
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.StorageClassAnalysisDataExport = {
    import StorageClassAnalysisDataExport.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.StorageClassAnalysisDataExport
      .builder()
      .outputSchemaVersion(outputSchemaVersion.unwrap)
      .destination(destination.buildAwsValue())
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.s3.model.StorageClassAnalysisDataExport.ReadOnly =
    io.github.vigoo.zioaws.s3.model.StorageClassAnalysisDataExport
      .wrap(buildAwsValue())
}
object StorageClassAnalysisDataExport {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.StorageClassAnalysisDataExport
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.s3.model.StorageClassAnalysisDataExport =
      io.github.vigoo.zioaws.s3.model.StorageClassAnalysisDataExport(
        outputSchemaVersionValue,
        destinationValue.editable
      )
    def outputSchemaVersionValue
        : io.github.vigoo.zioaws.s3.model.StorageClassAnalysisSchemaVersion
    def destinationValue
        : io.github.vigoo.zioaws.s3.model.AnalyticsExportDestination.ReadOnly
    def outputSchemaVersion: ZIO[
      Any,
      Nothing,
      io.github.vigoo.zioaws.s3.model.StorageClassAnalysisSchemaVersion
    ] = ZIO.succeed(outputSchemaVersionValue)
    def destination: ZIO[
      Any,
      Nothing,
      io.github.vigoo.zioaws.s3.model.AnalyticsExportDestination.ReadOnly
    ] = ZIO.succeed(destinationValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.StorageClassAnalysisDataExport
  ) extends io.github.vigoo.zioaws.s3.model.StorageClassAnalysisDataExport.ReadOnly {
    override def outputSchemaVersionValue
        : io.github.vigoo.zioaws.s3.model.StorageClassAnalysisSchemaVersion =
      io.github.vigoo.zioaws.s3.model.StorageClassAnalysisSchemaVersion
        .wrap(impl.outputSchemaVersion())
    override def destinationValue
        : io.github.vigoo.zioaws.s3.model.AnalyticsExportDestination.ReadOnly =
      io.github.vigoo.zioaws.s3.model.AnalyticsExportDestination
        .wrap(impl.destination())
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.StorageClassAnalysisDataExport
  ): io.github.vigoo.zioaws.s3.model.StorageClassAnalysisDataExport.ReadOnly =
    new Wrapper(impl)
}
