package io.github.vigoo.zioaws.s3.model
import io.github.vigoo.zioaws.s3.model.primitives.{Value, ObjectKey}
import zio.ZIO
import io.github.vigoo.zioaws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class Tag(key: ObjectKey, value: Value) {
  def buildAwsValue(): software.amazon.awssdk.services.s3.model.Tag = {
    import Tag.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.Tag
      .builder()
      .key(key: java.lang.String)
      .value(value: java.lang.String)
      .build()
  }
  def asReadOnly: io.github.vigoo.zioaws.s3.model.Tag.ReadOnly =
    io.github.vigoo.zioaws.s3.model.Tag.wrap(buildAwsValue())
}
object Tag {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.s3.model.Tag] =
    BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.s3.model.Tag =
      io.github.vigoo.zioaws.s3.model.Tag(keyValue, valueValue)
    def keyValue: ObjectKey
    def valueValue: Value
    def key: ZIO[Any, Nothing, ObjectKey] = ZIO.succeed(keyValue)
    def value: ZIO[Any, Nothing, Value] = ZIO.succeed(valueValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.s3.model.Tag)
      extends io.github.vigoo.zioaws.s3.model.Tag.ReadOnly {
    override def keyValue: ObjectKey = impl.key(): ObjectKey
    override def valueValue: Value = impl.value(): Value
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.Tag
  ): io.github.vigoo.zioaws.s3.model.Tag.ReadOnly = new Wrapper(impl)
}
