package io.github.vigoo.zioaws.s3.model
import zio.ZIO
import io.github.vigoo.zioaws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class Tagging(
    tagSet: Iterable[io.github.vigoo.zioaws.s3.model.Tag]
) {
  def buildAwsValue(): software.amazon.awssdk.services.s3.model.Tagging = {
    import Tagging.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.Tagging
      .builder()
      .tagSet(tagSet.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: io.github.vigoo.zioaws.s3.model.Tagging.ReadOnly =
    io.github.vigoo.zioaws.s3.model.Tagging.wrap(buildAwsValue())
}
object Tagging {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.s3.model.Tagging] =
    BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.s3.model.Tagging =
      io.github.vigoo.zioaws.s3.model.Tagging(tagSetValue.map { item =>
        item.editable
      })
    def tagSetValue: List[io.github.vigoo.zioaws.s3.model.Tag.ReadOnly]
    def tagSet: ZIO[Any, Nothing, List[
      io.github.vigoo.zioaws.s3.model.Tag.ReadOnly
    ]] = ZIO.succeed(tagSetValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.s3.model.Tagging)
      extends io.github.vigoo.zioaws.s3.model.Tagging.ReadOnly {
    override def tagSetValue
        : List[io.github.vigoo.zioaws.s3.model.Tag.ReadOnly] = impl
      .tagSet()
      .asScala
      .map { item =>
        io.github.vigoo.zioaws.s3.model.Tag.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.Tagging
  ): io.github.vigoo.zioaws.s3.model.Tagging.ReadOnly = new Wrapper(impl)
}
