package io.github.vigoo.zioaws.s3.model
import scala.jdk.CollectionConverters._
sealed trait TaggingDirective {
  def unwrap: software.amazon.awssdk.services.s3.model.TaggingDirective
}
object TaggingDirective {
  def wrap(
      value: software.amazon.awssdk.services.s3.model.TaggingDirective
  ): io.github.vigoo.zioaws.s3.model.TaggingDirective = value match {
    case software.amazon.awssdk.services.s3.model.TaggingDirective.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.s3.model.TaggingDirective.COPY =>
      val r = COPY
      r
    case software.amazon.awssdk.services.s3.model.TaggingDirective.REPLACE =>
      val r = REPLACE
      r
  }
  case object unknownToSdkVersion
      extends io.github.vigoo.zioaws.s3.model.TaggingDirective {
    override def unwrap
        : software.amazon.awssdk.services.s3.model.TaggingDirective =
      software.amazon.awssdk.services.s3.model.TaggingDirective.UNKNOWN_TO_SDK_VERSION
  }
  case object COPY extends io.github.vigoo.zioaws.s3.model.TaggingDirective {
    override def unwrap
        : software.amazon.awssdk.services.s3.model.TaggingDirective =
      software.amazon.awssdk.services.s3.model.TaggingDirective.COPY
  }
  case object REPLACE extends io.github.vigoo.zioaws.s3.model.TaggingDirective {
    override def unwrap
        : software.amazon.awssdk.services.s3.model.TaggingDirective =
      software.amazon.awssdk.services.s3.model.TaggingDirective.REPLACE
  }
}
