package io.github.vigoo.zioaws.s3.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class TargetGrant(
    grantee: Option[io.github.vigoo.zioaws.s3.model.Grantee] = None,
    permission: Option[io.github.vigoo.zioaws.s3.model.BucketLogsPermission] =
      None
) {
  def buildAwsValue(): software.amazon.awssdk.services.s3.model.TargetGrant = {
    import TargetGrant.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.TargetGrant
      .builder()
      .optionallyWith(grantee.map(value => value.buildAwsValue()))(_.grantee)
      .optionallyWith(permission.map(value => value.unwrap))(_.permission)
      .build()
  }
  def asReadOnly: io.github.vigoo.zioaws.s3.model.TargetGrant.ReadOnly =
    io.github.vigoo.zioaws.s3.model.TargetGrant.wrap(buildAwsValue())
}
object TargetGrant {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.s3.model.TargetGrant] =
    BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.s3.model.TargetGrant =
      io.github.vigoo.zioaws.s3.model.TargetGrant(
        granteeValue.map(value => value.editable),
        permissionValue.map(value => value)
      )
    def granteeValue: Option[io.github.vigoo.zioaws.s3.model.Grantee.ReadOnly]
    def permissionValue
        : Option[io.github.vigoo.zioaws.s3.model.BucketLogsPermission]
    def grantee
        : ZIO[Any, AwsError, io.github.vigoo.zioaws.s3.model.Grantee.ReadOnly] =
      AwsError.unwrapOptionField("grantee", granteeValue)
    def permission: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.s3.model.BucketLogsPermission
    ] = AwsError.unwrapOptionField("permission", permissionValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.TargetGrant
  ) extends io.github.vigoo.zioaws.s3.model.TargetGrant.ReadOnly {
    override def granteeValue
        : Option[io.github.vigoo.zioaws.s3.model.Grantee.ReadOnly] = scala
      .Option(impl.grantee())
      .map(value => io.github.vigoo.zioaws.s3.model.Grantee.wrap(value))
    override def permissionValue
        : Option[io.github.vigoo.zioaws.s3.model.BucketLogsPermission] = scala
      .Option(impl.permission())
      .map(value =>
        io.github.vigoo.zioaws.s3.model.BucketLogsPermission.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.TargetGrant
  ): io.github.vigoo.zioaws.s3.model.TargetGrant.ReadOnly = new Wrapper(impl)
}
