package io.github.vigoo.zioaws.s3.model
import java.lang.Integer
import io.github.vigoo.zioaws.s3.model.primitives.IntelligentTieringDays
import zio.ZIO
import io.github.vigoo.zioaws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class Tiering(
    days: IntelligentTieringDays,
    accessTier: io.github.vigoo.zioaws.s3.model.IntelligentTieringAccessTier
) {
  def buildAwsValue(): software.amazon.awssdk.services.s3.model.Tiering = {
    import Tiering.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.Tiering
      .builder()
      .days(days: Integer)
      .accessTier(accessTier.unwrap)
      .build()
  }
  def asReadOnly: io.github.vigoo.zioaws.s3.model.Tiering.ReadOnly =
    io.github.vigoo.zioaws.s3.model.Tiering.wrap(buildAwsValue())
}
object Tiering {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.s3.model.Tiering] =
    BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.s3.model.Tiering =
      io.github.vigoo.zioaws.s3.model.Tiering(daysValue, accessTierValue)
    def daysValue: IntelligentTieringDays
    def accessTierValue
        : io.github.vigoo.zioaws.s3.model.IntelligentTieringAccessTier
    def days: ZIO[Any, Nothing, IntelligentTieringDays] = ZIO.succeed(daysValue)
    def accessTier: ZIO[
      Any,
      Nothing,
      io.github.vigoo.zioaws.s3.model.IntelligentTieringAccessTier
    ] = ZIO.succeed(accessTierValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.s3.model.Tiering)
      extends io.github.vigoo.zioaws.s3.model.Tiering.ReadOnly {
    override def daysValue: IntelligentTieringDays =
      impl.days(): IntelligentTieringDays
    override def accessTierValue
        : io.github.vigoo.zioaws.s3.model.IntelligentTieringAccessTier =
      io.github.vigoo.zioaws.s3.model.IntelligentTieringAccessTier
        .wrap(impl.accessTier())
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.Tiering
  ): io.github.vigoo.zioaws.s3.model.Tiering.ReadOnly = new Wrapper(impl)
}
