package io.github.vigoo.zioaws.s3.model
import io.github.vigoo.zioaws.s3.model.primitives.{TopicArn, NotificationId}
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class TopicConfiguration(
    id: Option[NotificationId] = None,
    topicArn: TopicArn,
    events: Iterable[io.github.vigoo.zioaws.s3.model.Event],
    filter: Option[
      io.github.vigoo.zioaws.s3.model.NotificationConfigurationFilter
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.TopicConfiguration = {
    import TopicConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.TopicConfiguration
      .builder()
      .optionallyWith(id.map(value => value: java.lang.String))(_.id)
      .topicArn(topicArn: java.lang.String)
      .eventsWithStrings(events.map { item =>
        item.unwrap.toString
      }.asJavaCollection)
      .optionallyWith(filter.map(value => value.buildAwsValue()))(_.filter)
      .build()
  }
  def asReadOnly: io.github.vigoo.zioaws.s3.model.TopicConfiguration.ReadOnly =
    io.github.vigoo.zioaws.s3.model.TopicConfiguration.wrap(buildAwsValue())
}
object TopicConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.TopicConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.s3.model.TopicConfiguration =
      io.github.vigoo.zioaws.s3.model.TopicConfiguration(
        idValue.map(value => value),
        topicArnValue,
        eventsValue,
        filterValue.map(value => value.editable)
      )
    def idValue: Option[NotificationId]
    def topicArnValue: TopicArn
    def eventsValue: List[io.github.vigoo.zioaws.s3.model.Event]
    def filterValue: Option[
      io.github.vigoo.zioaws.s3.model.NotificationConfigurationFilter.ReadOnly
    ]
    def id: ZIO[Any, AwsError, NotificationId] =
      AwsError.unwrapOptionField("id", idValue)
    def topicArn: ZIO[Any, Nothing, TopicArn] = ZIO.succeed(topicArnValue)
    def events: ZIO[Any, Nothing, List[io.github.vigoo.zioaws.s3.model.Event]] =
      ZIO.succeed(eventsValue)
    def filter: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.s3.model.NotificationConfigurationFilter.ReadOnly
    ] = AwsError.unwrapOptionField("filter", filterValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.TopicConfiguration
  ) extends io.github.vigoo.zioaws.s3.model.TopicConfiguration.ReadOnly {
    override def idValue: Option[NotificationId] =
      scala.Option(impl.id()).map(value => value: NotificationId)
    override def topicArnValue: TopicArn = impl.topicArn(): TopicArn
    override def eventsValue: List[io.github.vigoo.zioaws.s3.model.Event] = impl
      .events()
      .asScala
      .map { item =>
        io.github.vigoo.zioaws.s3.model.Event.wrap(item)
      }
      .toList
    override def filterValue: Option[
      io.github.vigoo.zioaws.s3.model.NotificationConfigurationFilter.ReadOnly
    ] = scala
      .Option(impl.filter())
      .map(value =>
        io.github.vigoo.zioaws.s3.model.NotificationConfigurationFilter
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.TopicConfiguration
  ): io.github.vigoo.zioaws.s3.model.TopicConfiguration.ReadOnly = new Wrapper(
    impl
  )
}
