package io.github.vigoo.zioaws.s3.model
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.ZIO
import io.github.vigoo.zioaws.s3.model.primitives.{Days, Date}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class Transition(
    date: Option[Date] = None,
    days: Option[Days] = None,
    storageClass: Option[
      io.github.vigoo.zioaws.s3.model.TransitionStorageClass
    ] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.s3.model.Transition = {
    import Transition.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.Transition
      .builder()
      .optionallyWith(date.map(value => value: Instant))(_.date)
      .optionallyWith(days.map(value => value: Integer))(_.days)
      .optionallyWith(storageClass.map(value => value.unwrap))(_.storageClass)
      .build()
  }
  def asReadOnly: io.github.vigoo.zioaws.s3.model.Transition.ReadOnly =
    io.github.vigoo.zioaws.s3.model.Transition.wrap(buildAwsValue())
}
object Transition {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.s3.model.Transition] =
    BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.s3.model.Transition =
      io.github.vigoo.zioaws.s3.model.Transition(
        dateValue.map(value => value),
        daysValue.map(value => value),
        storageClassValue.map(value => value)
      )
    def dateValue: Option[Date]
    def daysValue: Option[Days]
    def storageClassValue
        : Option[io.github.vigoo.zioaws.s3.model.TransitionStorageClass]
    def date: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("date", dateValue)
    def days: ZIO[Any, AwsError, Days] =
      AwsError.unwrapOptionField("days", daysValue)
    def storageClass: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.s3.model.TransitionStorageClass
    ] = AwsError.unwrapOptionField("storageClass", storageClassValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.Transition
  ) extends io.github.vigoo.zioaws.s3.model.Transition.ReadOnly {
    override def dateValue: Option[Date] =
      scala.Option(impl.date()).map(value => value: Date)
    override def daysValue: Option[Days] =
      scala.Option(impl.days()).map(value => value: Days)
    override def storageClassValue
        : Option[io.github.vigoo.zioaws.s3.model.TransitionStorageClass] = scala
      .Option(impl.storageClass())
      .map(value =>
        io.github.vigoo.zioaws.s3.model.TransitionStorageClass.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.Transition
  ): io.github.vigoo.zioaws.s3.model.Transition.ReadOnly = new Wrapper(impl)
}
