package io.github.vigoo.zioaws.s3.model
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.ZIO
import io.github.vigoo.zioaws.s3.model.primitives.{
  SSECustomerKey,
  CopySourceSSECustomerKeyMD5,
  CopySourceSSECustomerAlgorithm,
  AccountId,
  CopySourceRange,
  SSECustomerAlgorithm,
  CopySourceIfUnmodifiedSince,
  SSECustomerKeyMD5,
  CopySourceIfMatch,
  ObjectKey,
  BucketName,
  CopySourceSSECustomerKey,
  CopySourceIfNoneMatch,
  CopySourceIfModifiedSince,
  PartNumber,
  CopySource,
  MultipartUploadId
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class UploadPartCopyRequest(
    destinationBucket: BucketName,
    copySource: CopySource,
    copySourceIfMatch: Option[CopySourceIfMatch] = None,
    copySourceIfModifiedSince: Option[CopySourceIfModifiedSince] = None,
    copySourceIfNoneMatch: Option[CopySourceIfNoneMatch] = None,
    copySourceIfUnmodifiedSince: Option[CopySourceIfUnmodifiedSince] = None,
    copySourceRange: Option[CopySourceRange] = None,
    destinationKey: ObjectKey,
    partNumber: PartNumber,
    uploadId: MultipartUploadId,
    sseCustomerAlgorithm: Option[SSECustomerAlgorithm] = None,
    sseCustomerKey: Option[SSECustomerKey] = None,
    sseCustomerKeyMD5: Option[SSECustomerKeyMD5] = None,
    copySourceSSECustomerAlgorithm: Option[CopySourceSSECustomerAlgorithm] =
      None,
    copySourceSSECustomerKey: Option[CopySourceSSECustomerKey] = None,
    copySourceSSECustomerKeyMD5: Option[CopySourceSSECustomerKeyMD5] = None,
    requestPayer: Option[io.github.vigoo.zioaws.s3.model.RequestPayer] = None,
    expectedBucketOwner: Option[AccountId] = None,
    expectedSourceBucketOwner: Option[AccountId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.UploadPartCopyRequest = {
    import UploadPartCopyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.UploadPartCopyRequest
      .builder()
      .destinationBucket(destinationBucket: java.lang.String)
      .copySource(copySource: java.lang.String)
      .optionallyWith(copySourceIfMatch.map(value => value: java.lang.String))(
        _.copySourceIfMatch
      )
      .optionallyWith(copySourceIfModifiedSince.map(value => value: Instant))(
        _.copySourceIfModifiedSince
      )
      .optionallyWith(
        copySourceIfNoneMatch.map(value => value: java.lang.String)
      )(_.copySourceIfNoneMatch)
      .optionallyWith(copySourceIfUnmodifiedSince.map(value => value: Instant))(
        _.copySourceIfUnmodifiedSince
      )
      .optionallyWith(copySourceRange.map(value => value: java.lang.String))(
        _.copySourceRange
      )
      .destinationKey(destinationKey: java.lang.String)
      .partNumber(partNumber: Integer)
      .uploadId(uploadId: java.lang.String)
      .optionallyWith(
        sseCustomerAlgorithm.map(value => value: java.lang.String)
      )(_.sseCustomerAlgorithm)
      .optionallyWith(sseCustomerKey.map(value => value: java.lang.String))(
        _.sseCustomerKey
      )
      .optionallyWith(sseCustomerKeyMD5.map(value => value: java.lang.String))(
        _.sseCustomerKeyMD5
      )
      .optionallyWith(
        copySourceSSECustomerAlgorithm.map(value => value: java.lang.String)
      )(_.copySourceSSECustomerAlgorithm)
      .optionallyWith(
        copySourceSSECustomerKey.map(value => value: java.lang.String)
      )(_.copySourceSSECustomerKey)
      .optionallyWith(
        copySourceSSECustomerKeyMD5.map(value => value: java.lang.String)
      )(_.copySourceSSECustomerKeyMD5)
      .optionallyWith(requestPayer.map(value => value.unwrap))(_.requestPayer)
      .optionallyWith(
        expectedBucketOwner.map(value => value: java.lang.String)
      )(_.expectedBucketOwner)
      .optionallyWith(
        expectedSourceBucketOwner.map(value => value: java.lang.String)
      )(_.expectedSourceBucketOwner)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.s3.model.UploadPartCopyRequest.ReadOnly =
    io.github.vigoo.zioaws.s3.model.UploadPartCopyRequest.wrap(buildAwsValue())
}
object UploadPartCopyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.UploadPartCopyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.s3.model.UploadPartCopyRequest =
      io.github.vigoo.zioaws.s3.model.UploadPartCopyRequest(
        destinationBucketValue,
        copySourceValue,
        copySourceIfMatchValue.map(value => value),
        copySourceIfModifiedSinceValue.map(value => value),
        copySourceIfNoneMatchValue.map(value => value),
        copySourceIfUnmodifiedSinceValue.map(value => value),
        copySourceRangeValue.map(value => value),
        destinationKeyValue,
        partNumberValue,
        uploadIdValue,
        sseCustomerAlgorithmValue.map(value => value),
        sseCustomerKeyValue.map(value => value),
        sseCustomerKeyMD5Value.map(value => value),
        copySourceSSECustomerAlgorithmValue.map(value => value),
        copySourceSSECustomerKeyValue.map(value => value),
        copySourceSSECustomerKeyMD5Value.map(value => value),
        requestPayerValue.map(value => value),
        expectedBucketOwnerValue.map(value => value),
        expectedSourceBucketOwnerValue.map(value => value)
      )
    def destinationBucketValue: BucketName
    def copySourceValue: CopySource
    def copySourceIfMatchValue: Option[CopySourceIfMatch]
    def copySourceIfModifiedSinceValue: Option[CopySourceIfModifiedSince]
    def copySourceIfNoneMatchValue: Option[CopySourceIfNoneMatch]
    def copySourceIfUnmodifiedSinceValue: Option[CopySourceIfUnmodifiedSince]
    def copySourceRangeValue: Option[CopySourceRange]
    def destinationKeyValue: ObjectKey
    def partNumberValue: PartNumber
    def uploadIdValue: MultipartUploadId
    def sseCustomerAlgorithmValue: Option[SSECustomerAlgorithm]
    def sseCustomerKeyValue: Option[SSECustomerKey]
    def sseCustomerKeyMD5Value: Option[SSECustomerKeyMD5]
    def copySourceSSECustomerAlgorithmValue
        : Option[CopySourceSSECustomerAlgorithm]
    def copySourceSSECustomerKeyValue: Option[CopySourceSSECustomerKey]
    def copySourceSSECustomerKeyMD5Value: Option[CopySourceSSECustomerKeyMD5]
    def requestPayerValue: Option[io.github.vigoo.zioaws.s3.model.RequestPayer]
    def expectedBucketOwnerValue: Option[AccountId]
    def expectedSourceBucketOwnerValue: Option[AccountId]
    def destinationBucket: ZIO[Any, Nothing, BucketName] =
      ZIO.succeed(destinationBucketValue)
    def copySource: ZIO[Any, Nothing, CopySource] = ZIO.succeed(copySourceValue)
    def copySourceIfMatch: ZIO[Any, AwsError, CopySourceIfMatch] =
      AwsError.unwrapOptionField("copySourceIfMatch", copySourceIfMatchValue)
    def copySourceIfModifiedSince
        : ZIO[Any, AwsError, CopySourceIfModifiedSince] =
      AwsError.unwrapOptionField(
        "copySourceIfModifiedSince",
        copySourceIfModifiedSinceValue
      )
    def copySourceIfNoneMatch: ZIO[Any, AwsError, CopySourceIfNoneMatch] =
      AwsError.unwrapOptionField(
        "copySourceIfNoneMatch",
        copySourceIfNoneMatchValue
      )
    def copySourceIfUnmodifiedSince
        : ZIO[Any, AwsError, CopySourceIfUnmodifiedSince] =
      AwsError.unwrapOptionField(
        "copySourceIfUnmodifiedSince",
        copySourceIfUnmodifiedSinceValue
      )
    def copySourceRange: ZIO[Any, AwsError, CopySourceRange] =
      AwsError.unwrapOptionField("copySourceRange", copySourceRangeValue)
    def destinationKey: ZIO[Any, Nothing, ObjectKey] =
      ZIO.succeed(destinationKeyValue)
    def partNumber: ZIO[Any, Nothing, PartNumber] = ZIO.succeed(partNumberValue)
    def uploadId: ZIO[Any, Nothing, MultipartUploadId] =
      ZIO.succeed(uploadIdValue)
    def sseCustomerAlgorithm: ZIO[Any, AwsError, SSECustomerAlgorithm] =
      AwsError.unwrapOptionField(
        "sseCustomerAlgorithm",
        sseCustomerAlgorithmValue
      )
    def sseCustomerKey: ZIO[Any, AwsError, SSECustomerKey] =
      AwsError.unwrapOptionField("sseCustomerKey", sseCustomerKeyValue)
    def sseCustomerKeyMD5: ZIO[Any, AwsError, SSECustomerKeyMD5] =
      AwsError.unwrapOptionField("sseCustomerKeyMD5", sseCustomerKeyMD5Value)
    def copySourceSSECustomerAlgorithm
        : ZIO[Any, AwsError, CopySourceSSECustomerAlgorithm] =
      AwsError.unwrapOptionField(
        "copySourceSSECustomerAlgorithm",
        copySourceSSECustomerAlgorithmValue
      )
    def copySourceSSECustomerKey: ZIO[Any, AwsError, CopySourceSSECustomerKey] =
      AwsError.unwrapOptionField(
        "copySourceSSECustomerKey",
        copySourceSSECustomerKeyValue
      )
    def copySourceSSECustomerKeyMD5
        : ZIO[Any, AwsError, CopySourceSSECustomerKeyMD5] =
      AwsError.unwrapOptionField(
        "copySourceSSECustomerKeyMD5",
        copySourceSSECustomerKeyMD5Value
      )
    def requestPayer
        : ZIO[Any, AwsError, io.github.vigoo.zioaws.s3.model.RequestPayer] =
      AwsError.unwrapOptionField("requestPayer", requestPayerValue)
    def expectedBucketOwner: ZIO[Any, AwsError, AccountId] = AwsError
      .unwrapOptionField("expectedBucketOwner", expectedBucketOwnerValue)
    def expectedSourceBucketOwner: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField(
        "expectedSourceBucketOwner",
        expectedSourceBucketOwnerValue
      )
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.UploadPartCopyRequest
  ) extends io.github.vigoo.zioaws.s3.model.UploadPartCopyRequest.ReadOnly {
    override def destinationBucketValue: BucketName =
      impl.destinationBucket(): BucketName
    override def copySourceValue: CopySource = impl.copySource(): CopySource
    override def copySourceIfMatchValue: Option[CopySourceIfMatch] = scala
      .Option(impl.copySourceIfMatch())
      .map(value => value: CopySourceIfMatch)
    override def copySourceIfModifiedSinceValue
        : Option[CopySourceIfModifiedSince] = scala
      .Option(impl.copySourceIfModifiedSince())
      .map(value => value: CopySourceIfModifiedSince)
    override def copySourceIfNoneMatchValue: Option[CopySourceIfNoneMatch] =
      scala
        .Option(impl.copySourceIfNoneMatch())
        .map(value => value: CopySourceIfNoneMatch)
    override def copySourceIfUnmodifiedSinceValue
        : Option[CopySourceIfUnmodifiedSince] = scala
      .Option(impl.copySourceIfUnmodifiedSince())
      .map(value => value: CopySourceIfUnmodifiedSince)
    override def copySourceRangeValue: Option[CopySourceRange] =
      scala.Option(impl.copySourceRange()).map(value => value: CopySourceRange)
    override def destinationKeyValue: ObjectKey =
      impl.destinationKey(): ObjectKey
    override def partNumberValue: PartNumber = impl.partNumber(): PartNumber
    override def uploadIdValue: MultipartUploadId =
      impl.uploadId(): MultipartUploadId
    override def sseCustomerAlgorithmValue: Option[SSECustomerAlgorithm] = scala
      .Option(impl.sseCustomerAlgorithm())
      .map(value => value: SSECustomerAlgorithm)
    override def sseCustomerKeyValue: Option[SSECustomerKey] =
      scala.Option(impl.sseCustomerKey()).map(value => value: SSECustomerKey)
    override def sseCustomerKeyMD5Value: Option[SSECustomerKeyMD5] = scala
      .Option(impl.sseCustomerKeyMD5())
      .map(value => value: SSECustomerKeyMD5)
    override def copySourceSSECustomerAlgorithmValue
        : Option[CopySourceSSECustomerAlgorithm] = scala
      .Option(impl.copySourceSSECustomerAlgorithm())
      .map(value => value: CopySourceSSECustomerAlgorithm)
    override def copySourceSSECustomerKeyValue
        : Option[CopySourceSSECustomerKey] = scala
      .Option(impl.copySourceSSECustomerKey())
      .map(value => value: CopySourceSSECustomerKey)
    override def copySourceSSECustomerKeyMD5Value
        : Option[CopySourceSSECustomerKeyMD5] = scala
      .Option(impl.copySourceSSECustomerKeyMD5())
      .map(value => value: CopySourceSSECustomerKeyMD5)
    override def requestPayerValue
        : Option[io.github.vigoo.zioaws.s3.model.RequestPayer] = scala
      .Option(impl.requestPayer())
      .map(value => io.github.vigoo.zioaws.s3.model.RequestPayer.wrap(value))
    override def expectedBucketOwnerValue: Option[AccountId] =
      scala.Option(impl.expectedBucketOwner()).map(value => value: AccountId)
    override def expectedSourceBucketOwnerValue: Option[AccountId] = scala
      .Option(impl.expectedSourceBucketOwner())
      .map(value => value: AccountId)
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.UploadPartCopyRequest
  ): io.github.vigoo.zioaws.s3.model.UploadPartCopyRequest.ReadOnly =
    new Wrapper(impl)
}
