package io.github.vigoo.zioaws.s3.model
import io.github.vigoo.zioaws.s3.model.primitives.{
  SSECustomerAlgorithm,
  SSECustomerKeyMD5,
  SSEKMSKeyId,
  CopySourceVersionId,
  BucketKeyEnabled
}
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class UploadPartCopyResponse(
    copySourceVersionId: Option[CopySourceVersionId] = None,
    copyPartResult: Option[io.github.vigoo.zioaws.s3.model.CopyPartResult] =
      None,
    serverSideEncryption: Option[
      io.github.vigoo.zioaws.s3.model.ServerSideEncryption
    ] = None,
    sseCustomerAlgorithm: Option[SSECustomerAlgorithm] = None,
    sseCustomerKeyMD5: Option[SSECustomerKeyMD5] = None,
    ssekmsKeyId: Option[SSEKMSKeyId] = None,
    bucketKeyEnabled: Option[BucketKeyEnabled] = None,
    requestCharged: Option[io.github.vigoo.zioaws.s3.model.RequestCharged] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.UploadPartCopyResponse = {
    import UploadPartCopyResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.UploadPartCopyResponse
      .builder()
      .optionallyWith(
        copySourceVersionId.map(value => value: java.lang.String)
      )(_.copySourceVersionId)
      .optionallyWith(copyPartResult.map(value => value.buildAwsValue()))(
        _.copyPartResult
      )
      .optionallyWith(serverSideEncryption.map(value => value.unwrap))(
        _.serverSideEncryption
      )
      .optionallyWith(
        sseCustomerAlgorithm.map(value => value: java.lang.String)
      )(_.sseCustomerAlgorithm)
      .optionallyWith(sseCustomerKeyMD5.map(value => value: java.lang.String))(
        _.sseCustomerKeyMD5
      )
      .optionallyWith(ssekmsKeyId.map(value => value: java.lang.String))(
        _.ssekmsKeyId
      )
      .optionallyWith(bucketKeyEnabled.map(value => value: java.lang.Boolean))(
        _.bucketKeyEnabled
      )
      .optionallyWith(requestCharged.map(value => value.unwrap))(
        _.requestCharged
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.s3.model.UploadPartCopyResponse.ReadOnly =
    io.github.vigoo.zioaws.s3.model.UploadPartCopyResponse.wrap(buildAwsValue())
}
object UploadPartCopyResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.UploadPartCopyResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.s3.model.UploadPartCopyResponse =
      io.github.vigoo.zioaws.s3.model.UploadPartCopyResponse(
        copySourceVersionIdValue.map(value => value),
        copyPartResultValue.map(value => value.editable),
        serverSideEncryptionValue.map(value => value),
        sseCustomerAlgorithmValue.map(value => value),
        sseCustomerKeyMD5Value.map(value => value),
        ssekmsKeyIdValue.map(value => value),
        bucketKeyEnabledValue.map(value => value),
        requestChargedValue.map(value => value)
      )
    def copySourceVersionIdValue: Option[CopySourceVersionId]
    def copyPartResultValue
        : Option[io.github.vigoo.zioaws.s3.model.CopyPartResult.ReadOnly]
    def serverSideEncryptionValue
        : Option[io.github.vigoo.zioaws.s3.model.ServerSideEncryption]
    def sseCustomerAlgorithmValue: Option[SSECustomerAlgorithm]
    def sseCustomerKeyMD5Value: Option[SSECustomerKeyMD5]
    def ssekmsKeyIdValue: Option[SSEKMSKeyId]
    def bucketKeyEnabledValue: Option[BucketKeyEnabled]
    def requestChargedValue
        : Option[io.github.vigoo.zioaws.s3.model.RequestCharged]
    def copySourceVersionId: ZIO[Any, AwsError, CopySourceVersionId] = AwsError
      .unwrapOptionField("copySourceVersionId", copySourceVersionIdValue)
    def copyPartResult: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.s3.model.CopyPartResult.ReadOnly
    ] = AwsError.unwrapOptionField("copyPartResult", copyPartResultValue)
    def serverSideEncryption: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.s3.model.ServerSideEncryption
    ] = AwsError.unwrapOptionField(
      "serverSideEncryption",
      serverSideEncryptionValue
    )
    def sseCustomerAlgorithm: ZIO[Any, AwsError, SSECustomerAlgorithm] =
      AwsError.unwrapOptionField(
        "sseCustomerAlgorithm",
        sseCustomerAlgorithmValue
      )
    def sseCustomerKeyMD5: ZIO[Any, AwsError, SSECustomerKeyMD5] =
      AwsError.unwrapOptionField("sseCustomerKeyMD5", sseCustomerKeyMD5Value)
    def ssekmsKeyId: ZIO[Any, AwsError, SSEKMSKeyId] =
      AwsError.unwrapOptionField("ssekmsKeyId", ssekmsKeyIdValue)
    def bucketKeyEnabled: ZIO[Any, AwsError, BucketKeyEnabled] =
      AwsError.unwrapOptionField("bucketKeyEnabled", bucketKeyEnabledValue)
    def requestCharged
        : ZIO[Any, AwsError, io.github.vigoo.zioaws.s3.model.RequestCharged] =
      AwsError.unwrapOptionField("requestCharged", requestChargedValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.UploadPartCopyResponse
  ) extends io.github.vigoo.zioaws.s3.model.UploadPartCopyResponse.ReadOnly {
    override def copySourceVersionIdValue: Option[CopySourceVersionId] = scala
      .Option(impl.copySourceVersionId())
      .map(value => value: CopySourceVersionId)
    override def copyPartResultValue
        : Option[io.github.vigoo.zioaws.s3.model.CopyPartResult.ReadOnly] =
      scala
        .Option(impl.copyPartResult())
        .map(value =>
          io.github.vigoo.zioaws.s3.model.CopyPartResult.wrap(value)
        )
    override def serverSideEncryptionValue
        : Option[io.github.vigoo.zioaws.s3.model.ServerSideEncryption] = scala
      .Option(impl.serverSideEncryption())
      .map(value =>
        io.github.vigoo.zioaws.s3.model.ServerSideEncryption.wrap(value)
      )
    override def sseCustomerAlgorithmValue: Option[SSECustomerAlgorithm] = scala
      .Option(impl.sseCustomerAlgorithm())
      .map(value => value: SSECustomerAlgorithm)
    override def sseCustomerKeyMD5Value: Option[SSECustomerKeyMD5] = scala
      .Option(impl.sseCustomerKeyMD5())
      .map(value => value: SSECustomerKeyMD5)
    override def ssekmsKeyIdValue: Option[SSEKMSKeyId] =
      scala.Option(impl.ssekmsKeyId()).map(value => value: SSEKMSKeyId)
    override def bucketKeyEnabledValue: Option[BucketKeyEnabled] = scala
      .Option(impl.bucketKeyEnabled())
      .map(value => value: BucketKeyEnabled)
    override def requestChargedValue
        : Option[io.github.vigoo.zioaws.s3.model.RequestCharged] = scala
      .Option(impl.requestCharged())
      .map(value => io.github.vigoo.zioaws.s3.model.RequestCharged.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.UploadPartCopyResponse
  ): io.github.vigoo.zioaws.s3.model.UploadPartCopyResponse.ReadOnly =
    new Wrapper(impl)
}
