package io.github.vigoo.zioaws.s3.model
import java.lang.Integer
import io.github.vigoo.zioaws.s3.model.primitives.{
  SSECustomerKey,
  ContentMD5,
  ContentLength,
  AccountId,
  SSECustomerAlgorithm,
  SSECustomerKeyMD5,
  ChecksumSHA256,
  ChecksumCRC32C,
  ObjectKey,
  ChecksumCRC32,
  ChecksumSHA1,
  BucketName,
  PartNumber,
  MultipartUploadId
}
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class UploadPartRequest(
    bucket: BucketName,
    contentLength: Option[ContentLength] = None,
    contentMD5: Option[ContentMD5] = None,
    checksumAlgorithm: Option[
      io.github.vigoo.zioaws.s3.model.ChecksumAlgorithm
    ] = None,
    checksumCRC32: Option[ChecksumCRC32] = None,
    checksumCRC32C: Option[ChecksumCRC32C] = None,
    checksumSHA1: Option[ChecksumSHA1] = None,
    checksumSHA256: Option[ChecksumSHA256] = None,
    key: ObjectKey,
    partNumber: PartNumber,
    uploadId: MultipartUploadId,
    sseCustomerAlgorithm: Option[SSECustomerAlgorithm] = None,
    sseCustomerKey: Option[SSECustomerKey] = None,
    sseCustomerKeyMD5: Option[SSECustomerKeyMD5] = None,
    requestPayer: Option[io.github.vigoo.zioaws.s3.model.RequestPayer] = None,
    expectedBucketOwner: Option[AccountId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.UploadPartRequest = {
    import UploadPartRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.UploadPartRequest
      .builder()
      .bucket(bucket: java.lang.String)
      .optionallyWith(contentLength.map(value => value: java.lang.Long))(
        _.contentLength
      )
      .optionallyWith(contentMD5.map(value => value: java.lang.String))(
        _.contentMD5
      )
      .optionallyWith(checksumAlgorithm.map(value => value.unwrap))(
        _.checksumAlgorithm
      )
      .optionallyWith(checksumCRC32.map(value => value: java.lang.String))(
        _.checksumCRC32
      )
      .optionallyWith(checksumCRC32C.map(value => value: java.lang.String))(
        _.checksumCRC32C
      )
      .optionallyWith(checksumSHA1.map(value => value: java.lang.String))(
        _.checksumSHA1
      )
      .optionallyWith(checksumSHA256.map(value => value: java.lang.String))(
        _.checksumSHA256
      )
      .key(key: java.lang.String)
      .partNumber(partNumber: Integer)
      .uploadId(uploadId: java.lang.String)
      .optionallyWith(
        sseCustomerAlgorithm.map(value => value: java.lang.String)
      )(_.sseCustomerAlgorithm)
      .optionallyWith(sseCustomerKey.map(value => value: java.lang.String))(
        _.sseCustomerKey
      )
      .optionallyWith(sseCustomerKeyMD5.map(value => value: java.lang.String))(
        _.sseCustomerKeyMD5
      )
      .optionallyWith(requestPayer.map(value => value.unwrap))(_.requestPayer)
      .optionallyWith(
        expectedBucketOwner.map(value => value: java.lang.String)
      )(_.expectedBucketOwner)
      .build()
  }
  def asReadOnly: io.github.vigoo.zioaws.s3.model.UploadPartRequest.ReadOnly =
    io.github.vigoo.zioaws.s3.model.UploadPartRequest.wrap(buildAwsValue())
}
object UploadPartRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.UploadPartRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.s3.model.UploadPartRequest =
      io.github.vigoo.zioaws.s3.model.UploadPartRequest(
        bucketValue,
        contentLengthValue.map(value => value),
        contentMD5Value.map(value => value),
        checksumAlgorithmValue.map(value => value),
        checksumCRC32Value.map(value => value),
        checksumCRC32CValue.map(value => value),
        checksumSHA1Value.map(value => value),
        checksumSHA256Value.map(value => value),
        keyValue,
        partNumberValue,
        uploadIdValue,
        sseCustomerAlgorithmValue.map(value => value),
        sseCustomerKeyValue.map(value => value),
        sseCustomerKeyMD5Value.map(value => value),
        requestPayerValue.map(value => value),
        expectedBucketOwnerValue.map(value => value)
      )
    def bucketValue: BucketName
    def contentLengthValue: Option[ContentLength]
    def contentMD5Value: Option[ContentMD5]
    def checksumAlgorithmValue
        : Option[io.github.vigoo.zioaws.s3.model.ChecksumAlgorithm]
    def checksumCRC32Value: Option[ChecksumCRC32]
    def checksumCRC32CValue: Option[ChecksumCRC32C]
    def checksumSHA1Value: Option[ChecksumSHA1]
    def checksumSHA256Value: Option[ChecksumSHA256]
    def keyValue: ObjectKey
    def partNumberValue: PartNumber
    def uploadIdValue: MultipartUploadId
    def sseCustomerAlgorithmValue: Option[SSECustomerAlgorithm]
    def sseCustomerKeyValue: Option[SSECustomerKey]
    def sseCustomerKeyMD5Value: Option[SSECustomerKeyMD5]
    def requestPayerValue: Option[io.github.vigoo.zioaws.s3.model.RequestPayer]
    def expectedBucketOwnerValue: Option[AccountId]
    def bucket: ZIO[Any, Nothing, BucketName] = ZIO.succeed(bucketValue)
    def contentLength: ZIO[Any, AwsError, ContentLength] =
      AwsError.unwrapOptionField("contentLength", contentLengthValue)
    def contentMD5: ZIO[Any, AwsError, ContentMD5] =
      AwsError.unwrapOptionField("contentMD5", contentMD5Value)
    def checksumAlgorithm: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.s3.model.ChecksumAlgorithm
    ] = AwsError.unwrapOptionField("checksumAlgorithm", checksumAlgorithmValue)
    def checksumCRC32: ZIO[Any, AwsError, ChecksumCRC32] =
      AwsError.unwrapOptionField("checksumCRC32", checksumCRC32Value)
    def checksumCRC32C: ZIO[Any, AwsError, ChecksumCRC32C] =
      AwsError.unwrapOptionField("checksumCRC32C", checksumCRC32CValue)
    def checksumSHA1: ZIO[Any, AwsError, ChecksumSHA1] =
      AwsError.unwrapOptionField("checksumSHA1", checksumSHA1Value)
    def checksumSHA256: ZIO[Any, AwsError, ChecksumSHA256] =
      AwsError.unwrapOptionField("checksumSHA256", checksumSHA256Value)
    def key: ZIO[Any, Nothing, ObjectKey] = ZIO.succeed(keyValue)
    def partNumber: ZIO[Any, Nothing, PartNumber] = ZIO.succeed(partNumberValue)
    def uploadId: ZIO[Any, Nothing, MultipartUploadId] =
      ZIO.succeed(uploadIdValue)
    def sseCustomerAlgorithm: ZIO[Any, AwsError, SSECustomerAlgorithm] =
      AwsError.unwrapOptionField(
        "sseCustomerAlgorithm",
        sseCustomerAlgorithmValue
      )
    def sseCustomerKey: ZIO[Any, AwsError, SSECustomerKey] =
      AwsError.unwrapOptionField("sseCustomerKey", sseCustomerKeyValue)
    def sseCustomerKeyMD5: ZIO[Any, AwsError, SSECustomerKeyMD5] =
      AwsError.unwrapOptionField("sseCustomerKeyMD5", sseCustomerKeyMD5Value)
    def requestPayer
        : ZIO[Any, AwsError, io.github.vigoo.zioaws.s3.model.RequestPayer] =
      AwsError.unwrapOptionField("requestPayer", requestPayerValue)
    def expectedBucketOwner: ZIO[Any, AwsError, AccountId] = AwsError
      .unwrapOptionField("expectedBucketOwner", expectedBucketOwnerValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.UploadPartRequest
  ) extends io.github.vigoo.zioaws.s3.model.UploadPartRequest.ReadOnly {
    override def bucketValue: BucketName = impl.bucket(): BucketName
    override def contentLengthValue: Option[ContentLength] =
      scala.Option(impl.contentLength()).map(value => value: ContentLength)
    override def contentMD5Value: Option[ContentMD5] =
      scala.Option(impl.contentMD5()).map(value => value: ContentMD5)
    override def checksumAlgorithmValue
        : Option[io.github.vigoo.zioaws.s3.model.ChecksumAlgorithm] = scala
      .Option(impl.checksumAlgorithm())
      .map(value =>
        io.github.vigoo.zioaws.s3.model.ChecksumAlgorithm.wrap(value)
      )
    override def checksumCRC32Value: Option[ChecksumCRC32] =
      scala.Option(impl.checksumCRC32()).map(value => value: ChecksumCRC32)
    override def checksumCRC32CValue: Option[ChecksumCRC32C] =
      scala.Option(impl.checksumCRC32C()).map(value => value: ChecksumCRC32C)
    override def checksumSHA1Value: Option[ChecksumSHA1] =
      scala.Option(impl.checksumSHA1()).map(value => value: ChecksumSHA1)
    override def checksumSHA256Value: Option[ChecksumSHA256] =
      scala.Option(impl.checksumSHA256()).map(value => value: ChecksumSHA256)
    override def keyValue: ObjectKey = impl.key(): ObjectKey
    override def partNumberValue: PartNumber = impl.partNumber(): PartNumber
    override def uploadIdValue: MultipartUploadId =
      impl.uploadId(): MultipartUploadId
    override def sseCustomerAlgorithmValue: Option[SSECustomerAlgorithm] = scala
      .Option(impl.sseCustomerAlgorithm())
      .map(value => value: SSECustomerAlgorithm)
    override def sseCustomerKeyValue: Option[SSECustomerKey] =
      scala.Option(impl.sseCustomerKey()).map(value => value: SSECustomerKey)
    override def sseCustomerKeyMD5Value: Option[SSECustomerKeyMD5] = scala
      .Option(impl.sseCustomerKeyMD5())
      .map(value => value: SSECustomerKeyMD5)
    override def requestPayerValue
        : Option[io.github.vigoo.zioaws.s3.model.RequestPayer] = scala
      .Option(impl.requestPayer())
      .map(value => io.github.vigoo.zioaws.s3.model.RequestPayer.wrap(value))
    override def expectedBucketOwnerValue: Option[AccountId] =
      scala.Option(impl.expectedBucketOwner()).map(value => value: AccountId)
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.UploadPartRequest
  ): io.github.vigoo.zioaws.s3.model.UploadPartRequest.ReadOnly = new Wrapper(
    impl
  )
}
