package io.github.vigoo.zioaws.s3.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class VersioningConfiguration(
    mfaDelete: Option[io.github.vigoo.zioaws.s3.model.MFADelete] = None,
    status: Option[io.github.vigoo.zioaws.s3.model.BucketVersioningStatus] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.VersioningConfiguration = {
    import VersioningConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.VersioningConfiguration
      .builder()
      .optionallyWith(mfaDelete.map(value => value.unwrap))(_.mfaDelete)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.s3.model.VersioningConfiguration.ReadOnly =
    io.github.vigoo.zioaws.s3.model.VersioningConfiguration
      .wrap(buildAwsValue())
}
object VersioningConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.VersioningConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.s3.model.VersioningConfiguration =
      io.github.vigoo.zioaws.s3.model.VersioningConfiguration(
        mfaDeleteValue.map(value => value),
        statusValue.map(value => value)
      )
    def mfaDeleteValue: Option[io.github.vigoo.zioaws.s3.model.MFADelete]
    def statusValue
        : Option[io.github.vigoo.zioaws.s3.model.BucketVersioningStatus]
    def mfaDelete
        : ZIO[Any, AwsError, io.github.vigoo.zioaws.s3.model.MFADelete] =
      AwsError.unwrapOptionField("mfaDelete", mfaDeleteValue)
    def status: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.s3.model.BucketVersioningStatus
    ] = AwsError.unwrapOptionField("status", statusValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.VersioningConfiguration
  ) extends io.github.vigoo.zioaws.s3.model.VersioningConfiguration.ReadOnly {
    override def mfaDeleteValue
        : Option[io.github.vigoo.zioaws.s3.model.MFADelete] = scala
      .Option(impl.mfaDelete())
      .map(value => io.github.vigoo.zioaws.s3.model.MFADelete.wrap(value))
    override def statusValue
        : Option[io.github.vigoo.zioaws.s3.model.BucketVersioningStatus] = scala
      .Option(impl.status())
      .map(value =>
        io.github.vigoo.zioaws.s3.model.BucketVersioningStatus.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.VersioningConfiguration
  ): io.github.vigoo.zioaws.s3.model.VersioningConfiguration.ReadOnly =
    new Wrapper(impl)
}
