package io.github.vigoo.zioaws.s3.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class WebsiteConfiguration(
    errorDocument: Option[io.github.vigoo.zioaws.s3.model.ErrorDocument] = None,
    indexDocument: Option[io.github.vigoo.zioaws.s3.model.IndexDocument] = None,
    redirectAllRequestsTo: Option[
      io.github.vigoo.zioaws.s3.model.RedirectAllRequestsTo
    ] = None,
    routingRules: Option[
      Iterable[io.github.vigoo.zioaws.s3.model.RoutingRule]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.WebsiteConfiguration = {
    import WebsiteConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.WebsiteConfiguration
      .builder()
      .optionallyWith(errorDocument.map(value => value.buildAwsValue()))(
        _.errorDocument
      )
      .optionallyWith(indexDocument.map(value => value.buildAwsValue()))(
        _.indexDocument
      )
      .optionallyWith(
        redirectAllRequestsTo.map(value => value.buildAwsValue())
      )(_.redirectAllRequestsTo)
      .optionallyWith(
        routingRules.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.routingRules)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.s3.model.WebsiteConfiguration.ReadOnly =
    io.github.vigoo.zioaws.s3.model.WebsiteConfiguration.wrap(buildAwsValue())
}
object WebsiteConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.WebsiteConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.s3.model.WebsiteConfiguration =
      io.github.vigoo.zioaws.s3.model.WebsiteConfiguration(
        errorDocumentValue.map(value => value.editable),
        indexDocumentValue.map(value => value.editable),
        redirectAllRequestsToValue.map(value => value.editable),
        routingRulesValue.map(value =>
          value.map { item =>
            item.editable
          }
        )
      )
    def errorDocumentValue
        : Option[io.github.vigoo.zioaws.s3.model.ErrorDocument.ReadOnly]
    def indexDocumentValue
        : Option[io.github.vigoo.zioaws.s3.model.IndexDocument.ReadOnly]
    def redirectAllRequestsToValue
        : Option[io.github.vigoo.zioaws.s3.model.RedirectAllRequestsTo.ReadOnly]
    def routingRulesValue
        : Option[List[io.github.vigoo.zioaws.s3.model.RoutingRule.ReadOnly]]
    def errorDocument: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.s3.model.ErrorDocument.ReadOnly
    ] = AwsError.unwrapOptionField("errorDocument", errorDocumentValue)
    def indexDocument: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.s3.model.IndexDocument.ReadOnly
    ] = AwsError.unwrapOptionField("indexDocument", indexDocumentValue)
    def redirectAllRequestsTo: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.s3.model.RedirectAllRequestsTo.ReadOnly
    ] = AwsError.unwrapOptionField(
      "redirectAllRequestsTo",
      redirectAllRequestsToValue
    )
    def routingRules: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.s3.model.RoutingRule.ReadOnly
    ]] = AwsError.unwrapOptionField("routingRules", routingRulesValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.WebsiteConfiguration
  ) extends io.github.vigoo.zioaws.s3.model.WebsiteConfiguration.ReadOnly {
    override def errorDocumentValue
        : Option[io.github.vigoo.zioaws.s3.model.ErrorDocument.ReadOnly] = scala
      .Option(impl.errorDocument())
      .map(value => io.github.vigoo.zioaws.s3.model.ErrorDocument.wrap(value))
    override def indexDocumentValue
        : Option[io.github.vigoo.zioaws.s3.model.IndexDocument.ReadOnly] = scala
      .Option(impl.indexDocument())
      .map(value => io.github.vigoo.zioaws.s3.model.IndexDocument.wrap(value))
    override def redirectAllRequestsToValue: Option[
      io.github.vigoo.zioaws.s3.model.RedirectAllRequestsTo.ReadOnly
    ] = scala
      .Option(impl.redirectAllRequestsTo())
      .map(value =>
        io.github.vigoo.zioaws.s3.model.RedirectAllRequestsTo.wrap(value)
      )
    override def routingRulesValue
        : Option[List[io.github.vigoo.zioaws.s3.model.RoutingRule.ReadOnly]] =
      scala
        .Option(impl.routingRules())
        .map(value =>
          value.asScala.map { item =>
            io.github.vigoo.zioaws.s3.model.RoutingRule.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.WebsiteConfiguration
  ): io.github.vigoo.zioaws.s3.model.WebsiteConfiguration.ReadOnly =
    new Wrapper(impl)
}
