package io.github.vigoo.zioaws.s3.model
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.ZIO
import io.github.vigoo.zioaws.s3.model.primitives.{
  ContentType,
  ErrorMessage,
  ETag,
  CacheControl,
  GetObjectResponseStatusCode,
  TagCount,
  AcceptRanges,
  ContentDisposition,
  ContentLanguage,
  Expiration,
  ContentLength,
  PartsCount,
  SSECustomerAlgorithm,
  SSECustomerKeyMD5,
  DeleteMarker,
  ChecksumSHA256,
  LastModified,
  Expires,
  ContentEncoding,
  ChecksumCRC32C,
  ChecksumCRC32,
  ErrorCode,
  RequestToken,
  MissingMeta,
  ChecksumSHA1,
  SSEKMSKeyId,
  MetadataValue,
  RequestRoute,
  ObjectLockRetainUntilDate,
  Restore,
  ObjectVersionId,
  MetadataKey,
  BucketKeyEnabled,
  ContentRange
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class WriteGetObjectResponseRequest(
    requestRoute: RequestRoute,
    requestToken: RequestToken,
    statusCode: Option[GetObjectResponseStatusCode] = None,
    errorCode: Option[ErrorCode] = None,
    errorMessage: Option[ErrorMessage] = None,
    acceptRanges: Option[AcceptRanges] = None,
    cacheControl: Option[CacheControl] = None,
    contentDisposition: Option[ContentDisposition] = None,
    contentEncoding: Option[ContentEncoding] = None,
    contentLanguage: Option[ContentLanguage] = None,
    contentLength: Option[ContentLength] = None,
    contentRange: Option[ContentRange] = None,
    contentType: Option[ContentType] = None,
    checksumCRC32: Option[ChecksumCRC32] = None,
    checksumCRC32C: Option[ChecksumCRC32C] = None,
    checksumSHA1: Option[ChecksumSHA1] = None,
    checksumSHA256: Option[ChecksumSHA256] = None,
    deleteMarker: Option[DeleteMarker] = None,
    eTag: Option[ETag] = None,
    expires: Option[Expires] = None,
    expiration: Option[Expiration] = None,
    lastModified: Option[LastModified] = None,
    missingMeta: Option[MissingMeta] = None,
    metadata: Option[Map[MetadataKey, MetadataValue]] = None,
    objectLockMode: Option[io.github.vigoo.zioaws.s3.model.ObjectLockMode] =
      None,
    objectLockLegalHoldStatus: Option[
      io.github.vigoo.zioaws.s3.model.ObjectLockLegalHoldStatus
    ] = None,
    objectLockRetainUntilDate: Option[ObjectLockRetainUntilDate] = None,
    partsCount: Option[PartsCount] = None,
    replicationStatus: Option[
      io.github.vigoo.zioaws.s3.model.ReplicationStatus
    ] = None,
    requestCharged: Option[io.github.vigoo.zioaws.s3.model.RequestCharged] =
      None,
    restore: Option[Restore] = None,
    serverSideEncryption: Option[
      io.github.vigoo.zioaws.s3.model.ServerSideEncryption
    ] = None,
    sseCustomerAlgorithm: Option[SSECustomerAlgorithm] = None,
    ssekmsKeyId: Option[SSEKMSKeyId] = None,
    sseCustomerKeyMD5: Option[SSECustomerKeyMD5] = None,
    storageClass: Option[io.github.vigoo.zioaws.s3.model.StorageClass] = None,
    tagCount: Option[TagCount] = None,
    versionId: Option[ObjectVersionId] = None,
    bucketKeyEnabled: Option[BucketKeyEnabled] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.WriteGetObjectResponseRequest = {
    import WriteGetObjectResponseRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.WriteGetObjectResponseRequest
      .builder()
      .requestRoute(requestRoute: java.lang.String)
      .requestToken(requestToken: java.lang.String)
      .optionallyWith(statusCode.map(value => value: Integer))(_.statusCode)
      .optionallyWith(errorCode.map(value => value: java.lang.String))(
        _.errorCode
      )
      .optionallyWith(errorMessage.map(value => value: java.lang.String))(
        _.errorMessage
      )
      .optionallyWith(acceptRanges.map(value => value: java.lang.String))(
        _.acceptRanges
      )
      .optionallyWith(cacheControl.map(value => value: java.lang.String))(
        _.cacheControl
      )
      .optionallyWith(contentDisposition.map(value => value: java.lang.String))(
        _.contentDisposition
      )
      .optionallyWith(contentEncoding.map(value => value: java.lang.String))(
        _.contentEncoding
      )
      .optionallyWith(contentLanguage.map(value => value: java.lang.String))(
        _.contentLanguage
      )
      .optionallyWith(contentLength.map(value => value: java.lang.Long))(
        _.contentLength
      )
      .optionallyWith(contentRange.map(value => value: java.lang.String))(
        _.contentRange
      )
      .optionallyWith(contentType.map(value => value: java.lang.String))(
        _.contentType
      )
      .optionallyWith(checksumCRC32.map(value => value: java.lang.String))(
        _.checksumCRC32
      )
      .optionallyWith(checksumCRC32C.map(value => value: java.lang.String))(
        _.checksumCRC32C
      )
      .optionallyWith(checksumSHA1.map(value => value: java.lang.String))(
        _.checksumSHA1
      )
      .optionallyWith(checksumSHA256.map(value => value: java.lang.String))(
        _.checksumSHA256
      )
      .optionallyWith(deleteMarker.map(value => value: java.lang.Boolean))(
        _.deleteMarker
      )
      .optionallyWith(eTag.map(value => value: java.lang.String))(_.eTag)
      .optionallyWith(expires.map(value => value: Instant))(_.expires)
      .optionallyWith(expiration.map(value => value: java.lang.String))(
        _.expiration
      )
      .optionallyWith(lastModified.map(value => value: Instant))(_.lastModified)
      .optionallyWith(missingMeta.map(value => value: Integer))(_.missingMeta)
      .optionallyWith(
        metadata.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.metadata)
      .optionallyWith(objectLockMode.map(value => value.unwrap))(
        _.objectLockMode
      )
      .optionallyWith(objectLockLegalHoldStatus.map(value => value.unwrap))(
        _.objectLockLegalHoldStatus
      )
      .optionallyWith(objectLockRetainUntilDate.map(value => value: Instant))(
        _.objectLockRetainUntilDate
      )
      .optionallyWith(partsCount.map(value => value: Integer))(_.partsCount)
      .optionallyWith(replicationStatus.map(value => value.unwrap))(
        _.replicationStatus
      )
      .optionallyWith(requestCharged.map(value => value.unwrap))(
        _.requestCharged
      )
      .optionallyWith(restore.map(value => value: java.lang.String))(_.restore)
      .optionallyWith(serverSideEncryption.map(value => value.unwrap))(
        _.serverSideEncryption
      )
      .optionallyWith(
        sseCustomerAlgorithm.map(value => value: java.lang.String)
      )(_.sseCustomerAlgorithm)
      .optionallyWith(ssekmsKeyId.map(value => value: java.lang.String))(
        _.ssekmsKeyId
      )
      .optionallyWith(sseCustomerKeyMD5.map(value => value: java.lang.String))(
        _.sseCustomerKeyMD5
      )
      .optionallyWith(storageClass.map(value => value.unwrap))(_.storageClass)
      .optionallyWith(tagCount.map(value => value: Integer))(_.tagCount)
      .optionallyWith(versionId.map(value => value: java.lang.String))(
        _.versionId
      )
      .optionallyWith(bucketKeyEnabled.map(value => value: java.lang.Boolean))(
        _.bucketKeyEnabled
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.s3.model.WriteGetObjectResponseRequest.ReadOnly =
    io.github.vigoo.zioaws.s3.model.WriteGetObjectResponseRequest
      .wrap(buildAwsValue())
}
object WriteGetObjectResponseRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.WriteGetObjectResponseRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.s3.model.WriteGetObjectResponseRequest =
      io.github.vigoo.zioaws.s3.model.WriteGetObjectResponseRequest(
        requestRouteValue,
        requestTokenValue,
        statusCodeValue.map(value => value),
        errorCodeValue.map(value => value),
        errorMessageValue.map(value => value),
        acceptRangesValue.map(value => value),
        cacheControlValue.map(value => value),
        contentDispositionValue.map(value => value),
        contentEncodingValue.map(value => value),
        contentLanguageValue.map(value => value),
        contentLengthValue.map(value => value),
        contentRangeValue.map(value => value),
        contentTypeValue.map(value => value),
        checksumCRC32Value.map(value => value),
        checksumCRC32CValue.map(value => value),
        checksumSHA1Value.map(value => value),
        checksumSHA256Value.map(value => value),
        deleteMarkerValue.map(value => value),
        eTagValue.map(value => value),
        expiresValue.map(value => value),
        expirationValue.map(value => value),
        lastModifiedValue.map(value => value),
        missingMetaValue.map(value => value),
        metadataValue.map(value => value),
        objectLockModeValue.map(value => value),
        objectLockLegalHoldStatusValue.map(value => value),
        objectLockRetainUntilDateValue.map(value => value),
        partsCountValue.map(value => value),
        replicationStatusValue.map(value => value),
        requestChargedValue.map(value => value),
        restoreValue.map(value => value),
        serverSideEncryptionValue.map(value => value),
        sseCustomerAlgorithmValue.map(value => value),
        ssekmsKeyIdValue.map(value => value),
        sseCustomerKeyMD5Value.map(value => value),
        storageClassValue.map(value => value),
        tagCountValue.map(value => value),
        versionIdValue.map(value => value),
        bucketKeyEnabledValue.map(value => value)
      )
    def requestRouteValue: RequestRoute
    def requestTokenValue: RequestToken
    def statusCodeValue: Option[GetObjectResponseStatusCode]
    def errorCodeValue: Option[ErrorCode]
    def errorMessageValue: Option[ErrorMessage]
    def acceptRangesValue: Option[AcceptRanges]
    def cacheControlValue: Option[CacheControl]
    def contentDispositionValue: Option[ContentDisposition]
    def contentEncodingValue: Option[ContentEncoding]
    def contentLanguageValue: Option[ContentLanguage]
    def contentLengthValue: Option[ContentLength]
    def contentRangeValue: Option[ContentRange]
    def contentTypeValue: Option[ContentType]
    def checksumCRC32Value: Option[ChecksumCRC32]
    def checksumCRC32CValue: Option[ChecksumCRC32C]
    def checksumSHA1Value: Option[ChecksumSHA1]
    def checksumSHA256Value: Option[ChecksumSHA256]
    def deleteMarkerValue: Option[DeleteMarker]
    def eTagValue: Option[ETag]
    def expiresValue: Option[Expires]
    def expirationValue: Option[Expiration]
    def lastModifiedValue: Option[LastModified]
    def missingMetaValue: Option[MissingMeta]
    def metadataValue: Option[Map[MetadataKey, MetadataValue]]
    def objectLockModeValue
        : Option[io.github.vigoo.zioaws.s3.model.ObjectLockMode]
    def objectLockLegalHoldStatusValue
        : Option[io.github.vigoo.zioaws.s3.model.ObjectLockLegalHoldStatus]
    def objectLockRetainUntilDateValue: Option[ObjectLockRetainUntilDate]
    def partsCountValue: Option[PartsCount]
    def replicationStatusValue
        : Option[io.github.vigoo.zioaws.s3.model.ReplicationStatus]
    def requestChargedValue
        : Option[io.github.vigoo.zioaws.s3.model.RequestCharged]
    def restoreValue: Option[Restore]
    def serverSideEncryptionValue
        : Option[io.github.vigoo.zioaws.s3.model.ServerSideEncryption]
    def sseCustomerAlgorithmValue: Option[SSECustomerAlgorithm]
    def ssekmsKeyIdValue: Option[SSEKMSKeyId]
    def sseCustomerKeyMD5Value: Option[SSECustomerKeyMD5]
    def storageClassValue: Option[io.github.vigoo.zioaws.s3.model.StorageClass]
    def tagCountValue: Option[TagCount]
    def versionIdValue: Option[ObjectVersionId]
    def bucketKeyEnabledValue: Option[BucketKeyEnabled]
    def requestRoute: ZIO[Any, Nothing, RequestRoute] =
      ZIO.succeed(requestRouteValue)
    def requestToken: ZIO[Any, Nothing, RequestToken] =
      ZIO.succeed(requestTokenValue)
    def statusCode: ZIO[Any, AwsError, GetObjectResponseStatusCode] =
      AwsError.unwrapOptionField("statusCode", statusCodeValue)
    def errorCode: ZIO[Any, AwsError, ErrorCode] =
      AwsError.unwrapOptionField("errorCode", errorCodeValue)
    def errorMessage: ZIO[Any, AwsError, ErrorMessage] =
      AwsError.unwrapOptionField("errorMessage", errorMessageValue)
    def acceptRanges: ZIO[Any, AwsError, AcceptRanges] =
      AwsError.unwrapOptionField("acceptRanges", acceptRangesValue)
    def cacheControl: ZIO[Any, AwsError, CacheControl] =
      AwsError.unwrapOptionField("cacheControl", cacheControlValue)
    def contentDisposition: ZIO[Any, AwsError, ContentDisposition] =
      AwsError.unwrapOptionField("contentDisposition", contentDispositionValue)
    def contentEncoding: ZIO[Any, AwsError, ContentEncoding] =
      AwsError.unwrapOptionField("contentEncoding", contentEncodingValue)
    def contentLanguage: ZIO[Any, AwsError, ContentLanguage] =
      AwsError.unwrapOptionField("contentLanguage", contentLanguageValue)
    def contentLength: ZIO[Any, AwsError, ContentLength] =
      AwsError.unwrapOptionField("contentLength", contentLengthValue)
    def contentRange: ZIO[Any, AwsError, ContentRange] =
      AwsError.unwrapOptionField("contentRange", contentRangeValue)
    def contentType: ZIO[Any, AwsError, ContentType] =
      AwsError.unwrapOptionField("contentType", contentTypeValue)
    def checksumCRC32: ZIO[Any, AwsError, ChecksumCRC32] =
      AwsError.unwrapOptionField("checksumCRC32", checksumCRC32Value)
    def checksumCRC32C: ZIO[Any, AwsError, ChecksumCRC32C] =
      AwsError.unwrapOptionField("checksumCRC32C", checksumCRC32CValue)
    def checksumSHA1: ZIO[Any, AwsError, ChecksumSHA1] =
      AwsError.unwrapOptionField("checksumSHA1", checksumSHA1Value)
    def checksumSHA256: ZIO[Any, AwsError, ChecksumSHA256] =
      AwsError.unwrapOptionField("checksumSHA256", checksumSHA256Value)
    def deleteMarker: ZIO[Any, AwsError, DeleteMarker] =
      AwsError.unwrapOptionField("deleteMarker", deleteMarkerValue)
    def eTag: ZIO[Any, AwsError, ETag] =
      AwsError.unwrapOptionField("eTag", eTagValue)
    def expires: ZIO[Any, AwsError, Expires] =
      AwsError.unwrapOptionField("expires", expiresValue)
    def expiration: ZIO[Any, AwsError, Expiration] =
      AwsError.unwrapOptionField("expiration", expirationValue)
    def lastModified: ZIO[Any, AwsError, LastModified] =
      AwsError.unwrapOptionField("lastModified", lastModifiedValue)
    def missingMeta: ZIO[Any, AwsError, MissingMeta] =
      AwsError.unwrapOptionField("missingMeta", missingMetaValue)
    def metadata: ZIO[Any, AwsError, Map[MetadataKey, MetadataValue]] =
      AwsError.unwrapOptionField("metadata", metadataValue)
    def objectLockMode
        : ZIO[Any, AwsError, io.github.vigoo.zioaws.s3.model.ObjectLockMode] =
      AwsError.unwrapOptionField("objectLockMode", objectLockModeValue)
    def objectLockLegalHoldStatus: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.s3.model.ObjectLockLegalHoldStatus
    ] = AwsError.unwrapOptionField(
      "objectLockLegalHoldStatus",
      objectLockLegalHoldStatusValue
    )
    def objectLockRetainUntilDate
        : ZIO[Any, AwsError, ObjectLockRetainUntilDate] =
      AwsError.unwrapOptionField(
        "objectLockRetainUntilDate",
        objectLockRetainUntilDateValue
      )
    def partsCount: ZIO[Any, AwsError, PartsCount] =
      AwsError.unwrapOptionField("partsCount", partsCountValue)
    def replicationStatus: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.s3.model.ReplicationStatus
    ] = AwsError.unwrapOptionField("replicationStatus", replicationStatusValue)
    def requestCharged
        : ZIO[Any, AwsError, io.github.vigoo.zioaws.s3.model.RequestCharged] =
      AwsError.unwrapOptionField("requestCharged", requestChargedValue)
    def restore: ZIO[Any, AwsError, Restore] =
      AwsError.unwrapOptionField("restore", restoreValue)
    def serverSideEncryption: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.s3.model.ServerSideEncryption
    ] = AwsError.unwrapOptionField(
      "serverSideEncryption",
      serverSideEncryptionValue
    )
    def sseCustomerAlgorithm: ZIO[Any, AwsError, SSECustomerAlgorithm] =
      AwsError.unwrapOptionField(
        "sseCustomerAlgorithm",
        sseCustomerAlgorithmValue
      )
    def ssekmsKeyId: ZIO[Any, AwsError, SSEKMSKeyId] =
      AwsError.unwrapOptionField("ssekmsKeyId", ssekmsKeyIdValue)
    def sseCustomerKeyMD5: ZIO[Any, AwsError, SSECustomerKeyMD5] =
      AwsError.unwrapOptionField("sseCustomerKeyMD5", sseCustomerKeyMD5Value)
    def storageClass
        : ZIO[Any, AwsError, io.github.vigoo.zioaws.s3.model.StorageClass] =
      AwsError.unwrapOptionField("storageClass", storageClassValue)
    def tagCount: ZIO[Any, AwsError, TagCount] =
      AwsError.unwrapOptionField("tagCount", tagCountValue)
    def versionId: ZIO[Any, AwsError, ObjectVersionId] =
      AwsError.unwrapOptionField("versionId", versionIdValue)
    def bucketKeyEnabled: ZIO[Any, AwsError, BucketKeyEnabled] =
      AwsError.unwrapOptionField("bucketKeyEnabled", bucketKeyEnabledValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.WriteGetObjectResponseRequest
  ) extends io.github.vigoo.zioaws.s3.model.WriteGetObjectResponseRequest.ReadOnly {
    override def requestRouteValue: RequestRoute =
      impl.requestRoute(): RequestRoute
    override def requestTokenValue: RequestToken =
      impl.requestToken(): RequestToken
    override def statusCodeValue: Option[GetObjectResponseStatusCode] = scala
      .Option(impl.statusCode())
      .map(value => value: GetObjectResponseStatusCode)
    override def errorCodeValue: Option[ErrorCode] =
      scala.Option(impl.errorCode()).map(value => value: ErrorCode)
    override def errorMessageValue: Option[ErrorMessage] =
      scala.Option(impl.errorMessage()).map(value => value: ErrorMessage)
    override def acceptRangesValue: Option[AcceptRanges] =
      scala.Option(impl.acceptRanges()).map(value => value: AcceptRanges)
    override def cacheControlValue: Option[CacheControl] =
      scala.Option(impl.cacheControl()).map(value => value: CacheControl)
    override def contentDispositionValue: Option[ContentDisposition] = scala
      .Option(impl.contentDisposition())
      .map(value => value: ContentDisposition)
    override def contentEncodingValue: Option[ContentEncoding] =
      scala.Option(impl.contentEncoding()).map(value => value: ContentEncoding)
    override def contentLanguageValue: Option[ContentLanguage] =
      scala.Option(impl.contentLanguage()).map(value => value: ContentLanguage)
    override def contentLengthValue: Option[ContentLength] =
      scala.Option(impl.contentLength()).map(value => value: ContentLength)
    override def contentRangeValue: Option[ContentRange] =
      scala.Option(impl.contentRange()).map(value => value: ContentRange)
    override def contentTypeValue: Option[ContentType] =
      scala.Option(impl.contentType()).map(value => value: ContentType)
    override def checksumCRC32Value: Option[ChecksumCRC32] =
      scala.Option(impl.checksumCRC32()).map(value => value: ChecksumCRC32)
    override def checksumCRC32CValue: Option[ChecksumCRC32C] =
      scala.Option(impl.checksumCRC32C()).map(value => value: ChecksumCRC32C)
    override def checksumSHA1Value: Option[ChecksumSHA1] =
      scala.Option(impl.checksumSHA1()).map(value => value: ChecksumSHA1)
    override def checksumSHA256Value: Option[ChecksumSHA256] =
      scala.Option(impl.checksumSHA256()).map(value => value: ChecksumSHA256)
    override def deleteMarkerValue: Option[DeleteMarker] =
      scala.Option(impl.deleteMarker()).map(value => value: DeleteMarker)
    override def eTagValue: Option[ETag] =
      scala.Option(impl.eTag()).map(value => value: ETag)
    override def expiresValue: Option[Expires] =
      scala.Option(impl.expires()).map(value => value: Expires)
    override def expirationValue: Option[Expiration] =
      scala.Option(impl.expiration()).map(value => value: Expiration)
    override def lastModifiedValue: Option[LastModified] =
      scala.Option(impl.lastModified()).map(value => value: LastModified)
    override def missingMetaValue: Option[MissingMeta] =
      scala.Option(impl.missingMeta()).map(value => value: MissingMeta)
    override def metadataValue: Option[Map[MetadataKey, MetadataValue]] = scala
      .Option(impl.metadata())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: MetadataKey) -> (value: MetadataValue)
          })
          .toMap
      )
    override def objectLockModeValue
        : Option[io.github.vigoo.zioaws.s3.model.ObjectLockMode] = scala
      .Option(impl.objectLockMode())
      .map(value => io.github.vigoo.zioaws.s3.model.ObjectLockMode.wrap(value))
    override def objectLockLegalHoldStatusValue
        : Option[io.github.vigoo.zioaws.s3.model.ObjectLockLegalHoldStatus] =
      scala
        .Option(impl.objectLockLegalHoldStatus())
        .map(value =>
          io.github.vigoo.zioaws.s3.model.ObjectLockLegalHoldStatus.wrap(value)
        )
    override def objectLockRetainUntilDateValue
        : Option[ObjectLockRetainUntilDate] = scala
      .Option(impl.objectLockRetainUntilDate())
      .map(value => value: ObjectLockRetainUntilDate)
    override def partsCountValue: Option[PartsCount] =
      scala.Option(impl.partsCount()).map(value => value: PartsCount)
    override def replicationStatusValue
        : Option[io.github.vigoo.zioaws.s3.model.ReplicationStatus] = scala
      .Option(impl.replicationStatus())
      .map(value =>
        io.github.vigoo.zioaws.s3.model.ReplicationStatus.wrap(value)
      )
    override def requestChargedValue
        : Option[io.github.vigoo.zioaws.s3.model.RequestCharged] = scala
      .Option(impl.requestCharged())
      .map(value => io.github.vigoo.zioaws.s3.model.RequestCharged.wrap(value))
    override def restoreValue: Option[Restore] =
      scala.Option(impl.restore()).map(value => value: Restore)
    override def serverSideEncryptionValue
        : Option[io.github.vigoo.zioaws.s3.model.ServerSideEncryption] = scala
      .Option(impl.serverSideEncryption())
      .map(value =>
        io.github.vigoo.zioaws.s3.model.ServerSideEncryption.wrap(value)
      )
    override def sseCustomerAlgorithmValue: Option[SSECustomerAlgorithm] = scala
      .Option(impl.sseCustomerAlgorithm())
      .map(value => value: SSECustomerAlgorithm)
    override def ssekmsKeyIdValue: Option[SSEKMSKeyId] =
      scala.Option(impl.ssekmsKeyId()).map(value => value: SSEKMSKeyId)
    override def sseCustomerKeyMD5Value: Option[SSECustomerKeyMD5] = scala
      .Option(impl.sseCustomerKeyMD5())
      .map(value => value: SSECustomerKeyMD5)
    override def storageClassValue
        : Option[io.github.vigoo.zioaws.s3.model.StorageClass] = scala
      .Option(impl.storageClass())
      .map(value => io.github.vigoo.zioaws.s3.model.StorageClass.wrap(value))
    override def tagCountValue: Option[TagCount] =
      scala.Option(impl.tagCount()).map(value => value: TagCount)
    override def versionIdValue: Option[ObjectVersionId] =
      scala.Option(impl.versionId()).map(value => value: ObjectVersionId)
    override def bucketKeyEnabledValue: Option[BucketKeyEnabled] = scala
      .Option(impl.bucketKeyEnabled())
      .map(value => value: BucketKeyEnabled)
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.WriteGetObjectResponseRequest
  ): io.github.vigoo.zioaws.s3.model.WriteGetObjectResponseRequest.ReadOnly =
    new Wrapper(impl)
}
