package io.github.vigoo.zioaws.s3
import io.github.vigoo.zioaws.s3.model.primitives.{
  AllowedOrigin,
  AllowedMethod,
  AllowedHeader,
  ExposeHeader,
  MetadataValue,
  MetadataKey
}
import zio.Chunk
import java.time.Instant
package object model {
  import scala.jdk.CollectionConverters._
  object primitives {
    type AbortDate = Instant
    type AbortRuleId = String
    type AcceptRanges = String
    type AccessPointArn = String
    type AccountId = String
    type AllowQuotedRecordDelimiter = Boolean
    type AllowedHeader = String
    type AllowedMethod = String
    type AllowedOrigin = String
    type AnalyticsId = String
    type Body = Chunk[Byte]
    type BucketKeyEnabled = Boolean
    type BucketName = String
    type BypassGovernanceRetention = Boolean
    type CacheControl = String
    type ChecksumCRC32 = String
    type ChecksumCRC32C = String
    type ChecksumSHA1 = String
    type ChecksumSHA256 = String
    type Code = String
    type Comments = String
    type ConfirmRemoveSelfBucketAccess = Boolean
    type ContentDisposition = String
    type ContentEncoding = String
    type ContentLanguage = String
    type ContentLength = Long
    type ContentMD5 = String
    type ContentRange = String
    type ContentType = String
    type CopySource = String
    type CopySourceIfMatch = String
    type CopySourceIfModifiedSince = Instant
    type CopySourceIfNoneMatch = String
    type CopySourceIfUnmodifiedSince = Instant
    type CopySourceRange = String
    type CopySourceSSECustomerAlgorithm = String
    type CopySourceSSECustomerKey = String
    type CopySourceSSECustomerKeyMD5 = String
    type CopySourceVersionId = String
    type CreationDate = Instant
    type Date = Instant
    type Days = Int
    type DaysAfterInitiation = Int
    type DeleteMarker = Boolean
    type DeleteMarkerVersionId = String
    type Delimiter = String
    type Description = String
    type DisplayName = String
    type ETag = String
    type EmailAddress = String
    type EnableRequestProgress = Boolean
    type End = Long
    type ErrorCode = String
    type ErrorMessage = String
    type Expiration = String
    type ExpiredObjectDeleteMarker = Boolean
    type Expires = Instant
    type ExposeHeader = String
    type Expression = String
    type FetchOwner = Boolean
    type FieldDelimiter = String
    type FilterRuleValue = String
    type GetObjectResponseStatusCode = Int
    type GrantFullControl = String
    type GrantRead = String
    type GrantReadACP = String
    type GrantWrite = String
    type GrantWriteACP = String
    type HostName = String
    type HttpErrorCodeReturnedEquals = String
    type HttpRedirectCode = String
    type ID = String
    type IfMatch = String
    type IfModifiedSince = Instant
    type IfNoneMatch = String
    type IfUnmodifiedSince = Instant
    type Initiated = Instant
    type IntelligentTieringDays = Int
    type IntelligentTieringId = String
    type InventoryId = String
    type IsEnabled = Boolean
    type IsLatest = Boolean
    type IsPublic = Boolean
    type IsTruncated = Boolean
    type KMSContext = String
    type KeyCount = Int
    type KeyMarker = String
    type KeyPrefixEquals = String
    type LambdaFunctionArn = String
    type LastModified = Instant
    type Location = String
    type LocationPrefix = String
    type MFA = String
    type Marker = String
    type MaxAgeSeconds = Int
    type MaxKeys = Int
    type MaxParts = Int
    type MaxUploads = Int
    type Message = String
    type MetadataKey = String
    type MetadataValue = String
    type MetricsId = String
    type Minutes = Int
    type MissingMeta = Int
    type MultipartUploadId = String
    type NextKeyMarker = String
    type NextMarker = String
    type NextPartNumberMarker = Int
    type NextToken = String
    type NextUploadIdMarker = String
    type NextVersionIdMarker = String
    type NotificationId = String
    type ObjectKey = String
    type ObjectLockEnabledForBucket = Boolean
    type ObjectLockRetainUntilDate = Instant
    type ObjectLockToken = String
    type ObjectSize = Long
    type ObjectSizeGreaterThanBytes = Long
    type ObjectSizeLessThanBytes = Long
    type ObjectVersionId = String
    type PartNumber = Int
    type PartNumberMarker = Int
    type PartsCount = Int
    type Policy = String
    type Prefix = String
    type Priority = Int
    type QueueArn = String
    type Quiet = Boolean
    type QuoteCharacter = String
    type QuoteEscapeCharacter = String
    type Range = String
    type RecordDelimiter = String
    type ReplaceKeyPrefixWith = String
    type ReplaceKeyWith = String
    type ReplicaKmsKeyID = String
    type RequestRoute = String
    type RequestToken = String
    type ResponseCacheControl = String
    type ResponseContentDisposition = String
    type ResponseContentEncoding = String
    type ResponseContentLanguage = String
    type ResponseContentType = String
    type ResponseExpires = Instant
    type Restore = String
    type RestoreOutputPath = String
    type Role = String
    type SSECustomerAlgorithm = String
    type SSECustomerKey = String
    type SSECustomerKeyMD5 = String
    type SSEKMSEncryptionContext = String
    type SSEKMSKeyId = String
    type Setting = Boolean
    type Size = Int
    type SkipValidation = Boolean
    type Start = Long
    type StartAfter = String
    type Suffix = String
    type TagCount = Int
    type TaggingHeader = String
    type TargetBucket = String
    type TargetPrefix = String
    type Token = String
    type TopicArn = String
    type URI = String
    type UploadIdMarker = String
    type Value = String
    type VersionCount = Int
    type VersionIdMarker = String
    type WebsiteRedirectLocation = String
    type Years = Int
  }
  type AllowedHeaders = List[AllowedHeader]
  type AllowedMethods = List[AllowedMethod]
  type AllowedOrigins = List[AllowedOrigin]
  type AnalyticsConfigurationList =
    List[io.github.vigoo.zioaws.s3.model.AnalyticsConfiguration]
  type Buckets = List[io.github.vigoo.zioaws.s3.model.Bucket]
  type CORSRules = List[io.github.vigoo.zioaws.s3.model.CORSRule]
  type ChecksumAlgorithmList =
    List[io.github.vigoo.zioaws.s3.model.ChecksumAlgorithm]
  type CommonPrefixList = List[io.github.vigoo.zioaws.s3.model.CommonPrefix]
  type CompletedPartList = List[io.github.vigoo.zioaws.s3.model.CompletedPart]
  type DeleteMarkers = List[io.github.vigoo.zioaws.s3.model.DeleteMarkerEntry]
  type DeletedObjects = List[io.github.vigoo.zioaws.s3.model.DeletedObject]
  type Errors = List[io.github.vigoo.zioaws.s3.model.S3Error]
  type EventList = List[io.github.vigoo.zioaws.s3.model.Event]
  type ExposeHeaders = List[ExposeHeader]
  type FilterRuleList = List[io.github.vigoo.zioaws.s3.model.FilterRule]
  type Grants = List[io.github.vigoo.zioaws.s3.model.Grant]
  type IntelligentTieringConfigurationList =
    List[io.github.vigoo.zioaws.s3.model.IntelligentTieringConfiguration]
  type InventoryConfigurationList =
    List[io.github.vigoo.zioaws.s3.model.InventoryConfiguration]
  type InventoryOptionalFields =
    List[io.github.vigoo.zioaws.s3.model.InventoryOptionalField]
  type LambdaFunctionConfigurationList =
    List[io.github.vigoo.zioaws.s3.model.LambdaFunctionConfiguration]
  type LifecycleRules = List[io.github.vigoo.zioaws.s3.model.LifecycleRule]
  type Metadata = Map[MetadataKey, MetadataValue]
  type MetricsConfigurationList =
    List[io.github.vigoo.zioaws.s3.model.MetricsConfiguration]
  type MultipartUploadList =
    List[io.github.vigoo.zioaws.s3.model.MultipartUpload]
  type NoncurrentVersionTransitionList =
    List[io.github.vigoo.zioaws.s3.model.NoncurrentVersionTransition]
  type ObjectAttributesList =
    List[io.github.vigoo.zioaws.s3.model.ObjectAttributes]
  type ObjectIdentifierList =
    List[io.github.vigoo.zioaws.s3.model.ObjectIdentifier]
  type ObjectList = List[io.github.vigoo.zioaws.s3.model.S3Object]
  type ObjectVersionList = List[io.github.vigoo.zioaws.s3.model.ObjectVersion]
  type OwnershipControlsRules =
    List[io.github.vigoo.zioaws.s3.model.OwnershipControlsRule]
  type Parts = List[io.github.vigoo.zioaws.s3.model.Part]
  type PartsList = List[io.github.vigoo.zioaws.s3.model.ObjectPart]
  type QueueConfigurationList =
    List[io.github.vigoo.zioaws.s3.model.QueueConfiguration]
  type ReplicationRules = List[io.github.vigoo.zioaws.s3.model.ReplicationRule]
  type RoutingRules = List[io.github.vigoo.zioaws.s3.model.RoutingRule]
  type ServerSideEncryptionRules =
    List[io.github.vigoo.zioaws.s3.model.ServerSideEncryptionRule]
  type TagSet = List[io.github.vigoo.zioaws.s3.model.Tag]
  type TargetGrants = List[io.github.vigoo.zioaws.s3.model.TargetGrant]
  type TieringList = List[io.github.vigoo.zioaws.s3.model.Tiering]
  type TopicConfigurationList =
    List[io.github.vigoo.zioaws.s3.model.TopicConfiguration]
  type TransitionList = List[io.github.vigoo.zioaws.s3.model.Transition]
  type UserMetadata = List[io.github.vigoo.zioaws.s3.model.MetadataEntry]
}
