package io.github.vigoo.zioaws
import io.github.vigoo.zioaws.s3.model.DeleteObjectsResponse.ReadOnly
import software.amazon.awssdk.services.s3.paginators.{
  ListObjectsV2Publisher,
  ListPartsPublisher,
  ListMultipartUploadsPublisher,
  ListObjectVersionsPublisher
}
import io.github.vigoo.zioaws.core.{
  AwsServiceBase,
  StreamingOutputResult,
  AwsError
}
import software.amazon.awssdk.services.s3.{S3AsyncClientBuilder, S3AsyncClient}
import software.amazon.awssdk.services.s3.model.{
  PutBucketTaggingResponse,
  PutBucketWebsiteRequest,
  PutBucketLifecycleConfigurationResponse,
  PutBucketPolicyRequest,
  PutBucketAccelerateConfigurationResponse,
  RestoreObjectRequest,
  DeleteObjectTaggingRequest,
  DeleteBucketIntelligentTieringConfigurationResponse,
  ListObjectsRequest,
  DeleteBucketEncryptionResponse,
  PutBucketLoggingResponse,
  DeleteBucketOwnershipControlsResponse,
  SelectObjectContentResponseHandler,
  GetObjectLockConfigurationResponse,
  GetBucketLoggingRequest,
  PutObjectRetentionRequest,
  GetBucketVersioningRequest,
  PutBucketWebsiteResponse,
  UploadPartResponse,
  GetBucketEncryptionRequest,
  GetBucketNotificationConfigurationRequest,
  DeleteBucketReplicationRequest,
  PutBucketNotificationConfigurationResponse,
  GetObjectResponse,
  PutBucketLifecycleConfigurationRequest,
  PutBucketRequestPaymentResponse,
  ListBucketMetricsConfigurationsResponse,
  DeleteBucketIntelligentTieringConfigurationRequest,
  GetBucketLifecycleConfigurationResponse,
  HeadBucketRequest,
  GetBucketAclRequest,
  DeleteObjectsRequest,
  PutBucketVersioningRequest,
  PutBucketAnalyticsConfigurationRequest,
  GetPublicAccessBlockResponse,
  GetBucketReplicationRequest,
  GetBucketPolicyRequest,
  WriteGetObjectResponseRequest,
  PutBucketCorsResponse,
  SelectObjectContentRequest,
  DeleteObjectsResponse,
  HeadBucketResponse,
  PutBucketNotificationConfigurationRequest,
  DeleteBucketTaggingRequest,
  PutBucketEncryptionRequest,
  PutBucketAclRequest,
  SelectObjectContentEventStream,
  HeadObjectResponse,
  PutPublicAccessBlockResponse,
  RestoreObjectResponse,
  GetBucketOwnershipControlsRequest,
  GetBucketOwnershipControlsResponse,
  DeleteBucketAnalyticsConfigurationRequest,
  DeletePublicAccessBlockResponse,
  PutBucketInventoryConfigurationRequest,
  PutBucketIntelligentTieringConfigurationResponse,
  PutObjectTaggingResponse,
  DeleteBucketReplicationResponse,
  GetBucketTaggingResponse,
  GetBucketLocationRequest,
  ListBucketIntelligentTieringConfigurationsRequest,
  GetBucketInventoryConfigurationResponse,
  PutObjectLockConfigurationResponse,
  GetObjectRetentionRequest,
  GetBucketCorsResponse,
  GetBucketCorsRequest,
  PutObjectTaggingRequest,
  ObjectVersion,
  AbortMultipartUploadRequest,
  DeleteObjectResponse,
  GetBucketPolicyResponse,
  UploadPartCopyResponse,
  ListBucketsRequest,
  DeleteBucketCorsResponse,
  UploadPartCopyRequest,
  HeadObjectRequest,
  DeleteBucketLifecycleResponse,
  GetBucketNotificationConfigurationResponse,
  PutObjectRequest,
  PutPublicAccessBlockRequest,
  CreateBucketResponse,
  DeleteBucketResponse,
  GetBucketTaggingRequest,
  DeleteObjectTaggingResponse,
  DeleteBucketTaggingResponse,
  GetBucketWebsiteRequest,
  GetBucketInventoryConfigurationRequest,
  DeleteBucketMetricsConfigurationResponse,
  DeleteBucketLifecycleRequest,
  ListBucketMetricsConfigurationsRequest,
  PutBucketReplicationRequest,
  PutObjectRetentionResponse,
  ListObjectsResponse,
  ListMultipartUploadsRequest,
  GetPublicAccessBlockRequest,
  DeleteBucketPolicyResponse,
  DeletePublicAccessBlockRequest,
  PutBucketCorsRequest,
  UploadPartRequest,
  ListBucketAnalyticsConfigurationsResponse,
  ListBucketInventoryConfigurationsRequest,
  PutObjectLegalHoldResponse,
  PutObjectResponse,
  GetBucketIntelligentTieringConfigurationRequest,
  GetBucketPolicyStatusRequest,
  PutBucketIntelligentTieringConfigurationRequest,
  DeleteBucketInventoryConfigurationResponse,
  GetBucketLifecycleConfigurationRequest,
  GetObjectAclResponse,
  DeleteBucketInventoryConfigurationRequest,
  GetBucketRequestPaymentRequest,
  RecordsEvent,
  PutBucketAccelerateConfigurationRequest,
  SelectObjectContentResponse,
  DeleteBucketRequest,
  PutBucketVersioningResponse,
  PutBucketOwnershipControlsRequest,
  WriteGetObjectResponseResponse,
  PutObjectLegalHoldRequest,
  PutBucketPolicyResponse,
  DeleteBucketWebsiteRequest,
  GetObjectRequest,
  GetObjectTaggingRequest,
  CopyObjectRequest,
  Part,
  PutBucketInventoryConfigurationResponse,
  GetObjectRetentionResponse,
  DeleteBucketEncryptionRequest,
  GetBucketPolicyStatusResponse,
  GetObjectTorrentResponse,
  CompleteMultipartUploadRequest,
  DeleteBucketOwnershipControlsRequest,
  GetBucketAccelerateConfigurationResponse,
  PutObjectAclRequest,
  GetBucketAnalyticsConfigurationResponse,
  ListBucketInventoryConfigurationsResponse,
  CreateBucketRequest,
  ListObjectVersionsRequest,
  GetBucketMetricsConfigurationRequest,
  ListBucketAnalyticsConfigurationsRequest,
  GetBucketReplicationResponse,
  DeleteBucketWebsiteResponse,
  DeleteBucketCorsRequest,
  GetObjectAclRequest,
  GetBucketIntelligentTieringConfigurationResponse,
  DeleteBucketPolicyRequest,
  GetBucketRequestPaymentResponse,
  DeleteBucketAnalyticsConfigurationResponse,
  GetObjectTaggingResponse,
  GetObjectAttributesResponse,
  PutBucketOwnershipControlsResponse,
  GetObjectLegalHoldRequest,
  ListPartsRequest,
  CreateMultipartUploadRequest,
  PutBucketAclResponse,
  GetBucketAclResponse,
  GetBucketVersioningResponse,
  PutBucketReplicationResponse,
  PutBucketAnalyticsConfigurationResponse,
  AbortMultipartUploadResponse,
  ListBucketsResponse,
  ListBucketIntelligentTieringConfigurationsResponse,
  CopyObjectResponse,
  PutBucketTaggingRequest,
  GetObjectTorrentRequest,
  GetBucketMetricsConfigurationResponse,
  CreateMultipartUploadResponse,
  PutObjectLockConfigurationRequest,
  GetBucketLoggingResponse,
  DeleteObjectRequest,
  GetObjectAttributesRequest,
  GetObjectLockConfigurationRequest,
  GetBucketAnalyticsConfigurationRequest,
  PutBucketMetricsConfigurationResponse,
  CompleteMultipartUploadResponse,
  PutObjectAclResponse,
  GetObjectLegalHoldResponse,
  GetBucketEncryptionResponse,
  PutBucketLoggingRequest,
  GetBucketWebsiteResponse,
  GetBucketLocationResponse,
  S3Object,
  GetBucketAccelerateConfigurationRequest,
  PutBucketMetricsConfigurationRequest,
  PutBucketEncryptionResponse,
  MultipartUpload,
  PutBucketRequestPaymentRequest,
  DeleteBucketMetricsConfigurationRequest,
  ListObjectsV2Request
}
import software.amazon.awssdk.core.async.SdkPublisher
import io.github.vigoo.zioaws.s3.S3
import io.github.vigoo.zioaws.core.config.AwsConfig
import zio.{Task, ZManaged, IO, ZIO, ZLayer, URLayer, Has}
import software.amazon.awssdk.awscore.eventstream.EventStreamResponseHandler
import io.github.vigoo.zioaws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.stream.ZStream
import zio.test.mock.{Proxy, Mock}
package object s3 {
  import scala.jdk.CollectionConverters._
  type S3 = Has[S3.Service]
  object S3 {
    trait Service extends AspectSupport[Service] {
      val api: S3AsyncClient
      def uploadPart(
          request: io.github.vigoo.zioaws.s3.model.UploadPartRequest,
          body: ZStream[Any, AwsError, Byte]
      ): IO[
        AwsError,
        io.github.vigoo.zioaws.s3.model.UploadPartResponse.ReadOnly
      ]
      def createMultipartUpload(
          request: io.github.vigoo.zioaws.s3.model.CreateMultipartUploadRequest
      ): IO[
        AwsError,
        io.github.vigoo.zioaws.s3.model.CreateMultipartUploadResponse.ReadOnly
      ]
      def putBucketPolicy(
          request: io.github.vigoo.zioaws.s3.model.PutBucketPolicyRequest
      ): IO[AwsError, Unit]
      def getBucketPolicy(
          request: io.github.vigoo.zioaws.s3.model.GetBucketPolicyRequest
      ): IO[
        AwsError,
        io.github.vigoo.zioaws.s3.model.GetBucketPolicyResponse.ReadOnly
      ]
      def putBucketIntelligentTieringConfiguration(
          request: io.github.vigoo.zioaws.s3.model.PutBucketIntelligentTieringConfigurationRequest
      ): IO[AwsError, Unit]
      def restoreObject(
          request: io.github.vigoo.zioaws.s3.model.RestoreObjectRequest
      ): IO[
        AwsError,
        io.github.vigoo.zioaws.s3.model.RestoreObjectResponse.ReadOnly
      ]
      def deleteBucketWebsite(
          request: io.github.vigoo.zioaws.s3.model.DeleteBucketWebsiteRequest
      ): IO[AwsError, Unit]
      def putBucketLifecycleConfiguration(
          request: io.github.vigoo.zioaws.s3.model.PutBucketLifecycleConfigurationRequest
      ): IO[AwsError, Unit]
      def listObjectVersions(
          request: io.github.vigoo.zioaws.s3.model.ListObjectVersionsRequest
      ): ZStream[
        Any,
        AwsError,
        io.github.vigoo.zioaws.s3.model.ObjectVersion.ReadOnly
      ]
      def putBucketLogging(
          request: io.github.vigoo.zioaws.s3.model.PutBucketLoggingRequest
      ): IO[AwsError, Unit]
      def deleteBucketPolicy(
          request: io.github.vigoo.zioaws.s3.model.DeleteBucketPolicyRequest
      ): IO[AwsError, Unit]
      def putBucketAnalyticsConfiguration(
          request: io.github.vigoo.zioaws.s3.model.PutBucketAnalyticsConfigurationRequest
      ): IO[AwsError, Unit]
      def deleteBucketInventoryConfiguration(
          request: io.github.vigoo.zioaws.s3.model.DeleteBucketInventoryConfigurationRequest
      ): IO[AwsError, Unit]
      def getBucketAnalyticsConfiguration(
          request: io.github.vigoo.zioaws.s3.model.GetBucketAnalyticsConfigurationRequest
      ): IO[
        AwsError,
        io.github.vigoo.zioaws.s3.model.GetBucketAnalyticsConfigurationResponse.ReadOnly
      ]
      def putObjectAcl(
          request: io.github.vigoo.zioaws.s3.model.PutObjectAclRequest
      ): IO[
        AwsError,
        io.github.vigoo.zioaws.s3.model.PutObjectAclResponse.ReadOnly
      ]
      def listBucketAnalyticsConfigurations(
          request: io.github.vigoo.zioaws.s3.model.ListBucketAnalyticsConfigurationsRequest
      ): IO[
        AwsError,
        io.github.vigoo.zioaws.s3.model.ListBucketAnalyticsConfigurationsResponse.ReadOnly
      ]
      def deleteBucketLifecycle(
          request: io.github.vigoo.zioaws.s3.model.DeleteBucketLifecycleRequest
      ): IO[AwsError, Unit]
      def getObjectAcl(
          request: io.github.vigoo.zioaws.s3.model.GetObjectAclRequest
      ): IO[
        AwsError,
        io.github.vigoo.zioaws.s3.model.GetObjectAclResponse.ReadOnly
      ]
      def listBucketInventoryConfigurations(
          request: io.github.vigoo.zioaws.s3.model.ListBucketInventoryConfigurationsRequest
      ): IO[
        AwsError,
        io.github.vigoo.zioaws.s3.model.ListBucketInventoryConfigurationsResponse.ReadOnly
      ]
      def listMultipartUploads(
          request: io.github.vigoo.zioaws.s3.model.ListMultipartUploadsRequest
      ): ZStream[
        Any,
        AwsError,
        io.github.vigoo.zioaws.s3.model.MultipartUpload.ReadOnly
      ]
      def getBucketLifecycleConfiguration(
          request: io.github.vigoo.zioaws.s3.model.GetBucketLifecycleConfigurationRequest
      ): IO[
        AwsError,
        io.github.vigoo.zioaws.s3.model.GetBucketLifecycleConfigurationResponse.ReadOnly
      ]
      def getBucketEncryption(
          request: io.github.vigoo.zioaws.s3.model.GetBucketEncryptionRequest
      ): IO[
        AwsError,
        io.github.vigoo.zioaws.s3.model.GetBucketEncryptionResponse.ReadOnly
      ]
      def writeGetObjectResponse(
          request: io.github.vigoo.zioaws.s3.model.WriteGetObjectResponseRequest,
          body: ZStream[Any, AwsError, Byte]
      ): IO[AwsError, Unit]
      def getBucketCors(
          request: io.github.vigoo.zioaws.s3.model.GetBucketCorsRequest
      ): IO[
        AwsError,
        io.github.vigoo.zioaws.s3.model.GetBucketCorsResponse.ReadOnly
      ]
      def getObjectRetention(
          request: io.github.vigoo.zioaws.s3.model.GetObjectRetentionRequest
      ): IO[
        AwsError,
        io.github.vigoo.zioaws.s3.model.GetObjectRetentionResponse.ReadOnly
      ]
      def getBucketLogging(
          request: io.github.vigoo.zioaws.s3.model.GetBucketLoggingRequest
      ): IO[
        AwsError,
        io.github.vigoo.zioaws.s3.model.GetBucketLoggingResponse.ReadOnly
      ]
      def listParts(
          request: io.github.vigoo.zioaws.s3.model.ListPartsRequest
      ): ZStream[Any, AwsError, io.github.vigoo.zioaws.s3.model.Part.ReadOnly]
      def getObjectAttributes(
          request: io.github.vigoo.zioaws.s3.model.GetObjectAttributesRequest
      ): IO[
        AwsError,
        io.github.vigoo.zioaws.s3.model.GetObjectAttributesResponse.ReadOnly
      ]
      def listBucketIntelligentTieringConfigurations(
          request: io.github.vigoo.zioaws.s3.model.ListBucketIntelligentTieringConfigurationsRequest
      ): IO[
        AwsError,
        io.github.vigoo.zioaws.s3.model.ListBucketIntelligentTieringConfigurationsResponse.ReadOnly
      ]
      def listBucketMetricsConfigurations(
          request: io.github.vigoo.zioaws.s3.model.ListBucketMetricsConfigurationsRequest
      ): IO[
        AwsError,
        io.github.vigoo.zioaws.s3.model.ListBucketMetricsConfigurationsResponse.ReadOnly
      ]
      def putBucketMetricsConfiguration(
          request: io.github.vigoo.zioaws.s3.model.PutBucketMetricsConfigurationRequest
      ): IO[AwsError, Unit]
      def deleteBucketAnalyticsConfiguration(
          request: io.github.vigoo.zioaws.s3.model.DeleteBucketAnalyticsConfigurationRequest
      ): IO[AwsError, Unit]
      def deleteBucketReplication(
          request: io.github.vigoo.zioaws.s3.model.DeleteBucketReplicationRequest
      ): IO[AwsError, Unit]
      def uploadPartCopy(
          request: io.github.vigoo.zioaws.s3.model.UploadPartCopyRequest
      ): IO[
        AwsError,
        io.github.vigoo.zioaws.s3.model.UploadPartCopyResponse.ReadOnly
      ]
      def getObjectLegalHold(
          request: io.github.vigoo.zioaws.s3.model.GetObjectLegalHoldRequest
      ): IO[
        AwsError,
        io.github.vigoo.zioaws.s3.model.GetObjectLegalHoldResponse.ReadOnly
      ]
      def getBucketRequestPayment(
          request: io.github.vigoo.zioaws.s3.model.GetBucketRequestPaymentRequest
      ): IO[
        AwsError,
        io.github.vigoo.zioaws.s3.model.GetBucketRequestPaymentResponse.ReadOnly
      ]
      def getBucketMetricsConfiguration(
          request: io.github.vigoo.zioaws.s3.model.GetBucketMetricsConfigurationRequest
      ): IO[
        AwsError,
        io.github.vigoo.zioaws.s3.model.GetBucketMetricsConfigurationResponse.ReadOnly
      ]
      def copyObject(
          request: io.github.vigoo.zioaws.s3.model.CopyObjectRequest
      ): IO[
        AwsError,
        io.github.vigoo.zioaws.s3.model.CopyObjectResponse.ReadOnly
      ]
      def putBucketWebsite(
          request: io.github.vigoo.zioaws.s3.model.PutBucketWebsiteRequest
      ): IO[AwsError, Unit]
      def getBucketAccelerateConfiguration(
          request: io.github.vigoo.zioaws.s3.model.GetBucketAccelerateConfigurationRequest
      ): IO[
        AwsError,
        io.github.vigoo.zioaws.s3.model.GetBucketAccelerateConfigurationResponse.ReadOnly
      ]
      def headBucket(
          request: io.github.vigoo.zioaws.s3.model.HeadBucketRequest
      ): IO[AwsError, Unit]
      def deleteObject(
          request: io.github.vigoo.zioaws.s3.model.DeleteObjectRequest
      ): IO[
        AwsError,
        io.github.vigoo.zioaws.s3.model.DeleteObjectResponse.ReadOnly
      ]
      def getBucketOwnershipControls(
          request: io.github.vigoo.zioaws.s3.model.GetBucketOwnershipControlsRequest
      ): IO[
        AwsError,
        io.github.vigoo.zioaws.s3.model.GetBucketOwnershipControlsResponse.ReadOnly
      ]
      def putBucketReplication(
          request: io.github.vigoo.zioaws.s3.model.PutBucketReplicationRequest
      ): IO[AwsError, Unit]
      def deleteBucket(
          request: io.github.vigoo.zioaws.s3.model.DeleteBucketRequest
      ): IO[AwsError, Unit]
      def putBucketNotificationConfiguration(
          request: io.github.vigoo.zioaws.s3.model.PutBucketNotificationConfigurationRequest
      ): IO[AwsError, Unit]
      def deleteBucketMetricsConfiguration(
          request: io.github.vigoo.zioaws.s3.model.DeleteBucketMetricsConfigurationRequest
      ): IO[AwsError, Unit]
      def createBucket(
          request: io.github.vigoo.zioaws.s3.model.CreateBucketRequest
      ): IO[
        AwsError,
        io.github.vigoo.zioaws.s3.model.CreateBucketResponse.ReadOnly
      ]
      def listObjects(
          request: io.github.vigoo.zioaws.s3.model.ListObjectsRequest
      ): IO[
        AwsError,
        io.github.vigoo.zioaws.s3.model.ListObjectsResponse.ReadOnly
      ]
      def listBuckets(): IO[
        AwsError,
        io.github.vigoo.zioaws.s3.model.ListBucketsResponse.ReadOnly
      ]
      def getBucketTagging(
          request: io.github.vigoo.zioaws.s3.model.GetBucketTaggingRequest
      ): IO[
        AwsError,
        io.github.vigoo.zioaws.s3.model.GetBucketTaggingResponse.ReadOnly
      ]
      def putObject(
          request: io.github.vigoo.zioaws.s3.model.PutObjectRequest,
          body: ZStream[Any, AwsError, Byte]
      ): IO[
        AwsError,
        io.github.vigoo.zioaws.s3.model.PutObjectResponse.ReadOnly
      ]
      def putBucketTagging(
          request: io.github.vigoo.zioaws.s3.model.PutBucketTaggingRequest
      ): IO[AwsError, Unit]
      def deleteBucketTagging(
          request: io.github.vigoo.zioaws.s3.model.DeleteBucketTaggingRequest
      ): IO[AwsError, Unit]
      def putBucketEncryption(
          request: io.github.vigoo.zioaws.s3.model.PutBucketEncryptionRequest
      ): IO[AwsError, Unit]
      def putBucketRequestPayment(
          request: io.github.vigoo.zioaws.s3.model.PutBucketRequestPaymentRequest
      ): IO[AwsError, Unit]
      def getObject(
          request: io.github.vigoo.zioaws.s3.model.GetObjectRequest
      ): IO[AwsError, StreamingOutputResult[
        Any,
        io.github.vigoo.zioaws.s3.model.GetObjectResponse.ReadOnly,
        Byte
      ]]
      def putObjectTagging(
          request: io.github.vigoo.zioaws.s3.model.PutObjectTaggingRequest
      ): IO[
        AwsError,
        io.github.vigoo.zioaws.s3.model.PutObjectTaggingResponse.ReadOnly
      ]
      def deleteBucketCors(
          request: io.github.vigoo.zioaws.s3.model.DeleteBucketCorsRequest
      ): IO[AwsError, Unit]
      def putPublicAccessBlock(
          request: io.github.vigoo.zioaws.s3.model.PutPublicAccessBlockRequest
      ): IO[AwsError, Unit]
      def getObjectTorrent(
          request: io.github.vigoo.zioaws.s3.model.GetObjectTorrentRequest
      ): IO[AwsError, StreamingOutputResult[
        Any,
        io.github.vigoo.zioaws.s3.model.GetObjectTorrentResponse.ReadOnly,
        Byte
      ]]
      def getBucketInventoryConfiguration(
          request: io.github.vigoo.zioaws.s3.model.GetBucketInventoryConfigurationRequest
      ): IO[
        AwsError,
        io.github.vigoo.zioaws.s3.model.GetBucketInventoryConfigurationResponse.ReadOnly
      ]
      def getBucketVersioning(
          request: io.github.vigoo.zioaws.s3.model.GetBucketVersioningRequest
      ): IO[
        AwsError,
        io.github.vigoo.zioaws.s3.model.GetBucketVersioningResponse.ReadOnly
      ]
      def putBucketOwnershipControls(
          request: io.github.vigoo.zioaws.s3.model.PutBucketOwnershipControlsRequest
      ): IO[AwsError, Unit]
      def headObject(
          request: io.github.vigoo.zioaws.s3.model.HeadObjectRequest
      ): IO[
        AwsError,
        io.github.vigoo.zioaws.s3.model.HeadObjectResponse.ReadOnly
      ]
      def selectObjectContent(
          request: io.github.vigoo.zioaws.s3.model.SelectObjectContentRequest
      ): ZStream[
        Any,
        AwsError,
        io.github.vigoo.zioaws.s3.model.RecordsEvent.ReadOnly
      ]
      def getBucketWebsite(
          request: io.github.vigoo.zioaws.s3.model.GetBucketWebsiteRequest
      ): IO[
        AwsError,
        io.github.vigoo.zioaws.s3.model.GetBucketWebsiteResponse.ReadOnly
      ]
      def deleteBucketIntelligentTieringConfiguration(
          request: io.github.vigoo.zioaws.s3.model.DeleteBucketIntelligentTieringConfigurationRequest
      ): IO[AwsError, Unit]
      def putBucketInventoryConfiguration(
          request: io.github.vigoo.zioaws.s3.model.PutBucketInventoryConfigurationRequest
      ): IO[AwsError, Unit]
      def getBucketIntelligentTieringConfiguration(
          request: io.github.vigoo.zioaws.s3.model.GetBucketIntelligentTieringConfigurationRequest
      ): IO[
        AwsError,
        io.github.vigoo.zioaws.s3.model.GetBucketIntelligentTieringConfigurationResponse.ReadOnly
      ]
      def getBucketAcl(
          request: io.github.vigoo.zioaws.s3.model.GetBucketAclRequest
      ): IO[
        AwsError,
        io.github.vigoo.zioaws.s3.model.GetBucketAclResponse.ReadOnly
      ]
      def listObjectsV2(
          request: io.github.vigoo.zioaws.s3.model.ListObjectsV2Request
      ): ZStream[
        Any,
        AwsError,
        io.github.vigoo.zioaws.s3.model.S3Object.ReadOnly
      ]
      def putBucketVersioning(
          request: io.github.vigoo.zioaws.s3.model.PutBucketVersioningRequest
      ): IO[AwsError, Unit]
      def putBucketAcl(
          request: io.github.vigoo.zioaws.s3.model.PutBucketAclRequest
      ): IO[AwsError, Unit]
      def getBucketReplication(
          request: io.github.vigoo.zioaws.s3.model.GetBucketReplicationRequest
      ): IO[
        AwsError,
        io.github.vigoo.zioaws.s3.model.GetBucketReplicationResponse.ReadOnly
      ]
      def getPublicAccessBlock(
          request: io.github.vigoo.zioaws.s3.model.GetPublicAccessBlockRequest
      ): IO[
        AwsError,
        io.github.vigoo.zioaws.s3.model.GetPublicAccessBlockResponse.ReadOnly
      ]
      def putObjectLegalHold(
          request: io.github.vigoo.zioaws.s3.model.PutObjectLegalHoldRequest
      ): IO[
        AwsError,
        io.github.vigoo.zioaws.s3.model.PutObjectLegalHoldResponse.ReadOnly
      ]
      def getObjectLockConfiguration(
          request: io.github.vigoo.zioaws.s3.model.GetObjectLockConfigurationRequest
      ): IO[
        AwsError,
        io.github.vigoo.zioaws.s3.model.GetObjectLockConfigurationResponse.ReadOnly
      ]
      def getBucketLocation(
          request: io.github.vigoo.zioaws.s3.model.GetBucketLocationRequest
      ): IO[
        AwsError,
        io.github.vigoo.zioaws.s3.model.GetBucketLocationResponse.ReadOnly
      ]
      def deleteObjects(
          request: io.github.vigoo.zioaws.s3.model.DeleteObjectsRequest
      ): IO[AwsError, ReadOnly]
      def abortMultipartUpload(
          request: io.github.vigoo.zioaws.s3.model.AbortMultipartUploadRequest
      ): IO[
        AwsError,
        io.github.vigoo.zioaws.s3.model.AbortMultipartUploadResponse.ReadOnly
      ]
      def getBucketPolicyStatus(
          request: io.github.vigoo.zioaws.s3.model.GetBucketPolicyStatusRequest
      ): IO[
        AwsError,
        io.github.vigoo.zioaws.s3.model.GetBucketPolicyStatusResponse.ReadOnly
      ]
      def deleteBucketOwnershipControls(
          request: io.github.vigoo.zioaws.s3.model.DeleteBucketOwnershipControlsRequest
      ): IO[AwsError, Unit]
      def putObjectRetention(
          request: io.github.vigoo.zioaws.s3.model.PutObjectRetentionRequest
      ): IO[
        AwsError,
        io.github.vigoo.zioaws.s3.model.PutObjectRetentionResponse.ReadOnly
      ]
      def putBucketCors(
          request: io.github.vigoo.zioaws.s3.model.PutBucketCorsRequest
      ): IO[AwsError, Unit]
      def deleteObjectTagging(
          request: io.github.vigoo.zioaws.s3.model.DeleteObjectTaggingRequest
      ): IO[
        AwsError,
        io.github.vigoo.zioaws.s3.model.DeleteObjectTaggingResponse.ReadOnly
      ]
      def deletePublicAccessBlock(
          request: io.github.vigoo.zioaws.s3.model.DeletePublicAccessBlockRequest
      ): IO[AwsError, Unit]
      def deleteBucketEncryption(
          request: io.github.vigoo.zioaws.s3.model.DeleteBucketEncryptionRequest
      ): IO[AwsError, Unit]
      def completeMultipartUpload(
          request: io.github.vigoo.zioaws.s3.model.CompleteMultipartUploadRequest
      ): IO[
        AwsError,
        io.github.vigoo.zioaws.s3.model.CompleteMultipartUploadResponse.ReadOnly
      ]
      def getObjectTagging(
          request: io.github.vigoo.zioaws.s3.model.GetObjectTaggingRequest
      ): IO[
        AwsError,
        io.github.vigoo.zioaws.s3.model.GetObjectTaggingResponse.ReadOnly
      ]
      def putObjectLockConfiguration(
          request: io.github.vigoo.zioaws.s3.model.PutObjectLockConfigurationRequest
      ): IO[
        AwsError,
        io.github.vigoo.zioaws.s3.model.PutObjectLockConfigurationResponse.ReadOnly
      ]
      def putBucketAccelerateConfiguration(
          request: io.github.vigoo.zioaws.s3.model.PutBucketAccelerateConfigurationRequest
      ): IO[AwsError, Unit]
      def getBucketNotificationConfiguration(
          request: io.github.vigoo.zioaws.s3.model.GetBucketNotificationConfigurationRequest
      ): IO[
        AwsError,
        io.github.vigoo.zioaws.s3.model.GetBucketNotificationConfigurationResponse.ReadOnly
      ]
    }
    object S3Mock extends Mock[S3] {
      object UploadPart
          extends Effect[
            Tuple2[io.github.vigoo.zioaws.s3.model.UploadPartRequest, ZStream[
              Any,
              AwsError,
              Byte
            ]],
            AwsError,
            io.github.vigoo.zioaws.s3.model.UploadPartResponse.ReadOnly
          ]
      object CreateMultipartUpload
          extends Effect[
            io.github.vigoo.zioaws.s3.model.CreateMultipartUploadRequest,
            AwsError,
            io.github.vigoo.zioaws.s3.model.CreateMultipartUploadResponse.ReadOnly
          ]
      object PutBucketPolicy
          extends Effect[
            io.github.vigoo.zioaws.s3.model.PutBucketPolicyRequest,
            AwsError,
            Unit
          ]
      object GetBucketPolicy
          extends Effect[
            io.github.vigoo.zioaws.s3.model.GetBucketPolicyRequest,
            AwsError,
            io.github.vigoo.zioaws.s3.model.GetBucketPolicyResponse.ReadOnly
          ]
      object PutBucketIntelligentTieringConfiguration
          extends Effect[
            io.github.vigoo.zioaws.s3.model.PutBucketIntelligentTieringConfigurationRequest,
            AwsError,
            Unit
          ]
      object RestoreObject
          extends Effect[
            io.github.vigoo.zioaws.s3.model.RestoreObjectRequest,
            AwsError,
            io.github.vigoo.zioaws.s3.model.RestoreObjectResponse.ReadOnly
          ]
      object DeleteBucketWebsite
          extends Effect[
            io.github.vigoo.zioaws.s3.model.DeleteBucketWebsiteRequest,
            AwsError,
            Unit
          ]
      object PutBucketLifecycleConfiguration
          extends Effect[
            io.github.vigoo.zioaws.s3.model.PutBucketLifecycleConfigurationRequest,
            AwsError,
            Unit
          ]
      object ListObjectVersions
          extends Stream[
            io.github.vigoo.zioaws.s3.model.ListObjectVersionsRequest,
            AwsError,
            io.github.vigoo.zioaws.s3.model.ObjectVersion.ReadOnly
          ]
      object PutBucketLogging
          extends Effect[
            io.github.vigoo.zioaws.s3.model.PutBucketLoggingRequest,
            AwsError,
            Unit
          ]
      object DeleteBucketPolicy
          extends Effect[
            io.github.vigoo.zioaws.s3.model.DeleteBucketPolicyRequest,
            AwsError,
            Unit
          ]
      object PutBucketAnalyticsConfiguration
          extends Effect[
            io.github.vigoo.zioaws.s3.model.PutBucketAnalyticsConfigurationRequest,
            AwsError,
            Unit
          ]
      object DeleteBucketInventoryConfiguration
          extends Effect[
            io.github.vigoo.zioaws.s3.model.DeleteBucketInventoryConfigurationRequest,
            AwsError,
            Unit
          ]
      object GetBucketAnalyticsConfiguration
          extends Effect[
            io.github.vigoo.zioaws.s3.model.GetBucketAnalyticsConfigurationRequest,
            AwsError,
            io.github.vigoo.zioaws.s3.model.GetBucketAnalyticsConfigurationResponse.ReadOnly
          ]
      object PutObjectAcl
          extends Effect[
            io.github.vigoo.zioaws.s3.model.PutObjectAclRequest,
            AwsError,
            io.github.vigoo.zioaws.s3.model.PutObjectAclResponse.ReadOnly
          ]
      object ListBucketAnalyticsConfigurations
          extends Effect[
            io.github.vigoo.zioaws.s3.model.ListBucketAnalyticsConfigurationsRequest,
            AwsError,
            io.github.vigoo.zioaws.s3.model.ListBucketAnalyticsConfigurationsResponse.ReadOnly
          ]
      object DeleteBucketLifecycle
          extends Effect[
            io.github.vigoo.zioaws.s3.model.DeleteBucketLifecycleRequest,
            AwsError,
            Unit
          ]
      object GetObjectAcl
          extends Effect[
            io.github.vigoo.zioaws.s3.model.GetObjectAclRequest,
            AwsError,
            io.github.vigoo.zioaws.s3.model.GetObjectAclResponse.ReadOnly
          ]
      object ListBucketInventoryConfigurations
          extends Effect[
            io.github.vigoo.zioaws.s3.model.ListBucketInventoryConfigurationsRequest,
            AwsError,
            io.github.vigoo.zioaws.s3.model.ListBucketInventoryConfigurationsResponse.ReadOnly
          ]
      object ListMultipartUploads
          extends Stream[
            io.github.vigoo.zioaws.s3.model.ListMultipartUploadsRequest,
            AwsError,
            io.github.vigoo.zioaws.s3.model.MultipartUpload.ReadOnly
          ]
      object GetBucketLifecycleConfiguration
          extends Effect[
            io.github.vigoo.zioaws.s3.model.GetBucketLifecycleConfigurationRequest,
            AwsError,
            io.github.vigoo.zioaws.s3.model.GetBucketLifecycleConfigurationResponse.ReadOnly
          ]
      object GetBucketEncryption
          extends Effect[
            io.github.vigoo.zioaws.s3.model.GetBucketEncryptionRequest,
            AwsError,
            io.github.vigoo.zioaws.s3.model.GetBucketEncryptionResponse.ReadOnly
          ]
      object WriteGetObjectResponse
          extends Effect[Tuple2[
            io.github.vigoo.zioaws.s3.model.WriteGetObjectResponseRequest,
            ZStream[Any, AwsError, Byte]
          ], AwsError, Unit]
      object GetBucketCors
          extends Effect[
            io.github.vigoo.zioaws.s3.model.GetBucketCorsRequest,
            AwsError,
            io.github.vigoo.zioaws.s3.model.GetBucketCorsResponse.ReadOnly
          ]
      object GetObjectRetention
          extends Effect[
            io.github.vigoo.zioaws.s3.model.GetObjectRetentionRequest,
            AwsError,
            io.github.vigoo.zioaws.s3.model.GetObjectRetentionResponse.ReadOnly
          ]
      object GetBucketLogging
          extends Effect[
            io.github.vigoo.zioaws.s3.model.GetBucketLoggingRequest,
            AwsError,
            io.github.vigoo.zioaws.s3.model.GetBucketLoggingResponse.ReadOnly
          ]
      object ListParts
          extends Stream[
            io.github.vigoo.zioaws.s3.model.ListPartsRequest,
            AwsError,
            io.github.vigoo.zioaws.s3.model.Part.ReadOnly
          ]
      object GetObjectAttributes
          extends Effect[
            io.github.vigoo.zioaws.s3.model.GetObjectAttributesRequest,
            AwsError,
            io.github.vigoo.zioaws.s3.model.GetObjectAttributesResponse.ReadOnly
          ]
      object ListBucketIntelligentTieringConfigurations
          extends Effect[
            io.github.vigoo.zioaws.s3.model.ListBucketIntelligentTieringConfigurationsRequest,
            AwsError,
            io.github.vigoo.zioaws.s3.model.ListBucketIntelligentTieringConfigurationsResponse.ReadOnly
          ]
      object ListBucketMetricsConfigurations
          extends Effect[
            io.github.vigoo.zioaws.s3.model.ListBucketMetricsConfigurationsRequest,
            AwsError,
            io.github.vigoo.zioaws.s3.model.ListBucketMetricsConfigurationsResponse.ReadOnly
          ]
      object PutBucketMetricsConfiguration
          extends Effect[
            io.github.vigoo.zioaws.s3.model.PutBucketMetricsConfigurationRequest,
            AwsError,
            Unit
          ]
      object DeleteBucketAnalyticsConfiguration
          extends Effect[
            io.github.vigoo.zioaws.s3.model.DeleteBucketAnalyticsConfigurationRequest,
            AwsError,
            Unit
          ]
      object DeleteBucketReplication
          extends Effect[
            io.github.vigoo.zioaws.s3.model.DeleteBucketReplicationRequest,
            AwsError,
            Unit
          ]
      object UploadPartCopy
          extends Effect[
            io.github.vigoo.zioaws.s3.model.UploadPartCopyRequest,
            AwsError,
            io.github.vigoo.zioaws.s3.model.UploadPartCopyResponse.ReadOnly
          ]
      object GetObjectLegalHold
          extends Effect[
            io.github.vigoo.zioaws.s3.model.GetObjectLegalHoldRequest,
            AwsError,
            io.github.vigoo.zioaws.s3.model.GetObjectLegalHoldResponse.ReadOnly
          ]
      object GetBucketRequestPayment
          extends Effect[
            io.github.vigoo.zioaws.s3.model.GetBucketRequestPaymentRequest,
            AwsError,
            io.github.vigoo.zioaws.s3.model.GetBucketRequestPaymentResponse.ReadOnly
          ]
      object GetBucketMetricsConfiguration
          extends Effect[
            io.github.vigoo.zioaws.s3.model.GetBucketMetricsConfigurationRequest,
            AwsError,
            io.github.vigoo.zioaws.s3.model.GetBucketMetricsConfigurationResponse.ReadOnly
          ]
      object CopyObject
          extends Effect[
            io.github.vigoo.zioaws.s3.model.CopyObjectRequest,
            AwsError,
            io.github.vigoo.zioaws.s3.model.CopyObjectResponse.ReadOnly
          ]
      object PutBucketWebsite
          extends Effect[
            io.github.vigoo.zioaws.s3.model.PutBucketWebsiteRequest,
            AwsError,
            Unit
          ]
      object GetBucketAccelerateConfiguration
          extends Effect[
            io.github.vigoo.zioaws.s3.model.GetBucketAccelerateConfigurationRequest,
            AwsError,
            io.github.vigoo.zioaws.s3.model.GetBucketAccelerateConfigurationResponse.ReadOnly
          ]
      object HeadBucket
          extends Effect[
            io.github.vigoo.zioaws.s3.model.HeadBucketRequest,
            AwsError,
            Unit
          ]
      object DeleteObject
          extends Effect[
            io.github.vigoo.zioaws.s3.model.DeleteObjectRequest,
            AwsError,
            io.github.vigoo.zioaws.s3.model.DeleteObjectResponse.ReadOnly
          ]
      object GetBucketOwnershipControls
          extends Effect[
            io.github.vigoo.zioaws.s3.model.GetBucketOwnershipControlsRequest,
            AwsError,
            io.github.vigoo.zioaws.s3.model.GetBucketOwnershipControlsResponse.ReadOnly
          ]
      object PutBucketReplication
          extends Effect[
            io.github.vigoo.zioaws.s3.model.PutBucketReplicationRequest,
            AwsError,
            Unit
          ]
      object DeleteBucket
          extends Effect[
            io.github.vigoo.zioaws.s3.model.DeleteBucketRequest,
            AwsError,
            Unit
          ]
      object PutBucketNotificationConfiguration
          extends Effect[
            io.github.vigoo.zioaws.s3.model.PutBucketNotificationConfigurationRequest,
            AwsError,
            Unit
          ]
      object DeleteBucketMetricsConfiguration
          extends Effect[
            io.github.vigoo.zioaws.s3.model.DeleteBucketMetricsConfigurationRequest,
            AwsError,
            Unit
          ]
      object CreateBucket
          extends Effect[
            io.github.vigoo.zioaws.s3.model.CreateBucketRequest,
            AwsError,
            io.github.vigoo.zioaws.s3.model.CreateBucketResponse.ReadOnly
          ]
      object ListObjects
          extends Effect[
            io.github.vigoo.zioaws.s3.model.ListObjectsRequest,
            AwsError,
            io.github.vigoo.zioaws.s3.model.ListObjectsResponse.ReadOnly
          ]
      object ListBuckets
          extends Effect[
            Unit,
            AwsError,
            io.github.vigoo.zioaws.s3.model.ListBucketsResponse.ReadOnly
          ]
      object GetBucketTagging
          extends Effect[
            io.github.vigoo.zioaws.s3.model.GetBucketTaggingRequest,
            AwsError,
            io.github.vigoo.zioaws.s3.model.GetBucketTaggingResponse.ReadOnly
          ]
      object PutObject
          extends Effect[
            Tuple2[io.github.vigoo.zioaws.s3.model.PutObjectRequest, ZStream[
              Any,
              AwsError,
              Byte
            ]],
            AwsError,
            io.github.vigoo.zioaws.s3.model.PutObjectResponse.ReadOnly
          ]
      object PutBucketTagging
          extends Effect[
            io.github.vigoo.zioaws.s3.model.PutBucketTaggingRequest,
            AwsError,
            Unit
          ]
      object DeleteBucketTagging
          extends Effect[
            io.github.vigoo.zioaws.s3.model.DeleteBucketTaggingRequest,
            AwsError,
            Unit
          ]
      object PutBucketEncryption
          extends Effect[
            io.github.vigoo.zioaws.s3.model.PutBucketEncryptionRequest,
            AwsError,
            Unit
          ]
      object PutBucketRequestPayment
          extends Effect[
            io.github.vigoo.zioaws.s3.model.PutBucketRequestPaymentRequest,
            AwsError,
            Unit
          ]
      object GetObject
          extends Effect[
            io.github.vigoo.zioaws.s3.model.GetObjectRequest,
            AwsError,
            StreamingOutputResult[
              Any,
              io.github.vigoo.zioaws.s3.model.GetObjectResponse.ReadOnly,
              Byte
            ]
          ]
      object PutObjectTagging
          extends Effect[
            io.github.vigoo.zioaws.s3.model.PutObjectTaggingRequest,
            AwsError,
            io.github.vigoo.zioaws.s3.model.PutObjectTaggingResponse.ReadOnly
          ]
      object DeleteBucketCors
          extends Effect[
            io.github.vigoo.zioaws.s3.model.DeleteBucketCorsRequest,
            AwsError,
            Unit
          ]
      object PutPublicAccessBlock
          extends Effect[
            io.github.vigoo.zioaws.s3.model.PutPublicAccessBlockRequest,
            AwsError,
            Unit
          ]
      object GetObjectTorrent
          extends Effect[
            io.github.vigoo.zioaws.s3.model.GetObjectTorrentRequest,
            AwsError,
            StreamingOutputResult[
              Any,
              io.github.vigoo.zioaws.s3.model.GetObjectTorrentResponse.ReadOnly,
              Byte
            ]
          ]
      object GetBucketInventoryConfiguration
          extends Effect[
            io.github.vigoo.zioaws.s3.model.GetBucketInventoryConfigurationRequest,
            AwsError,
            io.github.vigoo.zioaws.s3.model.GetBucketInventoryConfigurationResponse.ReadOnly
          ]
      object GetBucketVersioning
          extends Effect[
            io.github.vigoo.zioaws.s3.model.GetBucketVersioningRequest,
            AwsError,
            io.github.vigoo.zioaws.s3.model.GetBucketVersioningResponse.ReadOnly
          ]
      object PutBucketOwnershipControls
          extends Effect[
            io.github.vigoo.zioaws.s3.model.PutBucketOwnershipControlsRequest,
            AwsError,
            Unit
          ]
      object HeadObject
          extends Effect[
            io.github.vigoo.zioaws.s3.model.HeadObjectRequest,
            AwsError,
            io.github.vigoo.zioaws.s3.model.HeadObjectResponse.ReadOnly
          ]
      object SelectObjectContent
          extends Stream[
            io.github.vigoo.zioaws.s3.model.SelectObjectContentRequest,
            AwsError,
            io.github.vigoo.zioaws.s3.model.RecordsEvent.ReadOnly
          ]
      object GetBucketWebsite
          extends Effect[
            io.github.vigoo.zioaws.s3.model.GetBucketWebsiteRequest,
            AwsError,
            io.github.vigoo.zioaws.s3.model.GetBucketWebsiteResponse.ReadOnly
          ]
      object DeleteBucketIntelligentTieringConfiguration
          extends Effect[
            io.github.vigoo.zioaws.s3.model.DeleteBucketIntelligentTieringConfigurationRequest,
            AwsError,
            Unit
          ]
      object PutBucketInventoryConfiguration
          extends Effect[
            io.github.vigoo.zioaws.s3.model.PutBucketInventoryConfigurationRequest,
            AwsError,
            Unit
          ]
      object GetBucketIntelligentTieringConfiguration
          extends Effect[
            io.github.vigoo.zioaws.s3.model.GetBucketIntelligentTieringConfigurationRequest,
            AwsError,
            io.github.vigoo.zioaws.s3.model.GetBucketIntelligentTieringConfigurationResponse.ReadOnly
          ]
      object GetBucketAcl
          extends Effect[
            io.github.vigoo.zioaws.s3.model.GetBucketAclRequest,
            AwsError,
            io.github.vigoo.zioaws.s3.model.GetBucketAclResponse.ReadOnly
          ]
      object ListObjectsV2
          extends Stream[
            io.github.vigoo.zioaws.s3.model.ListObjectsV2Request,
            AwsError,
            io.github.vigoo.zioaws.s3.model.S3Object.ReadOnly
          ]
      object PutBucketVersioning
          extends Effect[
            io.github.vigoo.zioaws.s3.model.PutBucketVersioningRequest,
            AwsError,
            Unit
          ]
      object PutBucketAcl
          extends Effect[
            io.github.vigoo.zioaws.s3.model.PutBucketAclRequest,
            AwsError,
            Unit
          ]
      object GetBucketReplication
          extends Effect[
            io.github.vigoo.zioaws.s3.model.GetBucketReplicationRequest,
            AwsError,
            io.github.vigoo.zioaws.s3.model.GetBucketReplicationResponse.ReadOnly
          ]
      object GetPublicAccessBlock
          extends Effect[
            io.github.vigoo.zioaws.s3.model.GetPublicAccessBlockRequest,
            AwsError,
            io.github.vigoo.zioaws.s3.model.GetPublicAccessBlockResponse.ReadOnly
          ]
      object PutObjectLegalHold
          extends Effect[
            io.github.vigoo.zioaws.s3.model.PutObjectLegalHoldRequest,
            AwsError,
            io.github.vigoo.zioaws.s3.model.PutObjectLegalHoldResponse.ReadOnly
          ]
      object GetObjectLockConfiguration
          extends Effect[
            io.github.vigoo.zioaws.s3.model.GetObjectLockConfigurationRequest,
            AwsError,
            io.github.vigoo.zioaws.s3.model.GetObjectLockConfigurationResponse.ReadOnly
          ]
      object GetBucketLocation
          extends Effect[
            io.github.vigoo.zioaws.s3.model.GetBucketLocationRequest,
            AwsError,
            io.github.vigoo.zioaws.s3.model.GetBucketLocationResponse.ReadOnly
          ]
      object DeleteObjects
          extends Effect[
            io.github.vigoo.zioaws.s3.model.DeleteObjectsRequest,
            AwsError,
            ReadOnly
          ]
      object AbortMultipartUpload
          extends Effect[
            io.github.vigoo.zioaws.s3.model.AbortMultipartUploadRequest,
            AwsError,
            io.github.vigoo.zioaws.s3.model.AbortMultipartUploadResponse.ReadOnly
          ]
      object GetBucketPolicyStatus
          extends Effect[
            io.github.vigoo.zioaws.s3.model.GetBucketPolicyStatusRequest,
            AwsError,
            io.github.vigoo.zioaws.s3.model.GetBucketPolicyStatusResponse.ReadOnly
          ]
      object DeleteBucketOwnershipControls
          extends Effect[
            io.github.vigoo.zioaws.s3.model.DeleteBucketOwnershipControlsRequest,
            AwsError,
            Unit
          ]
      object PutObjectRetention
          extends Effect[
            io.github.vigoo.zioaws.s3.model.PutObjectRetentionRequest,
            AwsError,
            io.github.vigoo.zioaws.s3.model.PutObjectRetentionResponse.ReadOnly
          ]
      object PutBucketCors
          extends Effect[
            io.github.vigoo.zioaws.s3.model.PutBucketCorsRequest,
            AwsError,
            Unit
          ]
      object DeleteObjectTagging
          extends Effect[
            io.github.vigoo.zioaws.s3.model.DeleteObjectTaggingRequest,
            AwsError,
            io.github.vigoo.zioaws.s3.model.DeleteObjectTaggingResponse.ReadOnly
          ]
      object DeletePublicAccessBlock
          extends Effect[
            io.github.vigoo.zioaws.s3.model.DeletePublicAccessBlockRequest,
            AwsError,
            Unit
          ]
      object DeleteBucketEncryption
          extends Effect[
            io.github.vigoo.zioaws.s3.model.DeleteBucketEncryptionRequest,
            AwsError,
            Unit
          ]
      object CompleteMultipartUpload
          extends Effect[
            io.github.vigoo.zioaws.s3.model.CompleteMultipartUploadRequest,
            AwsError,
            io.github.vigoo.zioaws.s3.model.CompleteMultipartUploadResponse.ReadOnly
          ]
      object GetObjectTagging
          extends Effect[
            io.github.vigoo.zioaws.s3.model.GetObjectTaggingRequest,
            AwsError,
            io.github.vigoo.zioaws.s3.model.GetObjectTaggingResponse.ReadOnly
          ]
      object PutObjectLockConfiguration
          extends Effect[
            io.github.vigoo.zioaws.s3.model.PutObjectLockConfigurationRequest,
            AwsError,
            io.github.vigoo.zioaws.s3.model.PutObjectLockConfigurationResponse.ReadOnly
          ]
      object PutBucketAccelerateConfiguration
          extends Effect[
            io.github.vigoo.zioaws.s3.model.PutBucketAccelerateConfigurationRequest,
            AwsError,
            Unit
          ]
      object GetBucketNotificationConfiguration
          extends Effect[
            io.github.vigoo.zioaws.s3.model.GetBucketNotificationConfigurationRequest,
            AwsError,
            io.github.vigoo.zioaws.s3.model.GetBucketNotificationConfigurationResponse.ReadOnly
          ]
      val compose: URLayer[Has[Proxy], S3] = ZLayer.fromServiceM { proxy =>
        withRuntime.map { rts =>
          new S3.Service {
            val api: S3AsyncClient = null
            def withAspect[R1](
                newAspect: AwsCallAspect[R1],
                r: R1
            ): S3.Service = this
            def uploadPart(
                request: io.github.vigoo.zioaws.s3.model.UploadPartRequest,
                body: ZStream[Any, AwsError, Byte]
            ): IO[
              AwsError,
              io.github.vigoo.zioaws.s3.model.UploadPartResponse.ReadOnly
            ] = proxy(UploadPart, request, body)
            def createMultipartUpload(
                request: io.github.vigoo.zioaws.s3.model.CreateMultipartUploadRequest
            ): IO[
              AwsError,
              io.github.vigoo.zioaws.s3.model.CreateMultipartUploadResponse.ReadOnly
            ] = proxy(CreateMultipartUpload, request)
            def putBucketPolicy(
                request: io.github.vigoo.zioaws.s3.model.PutBucketPolicyRequest
            ): IO[AwsError, Unit] = proxy(PutBucketPolicy, request)
            def getBucketPolicy(
                request: io.github.vigoo.zioaws.s3.model.GetBucketPolicyRequest
            ): IO[
              AwsError,
              io.github.vigoo.zioaws.s3.model.GetBucketPolicyResponse.ReadOnly
            ] = proxy(GetBucketPolicy, request)
            def putBucketIntelligentTieringConfiguration(
                request: io.github.vigoo.zioaws.s3.model.PutBucketIntelligentTieringConfigurationRequest
            ): IO[AwsError, Unit] =
              proxy(PutBucketIntelligentTieringConfiguration, request)
            def restoreObject(
                request: io.github.vigoo.zioaws.s3.model.RestoreObjectRequest
            ): IO[
              AwsError,
              io.github.vigoo.zioaws.s3.model.RestoreObjectResponse.ReadOnly
            ] = proxy(RestoreObject, request)
            def deleteBucketWebsite(
                request: io.github.vigoo.zioaws.s3.model.DeleteBucketWebsiteRequest
            ): IO[AwsError, Unit] = proxy(DeleteBucketWebsite, request)
            def putBucketLifecycleConfiguration(
                request: io.github.vigoo.zioaws.s3.model.PutBucketLifecycleConfigurationRequest
            ): IO[AwsError, Unit] =
              proxy(PutBucketLifecycleConfiguration, request)
            def listObjectVersions(
                request: io.github.vigoo.zioaws.s3.model.ListObjectVersionsRequest
            ): ZStream[
              Any,
              AwsError,
              io.github.vigoo.zioaws.s3.model.ObjectVersion.ReadOnly
            ] = rts.unsafeRun(proxy(ListObjectVersions, request))
            def putBucketLogging(
                request: io.github.vigoo.zioaws.s3.model.PutBucketLoggingRequest
            ): IO[AwsError, Unit] = proxy(PutBucketLogging, request)
            def deleteBucketPolicy(
                request: io.github.vigoo.zioaws.s3.model.DeleteBucketPolicyRequest
            ): IO[AwsError, Unit] = proxy(DeleteBucketPolicy, request)
            def putBucketAnalyticsConfiguration(
                request: io.github.vigoo.zioaws.s3.model.PutBucketAnalyticsConfigurationRequest
            ): IO[AwsError, Unit] =
              proxy(PutBucketAnalyticsConfiguration, request)
            def deleteBucketInventoryConfiguration(
                request: io.github.vigoo.zioaws.s3.model.DeleteBucketInventoryConfigurationRequest
            ): IO[AwsError, Unit] =
              proxy(DeleteBucketInventoryConfiguration, request)
            def getBucketAnalyticsConfiguration(
                request: io.github.vigoo.zioaws.s3.model.GetBucketAnalyticsConfigurationRequest
            ): IO[
              AwsError,
              io.github.vigoo.zioaws.s3.model.GetBucketAnalyticsConfigurationResponse.ReadOnly
            ] = proxy(GetBucketAnalyticsConfiguration, request)
            def putObjectAcl(
                request: io.github.vigoo.zioaws.s3.model.PutObjectAclRequest
            ): IO[
              AwsError,
              io.github.vigoo.zioaws.s3.model.PutObjectAclResponse.ReadOnly
            ] = proxy(PutObjectAcl, request)
            def listBucketAnalyticsConfigurations(
                request: io.github.vigoo.zioaws.s3.model.ListBucketAnalyticsConfigurationsRequest
            ): IO[
              AwsError,
              io.github.vigoo.zioaws.s3.model.ListBucketAnalyticsConfigurationsResponse.ReadOnly
            ] = proxy(ListBucketAnalyticsConfigurations, request)
            def deleteBucketLifecycle(
                request: io.github.vigoo.zioaws.s3.model.DeleteBucketLifecycleRequest
            ): IO[AwsError, Unit] = proxy(DeleteBucketLifecycle, request)
            def getObjectAcl(
                request: io.github.vigoo.zioaws.s3.model.GetObjectAclRequest
            ): IO[
              AwsError,
              io.github.vigoo.zioaws.s3.model.GetObjectAclResponse.ReadOnly
            ] = proxy(GetObjectAcl, request)
            def listBucketInventoryConfigurations(
                request: io.github.vigoo.zioaws.s3.model.ListBucketInventoryConfigurationsRequest
            ): IO[
              AwsError,
              io.github.vigoo.zioaws.s3.model.ListBucketInventoryConfigurationsResponse.ReadOnly
            ] = proxy(ListBucketInventoryConfigurations, request)
            def listMultipartUploads(
                request: io.github.vigoo.zioaws.s3.model.ListMultipartUploadsRequest
            ): ZStream[
              Any,
              AwsError,
              io.github.vigoo.zioaws.s3.model.MultipartUpload.ReadOnly
            ] = rts.unsafeRun(proxy(ListMultipartUploads, request))
            def getBucketLifecycleConfiguration(
                request: io.github.vigoo.zioaws.s3.model.GetBucketLifecycleConfigurationRequest
            ): IO[
              AwsError,
              io.github.vigoo.zioaws.s3.model.GetBucketLifecycleConfigurationResponse.ReadOnly
            ] = proxy(GetBucketLifecycleConfiguration, request)
            def getBucketEncryption(
                request: io.github.vigoo.zioaws.s3.model.GetBucketEncryptionRequest
            ): IO[
              AwsError,
              io.github.vigoo.zioaws.s3.model.GetBucketEncryptionResponse.ReadOnly
            ] = proxy(GetBucketEncryption, request)
            def writeGetObjectResponse(
                request: io.github.vigoo.zioaws.s3.model.WriteGetObjectResponseRequest,
                body: ZStream[Any, AwsError, Byte]
            ): IO[AwsError, Unit] = proxy(WriteGetObjectResponse, request, body)
            def getBucketCors(
                request: io.github.vigoo.zioaws.s3.model.GetBucketCorsRequest
            ): IO[
              AwsError,
              io.github.vigoo.zioaws.s3.model.GetBucketCorsResponse.ReadOnly
            ] = proxy(GetBucketCors, request)
            def getObjectRetention(
                request: io.github.vigoo.zioaws.s3.model.GetObjectRetentionRequest
            ): IO[
              AwsError,
              io.github.vigoo.zioaws.s3.model.GetObjectRetentionResponse.ReadOnly
            ] = proxy(GetObjectRetention, request)
            def getBucketLogging(
                request: io.github.vigoo.zioaws.s3.model.GetBucketLoggingRequest
            ): IO[
              AwsError,
              io.github.vigoo.zioaws.s3.model.GetBucketLoggingResponse.ReadOnly
            ] = proxy(GetBucketLogging, request)
            def listParts(
                request: io.github.vigoo.zioaws.s3.model.ListPartsRequest
            ): ZStream[
              Any,
              AwsError,
              io.github.vigoo.zioaws.s3.model.Part.ReadOnly
            ] = rts.unsafeRun(proxy(ListParts, request))
            def getObjectAttributes(
                request: io.github.vigoo.zioaws.s3.model.GetObjectAttributesRequest
            ): IO[
              AwsError,
              io.github.vigoo.zioaws.s3.model.GetObjectAttributesResponse.ReadOnly
            ] = proxy(GetObjectAttributes, request)
            def listBucketIntelligentTieringConfigurations(
                request: io.github.vigoo.zioaws.s3.model.ListBucketIntelligentTieringConfigurationsRequest
            ): IO[
              AwsError,
              io.github.vigoo.zioaws.s3.model.ListBucketIntelligentTieringConfigurationsResponse.ReadOnly
            ] = proxy(ListBucketIntelligentTieringConfigurations, request)
            def listBucketMetricsConfigurations(
                request: io.github.vigoo.zioaws.s3.model.ListBucketMetricsConfigurationsRequest
            ): IO[
              AwsError,
              io.github.vigoo.zioaws.s3.model.ListBucketMetricsConfigurationsResponse.ReadOnly
            ] = proxy(ListBucketMetricsConfigurations, request)
            def putBucketMetricsConfiguration(
                request: io.github.vigoo.zioaws.s3.model.PutBucketMetricsConfigurationRequest
            ): IO[AwsError, Unit] =
              proxy(PutBucketMetricsConfiguration, request)
            def deleteBucketAnalyticsConfiguration(
                request: io.github.vigoo.zioaws.s3.model.DeleteBucketAnalyticsConfigurationRequest
            ): IO[AwsError, Unit] =
              proxy(DeleteBucketAnalyticsConfiguration, request)
            def deleteBucketReplication(
                request: io.github.vigoo.zioaws.s3.model.DeleteBucketReplicationRequest
            ): IO[AwsError, Unit] = proxy(DeleteBucketReplication, request)
            def uploadPartCopy(
                request: io.github.vigoo.zioaws.s3.model.UploadPartCopyRequest
            ): IO[
              AwsError,
              io.github.vigoo.zioaws.s3.model.UploadPartCopyResponse.ReadOnly
            ] = proxy(UploadPartCopy, request)
            def getObjectLegalHold(
                request: io.github.vigoo.zioaws.s3.model.GetObjectLegalHoldRequest
            ): IO[
              AwsError,
              io.github.vigoo.zioaws.s3.model.GetObjectLegalHoldResponse.ReadOnly
            ] = proxy(GetObjectLegalHold, request)
            def getBucketRequestPayment(
                request: io.github.vigoo.zioaws.s3.model.GetBucketRequestPaymentRequest
            ): IO[
              AwsError,
              io.github.vigoo.zioaws.s3.model.GetBucketRequestPaymentResponse.ReadOnly
            ] = proxy(GetBucketRequestPayment, request)
            def getBucketMetricsConfiguration(
                request: io.github.vigoo.zioaws.s3.model.GetBucketMetricsConfigurationRequest
            ): IO[
              AwsError,
              io.github.vigoo.zioaws.s3.model.GetBucketMetricsConfigurationResponse.ReadOnly
            ] = proxy(GetBucketMetricsConfiguration, request)
            def copyObject(
                request: io.github.vigoo.zioaws.s3.model.CopyObjectRequest
            ): IO[
              AwsError,
              io.github.vigoo.zioaws.s3.model.CopyObjectResponse.ReadOnly
            ] = proxy(CopyObject, request)
            def putBucketWebsite(
                request: io.github.vigoo.zioaws.s3.model.PutBucketWebsiteRequest
            ): IO[AwsError, Unit] = proxy(PutBucketWebsite, request)
            def getBucketAccelerateConfiguration(
                request: io.github.vigoo.zioaws.s3.model.GetBucketAccelerateConfigurationRequest
            ): IO[
              AwsError,
              io.github.vigoo.zioaws.s3.model.GetBucketAccelerateConfigurationResponse.ReadOnly
            ] = proxy(GetBucketAccelerateConfiguration, request)
            def headBucket(
                request: io.github.vigoo.zioaws.s3.model.HeadBucketRequest
            ): IO[AwsError, Unit] = proxy(HeadBucket, request)
            def deleteObject(
                request: io.github.vigoo.zioaws.s3.model.DeleteObjectRequest
            ): IO[
              AwsError,
              io.github.vigoo.zioaws.s3.model.DeleteObjectResponse.ReadOnly
            ] = proxy(DeleteObject, request)
            def getBucketOwnershipControls(
                request: io.github.vigoo.zioaws.s3.model.GetBucketOwnershipControlsRequest
            ): IO[
              AwsError,
              io.github.vigoo.zioaws.s3.model.GetBucketOwnershipControlsResponse.ReadOnly
            ] = proxy(GetBucketOwnershipControls, request)
            def putBucketReplication(
                request: io.github.vigoo.zioaws.s3.model.PutBucketReplicationRequest
            ): IO[AwsError, Unit] = proxy(PutBucketReplication, request)
            def deleteBucket(
                request: io.github.vigoo.zioaws.s3.model.DeleteBucketRequest
            ): IO[AwsError, Unit] = proxy(DeleteBucket, request)
            def putBucketNotificationConfiguration(
                request: io.github.vigoo.zioaws.s3.model.PutBucketNotificationConfigurationRequest
            ): IO[AwsError, Unit] =
              proxy(PutBucketNotificationConfiguration, request)
            def deleteBucketMetricsConfiguration(
                request: io.github.vigoo.zioaws.s3.model.DeleteBucketMetricsConfigurationRequest
            ): IO[AwsError, Unit] =
              proxy(DeleteBucketMetricsConfiguration, request)
            def createBucket(
                request: io.github.vigoo.zioaws.s3.model.CreateBucketRequest
            ): IO[
              AwsError,
              io.github.vigoo.zioaws.s3.model.CreateBucketResponse.ReadOnly
            ] = proxy(CreateBucket, request)
            def listObjects(
                request: io.github.vigoo.zioaws.s3.model.ListObjectsRequest
            ): IO[
              AwsError,
              io.github.vigoo.zioaws.s3.model.ListObjectsResponse.ReadOnly
            ] = proxy(ListObjects, request)
            def listBuckets(): IO[
              AwsError,
              io.github.vigoo.zioaws.s3.model.ListBucketsResponse.ReadOnly
            ] = proxy(ListBuckets)
            def getBucketTagging(
                request: io.github.vigoo.zioaws.s3.model.GetBucketTaggingRequest
            ): IO[
              AwsError,
              io.github.vigoo.zioaws.s3.model.GetBucketTaggingResponse.ReadOnly
            ] = proxy(GetBucketTagging, request)
            def putObject(
                request: io.github.vigoo.zioaws.s3.model.PutObjectRequest,
                body: ZStream[Any, AwsError, Byte]
            ): IO[
              AwsError,
              io.github.vigoo.zioaws.s3.model.PutObjectResponse.ReadOnly
            ] = proxy(PutObject, request, body)
            def putBucketTagging(
                request: io.github.vigoo.zioaws.s3.model.PutBucketTaggingRequest
            ): IO[AwsError, Unit] = proxy(PutBucketTagging, request)
            def deleteBucketTagging(
                request: io.github.vigoo.zioaws.s3.model.DeleteBucketTaggingRequest
            ): IO[AwsError, Unit] = proxy(DeleteBucketTagging, request)
            def putBucketEncryption(
                request: io.github.vigoo.zioaws.s3.model.PutBucketEncryptionRequest
            ): IO[AwsError, Unit] = proxy(PutBucketEncryption, request)
            def putBucketRequestPayment(
                request: io.github.vigoo.zioaws.s3.model.PutBucketRequestPaymentRequest
            ): IO[AwsError, Unit] = proxy(PutBucketRequestPayment, request)
            def getObject(
                request: io.github.vigoo.zioaws.s3.model.GetObjectRequest
            ): IO[AwsError, StreamingOutputResult[
              Any,
              io.github.vigoo.zioaws.s3.model.GetObjectResponse.ReadOnly,
              Byte
            ]] = proxy(GetObject, request)
            def putObjectTagging(
                request: io.github.vigoo.zioaws.s3.model.PutObjectTaggingRequest
            ): IO[
              AwsError,
              io.github.vigoo.zioaws.s3.model.PutObjectTaggingResponse.ReadOnly
            ] = proxy(PutObjectTagging, request)
            def deleteBucketCors(
                request: io.github.vigoo.zioaws.s3.model.DeleteBucketCorsRequest
            ): IO[AwsError, Unit] = proxy(DeleteBucketCors, request)
            def putPublicAccessBlock(
                request: io.github.vigoo.zioaws.s3.model.PutPublicAccessBlockRequest
            ): IO[AwsError, Unit] = proxy(PutPublicAccessBlock, request)
            def getObjectTorrent(
                request: io.github.vigoo.zioaws.s3.model.GetObjectTorrentRequest
            ): IO[AwsError, StreamingOutputResult[
              Any,
              io.github.vigoo.zioaws.s3.model.GetObjectTorrentResponse.ReadOnly,
              Byte
            ]] = proxy(GetObjectTorrent, request)
            def getBucketInventoryConfiguration(
                request: io.github.vigoo.zioaws.s3.model.GetBucketInventoryConfigurationRequest
            ): IO[
              AwsError,
              io.github.vigoo.zioaws.s3.model.GetBucketInventoryConfigurationResponse.ReadOnly
            ] = proxy(GetBucketInventoryConfiguration, request)
            def getBucketVersioning(
                request: io.github.vigoo.zioaws.s3.model.GetBucketVersioningRequest
            ): IO[
              AwsError,
              io.github.vigoo.zioaws.s3.model.GetBucketVersioningResponse.ReadOnly
            ] = proxy(GetBucketVersioning, request)
            def putBucketOwnershipControls(
                request: io.github.vigoo.zioaws.s3.model.PutBucketOwnershipControlsRequest
            ): IO[AwsError, Unit] = proxy(PutBucketOwnershipControls, request)
            def headObject(
                request: io.github.vigoo.zioaws.s3.model.HeadObjectRequest
            ): IO[
              AwsError,
              io.github.vigoo.zioaws.s3.model.HeadObjectResponse.ReadOnly
            ] = proxy(HeadObject, request)
            def selectObjectContent(
                request: io.github.vigoo.zioaws.s3.model.SelectObjectContentRequest
            ): ZStream[
              Any,
              AwsError,
              io.github.vigoo.zioaws.s3.model.RecordsEvent.ReadOnly
            ] = rts.unsafeRun(proxy(SelectObjectContent, request))
            def getBucketWebsite(
                request: io.github.vigoo.zioaws.s3.model.GetBucketWebsiteRequest
            ): IO[
              AwsError,
              io.github.vigoo.zioaws.s3.model.GetBucketWebsiteResponse.ReadOnly
            ] = proxy(GetBucketWebsite, request)
            def deleteBucketIntelligentTieringConfiguration(
                request: io.github.vigoo.zioaws.s3.model.DeleteBucketIntelligentTieringConfigurationRequest
            ): IO[AwsError, Unit] =
              proxy(DeleteBucketIntelligentTieringConfiguration, request)
            def putBucketInventoryConfiguration(
                request: io.github.vigoo.zioaws.s3.model.PutBucketInventoryConfigurationRequest
            ): IO[AwsError, Unit] =
              proxy(PutBucketInventoryConfiguration, request)
            def getBucketIntelligentTieringConfiguration(
                request: io.github.vigoo.zioaws.s3.model.GetBucketIntelligentTieringConfigurationRequest
            ): IO[
              AwsError,
              io.github.vigoo.zioaws.s3.model.GetBucketIntelligentTieringConfigurationResponse.ReadOnly
            ] = proxy(GetBucketIntelligentTieringConfiguration, request)
            def getBucketAcl(
                request: io.github.vigoo.zioaws.s3.model.GetBucketAclRequest
            ): IO[
              AwsError,
              io.github.vigoo.zioaws.s3.model.GetBucketAclResponse.ReadOnly
            ] = proxy(GetBucketAcl, request)
            def listObjectsV2(
                request: io.github.vigoo.zioaws.s3.model.ListObjectsV2Request
            ): ZStream[
              Any,
              AwsError,
              io.github.vigoo.zioaws.s3.model.S3Object.ReadOnly
            ] = rts.unsafeRun(proxy(ListObjectsV2, request))
            def putBucketVersioning(
                request: io.github.vigoo.zioaws.s3.model.PutBucketVersioningRequest
            ): IO[AwsError, Unit] = proxy(PutBucketVersioning, request)
            def putBucketAcl(
                request: io.github.vigoo.zioaws.s3.model.PutBucketAclRequest
            ): IO[AwsError, Unit] = proxy(PutBucketAcl, request)
            def getBucketReplication(
                request: io.github.vigoo.zioaws.s3.model.GetBucketReplicationRequest
            ): IO[
              AwsError,
              io.github.vigoo.zioaws.s3.model.GetBucketReplicationResponse.ReadOnly
            ] = proxy(GetBucketReplication, request)
            def getPublicAccessBlock(
                request: io.github.vigoo.zioaws.s3.model.GetPublicAccessBlockRequest
            ): IO[
              AwsError,
              io.github.vigoo.zioaws.s3.model.GetPublicAccessBlockResponse.ReadOnly
            ] = proxy(GetPublicAccessBlock, request)
            def putObjectLegalHold(
                request: io.github.vigoo.zioaws.s3.model.PutObjectLegalHoldRequest
            ): IO[
              AwsError,
              io.github.vigoo.zioaws.s3.model.PutObjectLegalHoldResponse.ReadOnly
            ] = proxy(PutObjectLegalHold, request)
            def getObjectLockConfiguration(
                request: io.github.vigoo.zioaws.s3.model.GetObjectLockConfigurationRequest
            ): IO[
              AwsError,
              io.github.vigoo.zioaws.s3.model.GetObjectLockConfigurationResponse.ReadOnly
            ] = proxy(GetObjectLockConfiguration, request)
            def getBucketLocation(
                request: io.github.vigoo.zioaws.s3.model.GetBucketLocationRequest
            ): IO[
              AwsError,
              io.github.vigoo.zioaws.s3.model.GetBucketLocationResponse.ReadOnly
            ] = proxy(GetBucketLocation, request)
            def deleteObjects(
                request: io.github.vigoo.zioaws.s3.model.DeleteObjectsRequest
            ): IO[AwsError, ReadOnly] = proxy(DeleteObjects, request)
            def abortMultipartUpload(
                request: io.github.vigoo.zioaws.s3.model.AbortMultipartUploadRequest
            ): IO[
              AwsError,
              io.github.vigoo.zioaws.s3.model.AbortMultipartUploadResponse.ReadOnly
            ] = proxy(AbortMultipartUpload, request)
            def getBucketPolicyStatus(
                request: io.github.vigoo.zioaws.s3.model.GetBucketPolicyStatusRequest
            ): IO[
              AwsError,
              io.github.vigoo.zioaws.s3.model.GetBucketPolicyStatusResponse.ReadOnly
            ] = proxy(GetBucketPolicyStatus, request)
            def deleteBucketOwnershipControls(
                request: io.github.vigoo.zioaws.s3.model.DeleteBucketOwnershipControlsRequest
            ): IO[AwsError, Unit] =
              proxy(DeleteBucketOwnershipControls, request)
            def putObjectRetention(
                request: io.github.vigoo.zioaws.s3.model.PutObjectRetentionRequest
            ): IO[
              AwsError,
              io.github.vigoo.zioaws.s3.model.PutObjectRetentionResponse.ReadOnly
            ] = proxy(PutObjectRetention, request)
            def putBucketCors(
                request: io.github.vigoo.zioaws.s3.model.PutBucketCorsRequest
            ): IO[AwsError, Unit] = proxy(PutBucketCors, request)
            def deleteObjectTagging(
                request: io.github.vigoo.zioaws.s3.model.DeleteObjectTaggingRequest
            ): IO[
              AwsError,
              io.github.vigoo.zioaws.s3.model.DeleteObjectTaggingResponse.ReadOnly
            ] = proxy(DeleteObjectTagging, request)
            def deletePublicAccessBlock(
                request: io.github.vigoo.zioaws.s3.model.DeletePublicAccessBlockRequest
            ): IO[AwsError, Unit] = proxy(DeletePublicAccessBlock, request)
            def deleteBucketEncryption(
                request: io.github.vigoo.zioaws.s3.model.DeleteBucketEncryptionRequest
            ): IO[AwsError, Unit] = proxy(DeleteBucketEncryption, request)
            def completeMultipartUpload(
                request: io.github.vigoo.zioaws.s3.model.CompleteMultipartUploadRequest
            ): IO[
              AwsError,
              io.github.vigoo.zioaws.s3.model.CompleteMultipartUploadResponse.ReadOnly
            ] = proxy(CompleteMultipartUpload, request)
            def getObjectTagging(
                request: io.github.vigoo.zioaws.s3.model.GetObjectTaggingRequest
            ): IO[
              AwsError,
              io.github.vigoo.zioaws.s3.model.GetObjectTaggingResponse.ReadOnly
            ] = proxy(GetObjectTagging, request)
            def putObjectLockConfiguration(
                request: io.github.vigoo.zioaws.s3.model.PutObjectLockConfigurationRequest
            ): IO[
              AwsError,
              io.github.vigoo.zioaws.s3.model.PutObjectLockConfigurationResponse.ReadOnly
            ] = proxy(PutObjectLockConfiguration, request)
            def putBucketAccelerateConfiguration(
                request: io.github.vigoo.zioaws.s3.model.PutBucketAccelerateConfigurationRequest
            ): IO[AwsError, Unit] =
              proxy(PutBucketAccelerateConfiguration, request)
            def getBucketNotificationConfiguration(
                request: io.github.vigoo.zioaws.s3.model.GetBucketNotificationConfigurationRequest
            ): IO[
              AwsError,
              io.github.vigoo.zioaws.s3.model.GetBucketNotificationConfigurationResponse.ReadOnly
            ] = proxy(GetBucketNotificationConfiguration, request)
          }
        }
      }
    }
  }
  val live: ZLayer[AwsConfig, java.lang.Throwable, S3] = customized(identity)
  def customized(
      customization: S3AsyncClientBuilder => S3AsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, S3] = managed(customization).toLayer
  def managed(
      customization: S3AsyncClientBuilder => S3AsyncClientBuilder
  ): ZManaged[AwsConfig, java.lang.Throwable, S3.Service] = for (
    awsConfig <- ZManaged.service[AwsConfig.Service];
    executor <- ZIO.executor.toManaged_;
    builder = S3AsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig
      .configure[S3AsyncClient, S3AsyncClientBuilder](builder)
      .toManaged_;
    b1 <- awsConfig
      .configureHttpClient[S3AsyncClient, S3AsyncClientBuilder](
        b0,
        io.github.vigoo.zioaws.core.httpclient
          .ServiceHttpCapabilities(supportsHttp2 = false)
      )
      .toManaged_; client <- zio.ZIO(customization(b1).build()).toManaged_
  ) yield new S3Impl(client, AwsCallAspect.identity, ().asInstanceOf[Any])
  private class S3Impl[R](
      override val api: S3AsyncClient,
      override val aspect: AwsCallAspect[R],
      r: R
  ) extends S3.Service
      with AwsServiceBase[R, S3Impl] {
    override val serviceName: String = "S3"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: R1
    ): S3Impl[R1] = new S3Impl(api, newAspect, r)
    def uploadPart(
        request: io.github.vigoo.zioaws.s3.model.UploadPartRequest,
        body: ZStream[Any, AwsError, Byte]
    ): IO[
      AwsError,
      io.github.vigoo.zioaws.s3.model.UploadPartResponse.ReadOnly
    ] = asyncRequestInputStream[UploadPartRequest, UploadPartResponse](
      "uploadPart",
      api.uploadPart
    )(request.buildAwsValue(), body)
      .map(io.github.vigoo.zioaws.s3.model.UploadPartResponse.wrap)
      .provide(r)
    def createMultipartUpload(
        request: io.github.vigoo.zioaws.s3.model.CreateMultipartUploadRequest
    ): IO[
      AwsError,
      io.github.vigoo.zioaws.s3.model.CreateMultipartUploadResponse.ReadOnly
    ] = asyncRequestResponse[
      CreateMultipartUploadRequest,
      CreateMultipartUploadResponse
    ]("createMultipartUpload", api.createMultipartUpload)(
      request.buildAwsValue()
    ).map(io.github.vigoo.zioaws.s3.model.CreateMultipartUploadResponse.wrap)
      .provide(r)
    def putBucketPolicy(
        request: io.github.vigoo.zioaws.s3.model.PutBucketPolicyRequest
    ): IO[AwsError, Unit] =
      asyncRequestResponse[PutBucketPolicyRequest, PutBucketPolicyResponse](
        "putBucketPolicy",
        api.putBucketPolicy
      )(request.buildAwsValue()).unit.provide(r)
    def getBucketPolicy(
        request: io.github.vigoo.zioaws.s3.model.GetBucketPolicyRequest
    ): IO[
      AwsError,
      io.github.vigoo.zioaws.s3.model.GetBucketPolicyResponse.ReadOnly
    ] = asyncRequestResponse[GetBucketPolicyRequest, GetBucketPolicyResponse](
      "getBucketPolicy",
      api.getBucketPolicy
    )(request.buildAwsValue())
      .map(io.github.vigoo.zioaws.s3.model.GetBucketPolicyResponse.wrap)
      .provide(r)
    def putBucketIntelligentTieringConfiguration(
        request: io.github.vigoo.zioaws.s3.model.PutBucketIntelligentTieringConfigurationRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      PutBucketIntelligentTieringConfigurationRequest,
      PutBucketIntelligentTieringConfigurationResponse
    ](
      "putBucketIntelligentTieringConfiguration",
      api.putBucketIntelligentTieringConfiguration
    )(request.buildAwsValue()).unit.provide(r)
    def restoreObject(
        request: io.github.vigoo.zioaws.s3.model.RestoreObjectRequest
    ): IO[
      AwsError,
      io.github.vigoo.zioaws.s3.model.RestoreObjectResponse.ReadOnly
    ] = asyncRequestResponse[RestoreObjectRequest, RestoreObjectResponse](
      "restoreObject",
      api.restoreObject
    )(request.buildAwsValue())
      .map(io.github.vigoo.zioaws.s3.model.RestoreObjectResponse.wrap)
      .provide(r)
    def deleteBucketWebsite(
        request: io.github.vigoo.zioaws.s3.model.DeleteBucketWebsiteRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      DeleteBucketWebsiteRequest,
      DeleteBucketWebsiteResponse
    ]("deleteBucketWebsite", api.deleteBucketWebsite)(
      request.buildAwsValue()
    ).unit.provide(r)
    def putBucketLifecycleConfiguration(
        request: io.github.vigoo.zioaws.s3.model.PutBucketLifecycleConfigurationRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      PutBucketLifecycleConfigurationRequest,
      PutBucketLifecycleConfigurationResponse
    ]("putBucketLifecycleConfiguration", api.putBucketLifecycleConfiguration)(
      request.buildAwsValue()
    ).unit.provide(r)
    def listObjectVersions(
        request: io.github.vigoo.zioaws.s3.model.ListObjectVersionsRequest
    ): ZStream[
      Any,
      AwsError,
      io.github.vigoo.zioaws.s3.model.ObjectVersion.ReadOnly
    ] = asyncJavaPaginatedRequest[
      ListObjectVersionsRequest,
      ObjectVersion,
      ListObjectVersionsPublisher
    ]("listObjectVersions", api.listObjectVersionsPaginator, _.versions())(
      request.buildAwsValue()
    ).map(item => io.github.vigoo.zioaws.s3.model.ObjectVersion.wrap(item))
      .provide(r)
    def putBucketLogging(
        request: io.github.vigoo.zioaws.s3.model.PutBucketLoggingRequest
    ): IO[AwsError, Unit] =
      asyncRequestResponse[PutBucketLoggingRequest, PutBucketLoggingResponse](
        "putBucketLogging",
        api.putBucketLogging
      )(request.buildAwsValue()).unit.provide(r)
    def deleteBucketPolicy(
        request: io.github.vigoo.zioaws.s3.model.DeleteBucketPolicyRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      DeleteBucketPolicyRequest,
      DeleteBucketPolicyResponse
    ]("deleteBucketPolicy", api.deleteBucketPolicy)(
      request.buildAwsValue()
    ).unit.provide(r)
    def putBucketAnalyticsConfiguration(
        request: io.github.vigoo.zioaws.s3.model.PutBucketAnalyticsConfigurationRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      PutBucketAnalyticsConfigurationRequest,
      PutBucketAnalyticsConfigurationResponse
    ]("putBucketAnalyticsConfiguration", api.putBucketAnalyticsConfiguration)(
      request.buildAwsValue()
    ).unit.provide(r)
    def deleteBucketInventoryConfiguration(
        request: io.github.vigoo.zioaws.s3.model.DeleteBucketInventoryConfigurationRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      DeleteBucketInventoryConfigurationRequest,
      DeleteBucketInventoryConfigurationResponse
    ](
      "deleteBucketInventoryConfiguration",
      api.deleteBucketInventoryConfiguration
    )(request.buildAwsValue()).unit.provide(r)
    def getBucketAnalyticsConfiguration(
        request: io.github.vigoo.zioaws.s3.model.GetBucketAnalyticsConfigurationRequest
    ): IO[
      AwsError,
      io.github.vigoo.zioaws.s3.model.GetBucketAnalyticsConfigurationResponse.ReadOnly
    ] = asyncRequestResponse[
      GetBucketAnalyticsConfigurationRequest,
      GetBucketAnalyticsConfigurationResponse
    ]("getBucketAnalyticsConfiguration", api.getBucketAnalyticsConfiguration)(
      request.buildAwsValue()
    ).map(
      io.github.vigoo.zioaws.s3.model.GetBucketAnalyticsConfigurationResponse.wrap
    ).provide(r)
    def putObjectAcl(
        request: io.github.vigoo.zioaws.s3.model.PutObjectAclRequest
    ): IO[
      AwsError,
      io.github.vigoo.zioaws.s3.model.PutObjectAclResponse.ReadOnly
    ] = asyncRequestResponse[PutObjectAclRequest, PutObjectAclResponse](
      "putObjectAcl",
      api.putObjectAcl
    )(request.buildAwsValue())
      .map(io.github.vigoo.zioaws.s3.model.PutObjectAclResponse.wrap)
      .provide(r)
    def listBucketAnalyticsConfigurations(
        request: io.github.vigoo.zioaws.s3.model.ListBucketAnalyticsConfigurationsRequest
    ): IO[
      AwsError,
      io.github.vigoo.zioaws.s3.model.ListBucketAnalyticsConfigurationsResponse.ReadOnly
    ] = asyncRequestResponse[
      ListBucketAnalyticsConfigurationsRequest,
      ListBucketAnalyticsConfigurationsResponse
    ]("listBucketAnalyticsConfigurations", api.listBucketAnalyticsConfigurations)(
      request.buildAwsValue()
    ).map(
      io.github.vigoo.zioaws.s3.model.ListBucketAnalyticsConfigurationsResponse.wrap
    ).provide(r)
    def deleteBucketLifecycle(
        request: io.github.vigoo.zioaws.s3.model.DeleteBucketLifecycleRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      DeleteBucketLifecycleRequest,
      DeleteBucketLifecycleResponse
    ]("deleteBucketLifecycle", api.deleteBucketLifecycle)(
      request.buildAwsValue()
    ).unit.provide(r)
    def getObjectAcl(
        request: io.github.vigoo.zioaws.s3.model.GetObjectAclRequest
    ): IO[
      AwsError,
      io.github.vigoo.zioaws.s3.model.GetObjectAclResponse.ReadOnly
    ] = asyncRequestResponse[GetObjectAclRequest, GetObjectAclResponse](
      "getObjectAcl",
      api.getObjectAcl
    )(request.buildAwsValue())
      .map(io.github.vigoo.zioaws.s3.model.GetObjectAclResponse.wrap)
      .provide(r)
    def listBucketInventoryConfigurations(
        request: io.github.vigoo.zioaws.s3.model.ListBucketInventoryConfigurationsRequest
    ): IO[
      AwsError,
      io.github.vigoo.zioaws.s3.model.ListBucketInventoryConfigurationsResponse.ReadOnly
    ] = asyncRequestResponse[
      ListBucketInventoryConfigurationsRequest,
      ListBucketInventoryConfigurationsResponse
    ]("listBucketInventoryConfigurations", api.listBucketInventoryConfigurations)(
      request.buildAwsValue()
    ).map(
      io.github.vigoo.zioaws.s3.model.ListBucketInventoryConfigurationsResponse.wrap
    ).provide(r)
    def listMultipartUploads(
        request: io.github.vigoo.zioaws.s3.model.ListMultipartUploadsRequest
    ): ZStream[
      Any,
      AwsError,
      io.github.vigoo.zioaws.s3.model.MultipartUpload.ReadOnly
    ] = asyncJavaPaginatedRequest[
      ListMultipartUploadsRequest,
      MultipartUpload,
      ListMultipartUploadsPublisher
    ]("listMultipartUploads", api.listMultipartUploadsPaginator, _.uploads())(
      request.buildAwsValue()
    ).map(item => io.github.vigoo.zioaws.s3.model.MultipartUpload.wrap(item))
      .provide(r)
    def getBucketLifecycleConfiguration(
        request: io.github.vigoo.zioaws.s3.model.GetBucketLifecycleConfigurationRequest
    ): IO[
      AwsError,
      io.github.vigoo.zioaws.s3.model.GetBucketLifecycleConfigurationResponse.ReadOnly
    ] = asyncRequestResponse[
      GetBucketLifecycleConfigurationRequest,
      GetBucketLifecycleConfigurationResponse
    ]("getBucketLifecycleConfiguration", api.getBucketLifecycleConfiguration)(
      request.buildAwsValue()
    ).map(
      io.github.vigoo.zioaws.s3.model.GetBucketLifecycleConfigurationResponse.wrap
    ).provide(r)
    def getBucketEncryption(
        request: io.github.vigoo.zioaws.s3.model.GetBucketEncryptionRequest
    ): IO[
      AwsError,
      io.github.vigoo.zioaws.s3.model.GetBucketEncryptionResponse.ReadOnly
    ] = asyncRequestResponse[
      GetBucketEncryptionRequest,
      GetBucketEncryptionResponse
    ]("getBucketEncryption", api.getBucketEncryption)(request.buildAwsValue())
      .map(io.github.vigoo.zioaws.s3.model.GetBucketEncryptionResponse.wrap)
      .provide(r)
    def writeGetObjectResponse(
        request: io.github.vigoo.zioaws.s3.model.WriteGetObjectResponseRequest,
        body: ZStream[Any, AwsError, Byte]
    ): IO[AwsError, Unit] = asyncRequestInputStream[
      WriteGetObjectResponseRequest,
      WriteGetObjectResponseResponse
    ]("writeGetObjectResponse", api.writeGetObjectResponse)(
      request.buildAwsValue(),
      body
    ).unit.provide(r)
    def getBucketCors(
        request: io.github.vigoo.zioaws.s3.model.GetBucketCorsRequest
    ): IO[
      AwsError,
      io.github.vigoo.zioaws.s3.model.GetBucketCorsResponse.ReadOnly
    ] = asyncRequestResponse[GetBucketCorsRequest, GetBucketCorsResponse](
      "getBucketCors",
      api.getBucketCors
    )(request.buildAwsValue())
      .map(io.github.vigoo.zioaws.s3.model.GetBucketCorsResponse.wrap)
      .provide(r)
    def getObjectRetention(
        request: io.github.vigoo.zioaws.s3.model.GetObjectRetentionRequest
    ): IO[
      AwsError,
      io.github.vigoo.zioaws.s3.model.GetObjectRetentionResponse.ReadOnly
    ] = asyncRequestResponse[
      GetObjectRetentionRequest,
      GetObjectRetentionResponse
    ]("getObjectRetention", api.getObjectRetention)(request.buildAwsValue())
      .map(io.github.vigoo.zioaws.s3.model.GetObjectRetentionResponse.wrap)
      .provide(r)
    def getBucketLogging(
        request: io.github.vigoo.zioaws.s3.model.GetBucketLoggingRequest
    ): IO[
      AwsError,
      io.github.vigoo.zioaws.s3.model.GetBucketLoggingResponse.ReadOnly
    ] = asyncRequestResponse[GetBucketLoggingRequest, GetBucketLoggingResponse](
      "getBucketLogging",
      api.getBucketLogging
    )(request.buildAwsValue())
      .map(io.github.vigoo.zioaws.s3.model.GetBucketLoggingResponse.wrap)
      .provide(r)
    def listParts(
        request: io.github.vigoo.zioaws.s3.model.ListPartsRequest
    ): ZStream[Any, AwsError, io.github.vigoo.zioaws.s3.model.Part.ReadOnly] =
      asyncJavaPaginatedRequest[ListPartsRequest, Part, ListPartsPublisher](
        "listParts",
        api.listPartsPaginator,
        _.parts()
      )(request.buildAwsValue())
        .map(item => io.github.vigoo.zioaws.s3.model.Part.wrap(item))
        .provide(r)
    def getObjectAttributes(
        request: io.github.vigoo.zioaws.s3.model.GetObjectAttributesRequest
    ): IO[
      AwsError,
      io.github.vigoo.zioaws.s3.model.GetObjectAttributesResponse.ReadOnly
    ] = asyncRequestResponse[
      GetObjectAttributesRequest,
      GetObjectAttributesResponse
    ]("getObjectAttributes", api.getObjectAttributes)(request.buildAwsValue())
      .map(io.github.vigoo.zioaws.s3.model.GetObjectAttributesResponse.wrap)
      .provide(r)
    def listBucketIntelligentTieringConfigurations(
        request: io.github.vigoo.zioaws.s3.model.ListBucketIntelligentTieringConfigurationsRequest
    ): IO[
      AwsError,
      io.github.vigoo.zioaws.s3.model.ListBucketIntelligentTieringConfigurationsResponse.ReadOnly
    ] = asyncRequestResponse[
      ListBucketIntelligentTieringConfigurationsRequest,
      ListBucketIntelligentTieringConfigurationsResponse
    ](
      "listBucketIntelligentTieringConfigurations",
      api.listBucketIntelligentTieringConfigurations
    )(request.buildAwsValue())
      .map(
        io.github.vigoo.zioaws.s3.model.ListBucketIntelligentTieringConfigurationsResponse.wrap
      )
      .provide(r)
    def listBucketMetricsConfigurations(
        request: io.github.vigoo.zioaws.s3.model.ListBucketMetricsConfigurationsRequest
    ): IO[
      AwsError,
      io.github.vigoo.zioaws.s3.model.ListBucketMetricsConfigurationsResponse.ReadOnly
    ] = asyncRequestResponse[
      ListBucketMetricsConfigurationsRequest,
      ListBucketMetricsConfigurationsResponse
    ]("listBucketMetricsConfigurations", api.listBucketMetricsConfigurations)(
      request.buildAwsValue()
    ).map(
      io.github.vigoo.zioaws.s3.model.ListBucketMetricsConfigurationsResponse.wrap
    ).provide(r)
    def putBucketMetricsConfiguration(
        request: io.github.vigoo.zioaws.s3.model.PutBucketMetricsConfigurationRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      PutBucketMetricsConfigurationRequest,
      PutBucketMetricsConfigurationResponse
    ]("putBucketMetricsConfiguration", api.putBucketMetricsConfiguration)(
      request.buildAwsValue()
    ).unit.provide(r)
    def deleteBucketAnalyticsConfiguration(
        request: io.github.vigoo.zioaws.s3.model.DeleteBucketAnalyticsConfigurationRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      DeleteBucketAnalyticsConfigurationRequest,
      DeleteBucketAnalyticsConfigurationResponse
    ](
      "deleteBucketAnalyticsConfiguration",
      api.deleteBucketAnalyticsConfiguration
    )(request.buildAwsValue()).unit.provide(r)
    def deleteBucketReplication(
        request: io.github.vigoo.zioaws.s3.model.DeleteBucketReplicationRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      DeleteBucketReplicationRequest,
      DeleteBucketReplicationResponse
    ]("deleteBucketReplication", api.deleteBucketReplication)(
      request.buildAwsValue()
    ).unit.provide(r)
    def uploadPartCopy(
        request: io.github.vigoo.zioaws.s3.model.UploadPartCopyRequest
    ): IO[
      AwsError,
      io.github.vigoo.zioaws.s3.model.UploadPartCopyResponse.ReadOnly
    ] = asyncRequestResponse[UploadPartCopyRequest, UploadPartCopyResponse](
      "uploadPartCopy",
      api.uploadPartCopy
    )(request.buildAwsValue())
      .map(io.github.vigoo.zioaws.s3.model.UploadPartCopyResponse.wrap)
      .provide(r)
    def getObjectLegalHold(
        request: io.github.vigoo.zioaws.s3.model.GetObjectLegalHoldRequest
    ): IO[
      AwsError,
      io.github.vigoo.zioaws.s3.model.GetObjectLegalHoldResponse.ReadOnly
    ] = asyncRequestResponse[
      GetObjectLegalHoldRequest,
      GetObjectLegalHoldResponse
    ]("getObjectLegalHold", api.getObjectLegalHold)(request.buildAwsValue())
      .map(io.github.vigoo.zioaws.s3.model.GetObjectLegalHoldResponse.wrap)
      .provide(r)
    def getBucketRequestPayment(
        request: io.github.vigoo.zioaws.s3.model.GetBucketRequestPaymentRequest
    ): IO[
      AwsError,
      io.github.vigoo.zioaws.s3.model.GetBucketRequestPaymentResponse.ReadOnly
    ] = asyncRequestResponse[
      GetBucketRequestPaymentRequest,
      GetBucketRequestPaymentResponse
    ]("getBucketRequestPayment", api.getBucketRequestPayment)(
      request.buildAwsValue()
    ).map(io.github.vigoo.zioaws.s3.model.GetBucketRequestPaymentResponse.wrap)
      .provide(r)
    def getBucketMetricsConfiguration(
        request: io.github.vigoo.zioaws.s3.model.GetBucketMetricsConfigurationRequest
    ): IO[
      AwsError,
      io.github.vigoo.zioaws.s3.model.GetBucketMetricsConfigurationResponse.ReadOnly
    ] = asyncRequestResponse[
      GetBucketMetricsConfigurationRequest,
      GetBucketMetricsConfigurationResponse
    ]("getBucketMetricsConfiguration", api.getBucketMetricsConfiguration)(
      request.buildAwsValue()
    ).map(
      io.github.vigoo.zioaws.s3.model.GetBucketMetricsConfigurationResponse.wrap
    ).provide(r)
    def copyObject(
        request: io.github.vigoo.zioaws.s3.model.CopyObjectRequest
    ): IO[
      AwsError,
      io.github.vigoo.zioaws.s3.model.CopyObjectResponse.ReadOnly
    ] = asyncRequestResponse[CopyObjectRequest, CopyObjectResponse](
      "copyObject",
      api.copyObject
    )(request.buildAwsValue())
      .map(io.github.vigoo.zioaws.s3.model.CopyObjectResponse.wrap)
      .provide(r)
    def putBucketWebsite(
        request: io.github.vigoo.zioaws.s3.model.PutBucketWebsiteRequest
    ): IO[AwsError, Unit] =
      asyncRequestResponse[PutBucketWebsiteRequest, PutBucketWebsiteResponse](
        "putBucketWebsite",
        api.putBucketWebsite
      )(request.buildAwsValue()).unit.provide(r)
    def getBucketAccelerateConfiguration(
        request: io.github.vigoo.zioaws.s3.model.GetBucketAccelerateConfigurationRequest
    ): IO[
      AwsError,
      io.github.vigoo.zioaws.s3.model.GetBucketAccelerateConfigurationResponse.ReadOnly
    ] = asyncRequestResponse[
      GetBucketAccelerateConfigurationRequest,
      GetBucketAccelerateConfigurationResponse
    ]("getBucketAccelerateConfiguration", api.getBucketAccelerateConfiguration)(
      request.buildAwsValue()
    ).map(
      io.github.vigoo.zioaws.s3.model.GetBucketAccelerateConfigurationResponse.wrap
    ).provide(r)
    def headBucket(
        request: io.github.vigoo.zioaws.s3.model.HeadBucketRequest
    ): IO[AwsError, Unit] =
      asyncRequestResponse[HeadBucketRequest, HeadBucketResponse](
        "headBucket",
        api.headBucket
      )(request.buildAwsValue()).unit.provide(r)
    def deleteObject(
        request: io.github.vigoo.zioaws.s3.model.DeleteObjectRequest
    ): IO[
      AwsError,
      io.github.vigoo.zioaws.s3.model.DeleteObjectResponse.ReadOnly
    ] = asyncRequestResponse[DeleteObjectRequest, DeleteObjectResponse](
      "deleteObject",
      api.deleteObject
    )(request.buildAwsValue())
      .map(io.github.vigoo.zioaws.s3.model.DeleteObjectResponse.wrap)
      .provide(r)
    def getBucketOwnershipControls(
        request: io.github.vigoo.zioaws.s3.model.GetBucketOwnershipControlsRequest
    ): IO[
      AwsError,
      io.github.vigoo.zioaws.s3.model.GetBucketOwnershipControlsResponse.ReadOnly
    ] = asyncRequestResponse[
      GetBucketOwnershipControlsRequest,
      GetBucketOwnershipControlsResponse
    ]("getBucketOwnershipControls", api.getBucketOwnershipControls)(
      request.buildAwsValue()
    ).map(
      io.github.vigoo.zioaws.s3.model.GetBucketOwnershipControlsResponse.wrap
    ).provide(r)
    def putBucketReplication(
        request: io.github.vigoo.zioaws.s3.model.PutBucketReplicationRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      PutBucketReplicationRequest,
      PutBucketReplicationResponse
    ]("putBucketReplication", api.putBucketReplication)(
      request.buildAwsValue()
    ).unit.provide(r)
    def deleteBucket(
        request: io.github.vigoo.zioaws.s3.model.DeleteBucketRequest
    ): IO[AwsError, Unit] =
      asyncRequestResponse[DeleteBucketRequest, DeleteBucketResponse](
        "deleteBucket",
        api.deleteBucket
      )(request.buildAwsValue()).unit.provide(r)
    def putBucketNotificationConfiguration(
        request: io.github.vigoo.zioaws.s3.model.PutBucketNotificationConfigurationRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      PutBucketNotificationConfigurationRequest,
      PutBucketNotificationConfigurationResponse
    ](
      "putBucketNotificationConfiguration",
      api.putBucketNotificationConfiguration
    )(request.buildAwsValue()).unit.provide(r)
    def deleteBucketMetricsConfiguration(
        request: io.github.vigoo.zioaws.s3.model.DeleteBucketMetricsConfigurationRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      DeleteBucketMetricsConfigurationRequest,
      DeleteBucketMetricsConfigurationResponse
    ]("deleteBucketMetricsConfiguration", api.deleteBucketMetricsConfiguration)(
      request.buildAwsValue()
    ).unit.provide(r)
    def createBucket(
        request: io.github.vigoo.zioaws.s3.model.CreateBucketRequest
    ): IO[
      AwsError,
      io.github.vigoo.zioaws.s3.model.CreateBucketResponse.ReadOnly
    ] = asyncRequestResponse[CreateBucketRequest, CreateBucketResponse](
      "createBucket",
      api.createBucket
    )(request.buildAwsValue())
      .map(io.github.vigoo.zioaws.s3.model.CreateBucketResponse.wrap)
      .provide(r)
    def listObjects(
        request: io.github.vigoo.zioaws.s3.model.ListObjectsRequest
    ): IO[
      AwsError,
      io.github.vigoo.zioaws.s3.model.ListObjectsResponse.ReadOnly
    ] = asyncRequestResponse[ListObjectsRequest, ListObjectsResponse](
      "listObjects",
      api.listObjects
    )(request.buildAwsValue())
      .map(io.github.vigoo.zioaws.s3.model.ListObjectsResponse.wrap)
      .provide(r)
    def listBuckets(): IO[
      AwsError,
      io.github.vigoo.zioaws.s3.model.ListBucketsResponse.ReadOnly
    ] = asyncRequestResponse[ListBucketsRequest, ListBucketsResponse](
      "listBuckets",
      api.listBuckets
    )(ListBucketsRequest.builder().build())
      .map(io.github.vigoo.zioaws.s3.model.ListBucketsResponse.wrap)
      .provide(r)
    def getBucketTagging(
        request: io.github.vigoo.zioaws.s3.model.GetBucketTaggingRequest
    ): IO[
      AwsError,
      io.github.vigoo.zioaws.s3.model.GetBucketTaggingResponse.ReadOnly
    ] = asyncRequestResponse[GetBucketTaggingRequest, GetBucketTaggingResponse](
      "getBucketTagging",
      api.getBucketTagging
    )(request.buildAwsValue())
      .map(io.github.vigoo.zioaws.s3.model.GetBucketTaggingResponse.wrap)
      .provide(r)
    def putObject(
        request: io.github.vigoo.zioaws.s3.model.PutObjectRequest,
        body: ZStream[Any, AwsError, Byte]
    ): IO[
      AwsError,
      io.github.vigoo.zioaws.s3.model.PutObjectResponse.ReadOnly
    ] = asyncRequestInputStream[PutObjectRequest, PutObjectResponse](
      "putObject",
      api.putObject
    )(request.buildAwsValue(), body)
      .map(io.github.vigoo.zioaws.s3.model.PutObjectResponse.wrap)
      .provide(r)
    def putBucketTagging(
        request: io.github.vigoo.zioaws.s3.model.PutBucketTaggingRequest
    ): IO[AwsError, Unit] =
      asyncRequestResponse[PutBucketTaggingRequest, PutBucketTaggingResponse](
        "putBucketTagging",
        api.putBucketTagging
      )(request.buildAwsValue()).unit.provide(r)
    def deleteBucketTagging(
        request: io.github.vigoo.zioaws.s3.model.DeleteBucketTaggingRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      DeleteBucketTaggingRequest,
      DeleteBucketTaggingResponse
    ]("deleteBucketTagging", api.deleteBucketTagging)(
      request.buildAwsValue()
    ).unit.provide(r)
    def putBucketEncryption(
        request: io.github.vigoo.zioaws.s3.model.PutBucketEncryptionRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      PutBucketEncryptionRequest,
      PutBucketEncryptionResponse
    ]("putBucketEncryption", api.putBucketEncryption)(
      request.buildAwsValue()
    ).unit.provide(r)
    def putBucketRequestPayment(
        request: io.github.vigoo.zioaws.s3.model.PutBucketRequestPaymentRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      PutBucketRequestPaymentRequest,
      PutBucketRequestPaymentResponse
    ]("putBucketRequestPayment", api.putBucketRequestPayment)(
      request.buildAwsValue()
    ).unit.provide(r)
    def getObject(
        request: io.github.vigoo.zioaws.s3.model.GetObjectRequest
    ): IO[AwsError, StreamingOutputResult[
      Any,
      io.github.vigoo.zioaws.s3.model.GetObjectResponse.ReadOnly,
      Byte
    ]] = asyncRequestOutputStream[GetObjectRequest, GetObjectResponse](
      "getObject",
      api.getObject[Task[StreamingOutputResult[R, GetObjectResponse, Byte]]]
    )(request.buildAwsValue())
      .map(
        _.mapResponse(io.github.vigoo.zioaws.s3.model.GetObjectResponse.wrap)
          .provide(r)
      )
      .provide(r)
    def putObjectTagging(
        request: io.github.vigoo.zioaws.s3.model.PutObjectTaggingRequest
    ): IO[
      AwsError,
      io.github.vigoo.zioaws.s3.model.PutObjectTaggingResponse.ReadOnly
    ] = asyncRequestResponse[PutObjectTaggingRequest, PutObjectTaggingResponse](
      "putObjectTagging",
      api.putObjectTagging
    )(request.buildAwsValue())
      .map(io.github.vigoo.zioaws.s3.model.PutObjectTaggingResponse.wrap)
      .provide(r)
    def deleteBucketCors(
        request: io.github.vigoo.zioaws.s3.model.DeleteBucketCorsRequest
    ): IO[AwsError, Unit] =
      asyncRequestResponse[DeleteBucketCorsRequest, DeleteBucketCorsResponse](
        "deleteBucketCors",
        api.deleteBucketCors
      )(request.buildAwsValue()).unit.provide(r)
    def putPublicAccessBlock(
        request: io.github.vigoo.zioaws.s3.model.PutPublicAccessBlockRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      PutPublicAccessBlockRequest,
      PutPublicAccessBlockResponse
    ]("putPublicAccessBlock", api.putPublicAccessBlock)(
      request.buildAwsValue()
    ).unit.provide(r)
    def getObjectTorrent(
        request: io.github.vigoo.zioaws.s3.model.GetObjectTorrentRequest
    ): IO[AwsError, StreamingOutputResult[
      Any,
      io.github.vigoo.zioaws.s3.model.GetObjectTorrentResponse.ReadOnly,
      Byte
    ]] = asyncRequestOutputStream[
      GetObjectTorrentRequest,
      GetObjectTorrentResponse
    ](
      "getObjectTorrent",
      api.getObjectTorrent[Task[
        StreamingOutputResult[R, GetObjectTorrentResponse, Byte]
      ]]
    )(request.buildAwsValue())
      .map(
        _.mapResponse(
          io.github.vigoo.zioaws.s3.model.GetObjectTorrentResponse.wrap
        ).provide(r)
      )
      .provide(r)
    def getBucketInventoryConfiguration(
        request: io.github.vigoo.zioaws.s3.model.GetBucketInventoryConfigurationRequest
    ): IO[
      AwsError,
      io.github.vigoo.zioaws.s3.model.GetBucketInventoryConfigurationResponse.ReadOnly
    ] = asyncRequestResponse[
      GetBucketInventoryConfigurationRequest,
      GetBucketInventoryConfigurationResponse
    ]("getBucketInventoryConfiguration", api.getBucketInventoryConfiguration)(
      request.buildAwsValue()
    ).map(
      io.github.vigoo.zioaws.s3.model.GetBucketInventoryConfigurationResponse.wrap
    ).provide(r)
    def getBucketVersioning(
        request: io.github.vigoo.zioaws.s3.model.GetBucketVersioningRequest
    ): IO[
      AwsError,
      io.github.vigoo.zioaws.s3.model.GetBucketVersioningResponse.ReadOnly
    ] = asyncRequestResponse[
      GetBucketVersioningRequest,
      GetBucketVersioningResponse
    ]("getBucketVersioning", api.getBucketVersioning)(request.buildAwsValue())
      .map(io.github.vigoo.zioaws.s3.model.GetBucketVersioningResponse.wrap)
      .provide(r)
    def putBucketOwnershipControls(
        request: io.github.vigoo.zioaws.s3.model.PutBucketOwnershipControlsRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      PutBucketOwnershipControlsRequest,
      PutBucketOwnershipControlsResponse
    ]("putBucketOwnershipControls", api.putBucketOwnershipControls)(
      request.buildAwsValue()
    ).unit.provide(r)
    def headObject(
        request: io.github.vigoo.zioaws.s3.model.HeadObjectRequest
    ): IO[
      AwsError,
      io.github.vigoo.zioaws.s3.model.HeadObjectResponse.ReadOnly
    ] = asyncRequestResponse[HeadObjectRequest, HeadObjectResponse](
      "headObject",
      api.headObject
    )(request.buildAwsValue())
      .map(io.github.vigoo.zioaws.s3.model.HeadObjectResponse.wrap)
      .provide(r)
    def selectObjectContent(
        request: io.github.vigoo.zioaws.s3.model.SelectObjectContentRequest
    ): ZStream[
      Any,
      AwsError,
      io.github.vigoo.zioaws.s3.model.RecordsEvent.ReadOnly
    ] = asyncRequestEventOutputStream[
      SelectObjectContentRequest,
      SelectObjectContentResponse,
      SelectObjectContentResponseHandler,
      SelectObjectContentEventStream,
      RecordsEvent
    ](
      "SelectObjectContent",
      (
          request: SelectObjectContentRequest,
          handler: SelectObjectContentResponseHandler
      ) => api.selectObjectContent(request, handler),
      (impl: EventStreamResponseHandler[
        SelectObjectContentResponse,
        SelectObjectContentEventStream
      ]) =>
        new SelectObjectContentResponseHandler {
          override def responseReceived(
              response: SelectObjectContentResponse
          ): Unit = impl.responseReceived(response)
          override def onEventStream(
              publisher: SdkPublisher[SelectObjectContentEventStream]
          ): Unit = impl.onEventStream(publisher)
          override def exceptionOccurred(throwable: java.lang.Throwable): Unit =
            impl.exceptionOccurred(throwable)
          override def complete(): Unit = impl.complete()
        }
    )(request.buildAwsValue())
      .map(item => io.github.vigoo.zioaws.s3.model.RecordsEvent.wrap(item))
      .provide(r)
    def getBucketWebsite(
        request: io.github.vigoo.zioaws.s3.model.GetBucketWebsiteRequest
    ): IO[
      AwsError,
      io.github.vigoo.zioaws.s3.model.GetBucketWebsiteResponse.ReadOnly
    ] = asyncRequestResponse[GetBucketWebsiteRequest, GetBucketWebsiteResponse](
      "getBucketWebsite",
      api.getBucketWebsite
    )(request.buildAwsValue())
      .map(io.github.vigoo.zioaws.s3.model.GetBucketWebsiteResponse.wrap)
      .provide(r)
    def deleteBucketIntelligentTieringConfiguration(
        request: io.github.vigoo.zioaws.s3.model.DeleteBucketIntelligentTieringConfigurationRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      DeleteBucketIntelligentTieringConfigurationRequest,
      DeleteBucketIntelligentTieringConfigurationResponse
    ](
      "deleteBucketIntelligentTieringConfiguration",
      api.deleteBucketIntelligentTieringConfiguration
    )(request.buildAwsValue()).unit.provide(r)
    def putBucketInventoryConfiguration(
        request: io.github.vigoo.zioaws.s3.model.PutBucketInventoryConfigurationRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      PutBucketInventoryConfigurationRequest,
      PutBucketInventoryConfigurationResponse
    ]("putBucketInventoryConfiguration", api.putBucketInventoryConfiguration)(
      request.buildAwsValue()
    ).unit.provide(r)
    def getBucketIntelligentTieringConfiguration(
        request: io.github.vigoo.zioaws.s3.model.GetBucketIntelligentTieringConfigurationRequest
    ): IO[
      AwsError,
      io.github.vigoo.zioaws.s3.model.GetBucketIntelligentTieringConfigurationResponse.ReadOnly
    ] = asyncRequestResponse[
      GetBucketIntelligentTieringConfigurationRequest,
      GetBucketIntelligentTieringConfigurationResponse
    ](
      "getBucketIntelligentTieringConfiguration",
      api.getBucketIntelligentTieringConfiguration
    )(request.buildAwsValue())
      .map(
        io.github.vigoo.zioaws.s3.model.GetBucketIntelligentTieringConfigurationResponse.wrap
      )
      .provide(r)
    def getBucketAcl(
        request: io.github.vigoo.zioaws.s3.model.GetBucketAclRequest
    ): IO[
      AwsError,
      io.github.vigoo.zioaws.s3.model.GetBucketAclResponse.ReadOnly
    ] = asyncRequestResponse[GetBucketAclRequest, GetBucketAclResponse](
      "getBucketAcl",
      api.getBucketAcl
    )(request.buildAwsValue())
      .map(io.github.vigoo.zioaws.s3.model.GetBucketAclResponse.wrap)
      .provide(r)
    def listObjectsV2(
        request: io.github.vigoo.zioaws.s3.model.ListObjectsV2Request
    ): ZStream[
      Any,
      AwsError,
      io.github.vigoo.zioaws.s3.model.S3Object.ReadOnly
    ] = asyncJavaPaginatedRequest[
      ListObjectsV2Request,
      S3Object,
      ListObjectsV2Publisher
    ]("listObjectsV2", api.listObjectsV2Paginator, _.contents())(
      request.buildAwsValue()
    ).map(item => io.github.vigoo.zioaws.s3.model.S3Object.wrap(item))
      .provide(r)
    def putBucketVersioning(
        request: io.github.vigoo.zioaws.s3.model.PutBucketVersioningRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      PutBucketVersioningRequest,
      PutBucketVersioningResponse
    ]("putBucketVersioning", api.putBucketVersioning)(
      request.buildAwsValue()
    ).unit.provide(r)
    def putBucketAcl(
        request: io.github.vigoo.zioaws.s3.model.PutBucketAclRequest
    ): IO[AwsError, Unit] =
      asyncRequestResponse[PutBucketAclRequest, PutBucketAclResponse](
        "putBucketAcl",
        api.putBucketAcl
      )(request.buildAwsValue()).unit.provide(r)
    def getBucketReplication(
        request: io.github.vigoo.zioaws.s3.model.GetBucketReplicationRequest
    ): IO[
      AwsError,
      io.github.vigoo.zioaws.s3.model.GetBucketReplicationResponse.ReadOnly
    ] = asyncRequestResponse[
      GetBucketReplicationRequest,
      GetBucketReplicationResponse
    ]("getBucketReplication", api.getBucketReplication)(request.buildAwsValue())
      .map(io.github.vigoo.zioaws.s3.model.GetBucketReplicationResponse.wrap)
      .provide(r)
    def getPublicAccessBlock(
        request: io.github.vigoo.zioaws.s3.model.GetPublicAccessBlockRequest
    ): IO[
      AwsError,
      io.github.vigoo.zioaws.s3.model.GetPublicAccessBlockResponse.ReadOnly
    ] = asyncRequestResponse[
      GetPublicAccessBlockRequest,
      GetPublicAccessBlockResponse
    ]("getPublicAccessBlock", api.getPublicAccessBlock)(request.buildAwsValue())
      .map(io.github.vigoo.zioaws.s3.model.GetPublicAccessBlockResponse.wrap)
      .provide(r)
    def putObjectLegalHold(
        request: io.github.vigoo.zioaws.s3.model.PutObjectLegalHoldRequest
    ): IO[
      AwsError,
      io.github.vigoo.zioaws.s3.model.PutObjectLegalHoldResponse.ReadOnly
    ] = asyncRequestResponse[
      PutObjectLegalHoldRequest,
      PutObjectLegalHoldResponse
    ]("putObjectLegalHold", api.putObjectLegalHold)(request.buildAwsValue())
      .map(io.github.vigoo.zioaws.s3.model.PutObjectLegalHoldResponse.wrap)
      .provide(r)
    def getObjectLockConfiguration(
        request: io.github.vigoo.zioaws.s3.model.GetObjectLockConfigurationRequest
    ): IO[
      AwsError,
      io.github.vigoo.zioaws.s3.model.GetObjectLockConfigurationResponse.ReadOnly
    ] = asyncRequestResponse[
      GetObjectLockConfigurationRequest,
      GetObjectLockConfigurationResponse
    ]("getObjectLockConfiguration", api.getObjectLockConfiguration)(
      request.buildAwsValue()
    ).map(
      io.github.vigoo.zioaws.s3.model.GetObjectLockConfigurationResponse.wrap
    ).provide(r)
    def getBucketLocation(
        request: io.github.vigoo.zioaws.s3.model.GetBucketLocationRequest
    ): IO[
      AwsError,
      io.github.vigoo.zioaws.s3.model.GetBucketLocationResponse.ReadOnly
    ] =
      asyncRequestResponse[GetBucketLocationRequest, GetBucketLocationResponse](
        "getBucketLocation",
        api.getBucketLocation
      )(request.buildAwsValue())
        .map(io.github.vigoo.zioaws.s3.model.GetBucketLocationResponse.wrap)
        .provide(r)
    def deleteObjects(
        request: io.github.vigoo.zioaws.s3.model.DeleteObjectsRequest
    ): IO[AwsError, ReadOnly] =
      asyncRequestResponse[DeleteObjectsRequest, DeleteObjectsResponse](
        "deleteObjects",
        api.deleteObjects
      )(request.buildAwsValue())
        .map(io.github.vigoo.zioaws.s3.model.DeleteObjectsResponse.wrap)
        .provide(r)
    def abortMultipartUpload(
        request: io.github.vigoo.zioaws.s3.model.AbortMultipartUploadRequest
    ): IO[
      AwsError,
      io.github.vigoo.zioaws.s3.model.AbortMultipartUploadResponse.ReadOnly
    ] = asyncRequestResponse[
      AbortMultipartUploadRequest,
      AbortMultipartUploadResponse
    ]("abortMultipartUpload", api.abortMultipartUpload)(request.buildAwsValue())
      .map(io.github.vigoo.zioaws.s3.model.AbortMultipartUploadResponse.wrap)
      .provide(r)
    def getBucketPolicyStatus(
        request: io.github.vigoo.zioaws.s3.model.GetBucketPolicyStatusRequest
    ): IO[
      AwsError,
      io.github.vigoo.zioaws.s3.model.GetBucketPolicyStatusResponse.ReadOnly
    ] = asyncRequestResponse[
      GetBucketPolicyStatusRequest,
      GetBucketPolicyStatusResponse
    ]("getBucketPolicyStatus", api.getBucketPolicyStatus)(
      request.buildAwsValue()
    ).map(io.github.vigoo.zioaws.s3.model.GetBucketPolicyStatusResponse.wrap)
      .provide(r)
    def deleteBucketOwnershipControls(
        request: io.github.vigoo.zioaws.s3.model.DeleteBucketOwnershipControlsRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      DeleteBucketOwnershipControlsRequest,
      DeleteBucketOwnershipControlsResponse
    ]("deleteBucketOwnershipControls", api.deleteBucketOwnershipControls)(
      request.buildAwsValue()
    ).unit.provide(r)
    def putObjectRetention(
        request: io.github.vigoo.zioaws.s3.model.PutObjectRetentionRequest
    ): IO[
      AwsError,
      io.github.vigoo.zioaws.s3.model.PutObjectRetentionResponse.ReadOnly
    ] = asyncRequestResponse[
      PutObjectRetentionRequest,
      PutObjectRetentionResponse
    ]("putObjectRetention", api.putObjectRetention)(request.buildAwsValue())
      .map(io.github.vigoo.zioaws.s3.model.PutObjectRetentionResponse.wrap)
      .provide(r)
    def putBucketCors(
        request: io.github.vigoo.zioaws.s3.model.PutBucketCorsRequest
    ): IO[AwsError, Unit] =
      asyncRequestResponse[PutBucketCorsRequest, PutBucketCorsResponse](
        "putBucketCors",
        api.putBucketCors
      )(request.buildAwsValue()).unit.provide(r)
    def deleteObjectTagging(
        request: io.github.vigoo.zioaws.s3.model.DeleteObjectTaggingRequest
    ): IO[
      AwsError,
      io.github.vigoo.zioaws.s3.model.DeleteObjectTaggingResponse.ReadOnly
    ] = asyncRequestResponse[
      DeleteObjectTaggingRequest,
      DeleteObjectTaggingResponse
    ]("deleteObjectTagging", api.deleteObjectTagging)(request.buildAwsValue())
      .map(io.github.vigoo.zioaws.s3.model.DeleteObjectTaggingResponse.wrap)
      .provide(r)
    def deletePublicAccessBlock(
        request: io.github.vigoo.zioaws.s3.model.DeletePublicAccessBlockRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      DeletePublicAccessBlockRequest,
      DeletePublicAccessBlockResponse
    ]("deletePublicAccessBlock", api.deletePublicAccessBlock)(
      request.buildAwsValue()
    ).unit.provide(r)
    def deleteBucketEncryption(
        request: io.github.vigoo.zioaws.s3.model.DeleteBucketEncryptionRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      DeleteBucketEncryptionRequest,
      DeleteBucketEncryptionResponse
    ]("deleteBucketEncryption", api.deleteBucketEncryption)(
      request.buildAwsValue()
    ).unit.provide(r)
    def completeMultipartUpload(
        request: io.github.vigoo.zioaws.s3.model.CompleteMultipartUploadRequest
    ): IO[
      AwsError,
      io.github.vigoo.zioaws.s3.model.CompleteMultipartUploadResponse.ReadOnly
    ] = asyncRequestResponse[
      CompleteMultipartUploadRequest,
      CompleteMultipartUploadResponse
    ]("completeMultipartUpload", api.completeMultipartUpload)(
      request.buildAwsValue()
    ).map(io.github.vigoo.zioaws.s3.model.CompleteMultipartUploadResponse.wrap)
      .provide(r)
    def getObjectTagging(
        request: io.github.vigoo.zioaws.s3.model.GetObjectTaggingRequest
    ): IO[
      AwsError,
      io.github.vigoo.zioaws.s3.model.GetObjectTaggingResponse.ReadOnly
    ] = asyncRequestResponse[GetObjectTaggingRequest, GetObjectTaggingResponse](
      "getObjectTagging",
      api.getObjectTagging
    )(request.buildAwsValue())
      .map(io.github.vigoo.zioaws.s3.model.GetObjectTaggingResponse.wrap)
      .provide(r)
    def putObjectLockConfiguration(
        request: io.github.vigoo.zioaws.s3.model.PutObjectLockConfigurationRequest
    ): IO[
      AwsError,
      io.github.vigoo.zioaws.s3.model.PutObjectLockConfigurationResponse.ReadOnly
    ] = asyncRequestResponse[
      PutObjectLockConfigurationRequest,
      PutObjectLockConfigurationResponse
    ]("putObjectLockConfiguration", api.putObjectLockConfiguration)(
      request.buildAwsValue()
    ).map(
      io.github.vigoo.zioaws.s3.model.PutObjectLockConfigurationResponse.wrap
    ).provide(r)
    def putBucketAccelerateConfiguration(
        request: io.github.vigoo.zioaws.s3.model.PutBucketAccelerateConfigurationRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      PutBucketAccelerateConfigurationRequest,
      PutBucketAccelerateConfigurationResponse
    ]("putBucketAccelerateConfiguration", api.putBucketAccelerateConfiguration)(
      request.buildAwsValue()
    ).unit.provide(r)
    def getBucketNotificationConfiguration(
        request: io.github.vigoo.zioaws.s3.model.GetBucketNotificationConfigurationRequest
    ): IO[
      AwsError,
      io.github.vigoo.zioaws.s3.model.GetBucketNotificationConfigurationResponse.ReadOnly
    ] = asyncRequestResponse[
      GetBucketNotificationConfigurationRequest,
      GetBucketNotificationConfigurationResponse
    ](
      "getBucketNotificationConfiguration",
      api.getBucketNotificationConfiguration
    )(request.buildAwsValue())
      .map(
        io.github.vigoo.zioaws.s3.model.GetBucketNotificationConfigurationResponse.wrap
      )
      .provide(r)
  }
  def uploadPart(
      request: io.github.vigoo.zioaws.s3.model.UploadPartRequest,
      body: ZStream[Any, AwsError, Byte]
  ): ZIO[
    S3,
    AwsError,
    io.github.vigoo.zioaws.s3.model.UploadPartResponse.ReadOnly
  ] = ZIO.accessM(_.get.uploadPart(request, body))
  def createMultipartUpload(
      request: io.github.vigoo.zioaws.s3.model.CreateMultipartUploadRequest
  ): ZIO[
    S3,
    AwsError,
    io.github.vigoo.zioaws.s3.model.CreateMultipartUploadResponse.ReadOnly
  ] = ZIO.accessM(_.get.createMultipartUpload(request))
  def putBucketPolicy(
      request: io.github.vigoo.zioaws.s3.model.PutBucketPolicyRequest
  ): ZIO[S3, AwsError, Unit] = ZIO.accessM(_.get.putBucketPolicy(request))
  def getBucketPolicy(
      request: io.github.vigoo.zioaws.s3.model.GetBucketPolicyRequest
  ): ZIO[
    S3,
    AwsError,
    io.github.vigoo.zioaws.s3.model.GetBucketPolicyResponse.ReadOnly
  ] = ZIO.accessM(_.get.getBucketPolicy(request))
  def putBucketIntelligentTieringConfiguration(
      request: io.github.vigoo.zioaws.s3.model.PutBucketIntelligentTieringConfigurationRequest
  ): ZIO[S3, AwsError, Unit] =
    ZIO.accessM(_.get.putBucketIntelligentTieringConfiguration(request))
  def restoreObject(
      request: io.github.vigoo.zioaws.s3.model.RestoreObjectRequest
  ): ZIO[
    S3,
    AwsError,
    io.github.vigoo.zioaws.s3.model.RestoreObjectResponse.ReadOnly
  ] = ZIO.accessM(_.get.restoreObject(request))
  def deleteBucketWebsite(
      request: io.github.vigoo.zioaws.s3.model.DeleteBucketWebsiteRequest
  ): ZIO[S3, AwsError, Unit] = ZIO.accessM(_.get.deleteBucketWebsite(request))
  def putBucketLifecycleConfiguration(
      request: io.github.vigoo.zioaws.s3.model.PutBucketLifecycleConfigurationRequest
  ): ZIO[S3, AwsError, Unit] =
    ZIO.accessM(_.get.putBucketLifecycleConfiguration(request))
  def listObjectVersions(
      request: io.github.vigoo.zioaws.s3.model.ListObjectVersionsRequest
  ): ZStream[
    S3,
    AwsError,
    io.github.vigoo.zioaws.s3.model.ObjectVersion.ReadOnly
  ] = ZStream.accessStream(_.get.listObjectVersions(request))
  def putBucketLogging(
      request: io.github.vigoo.zioaws.s3.model.PutBucketLoggingRequest
  ): ZIO[S3, AwsError, Unit] = ZIO.accessM(_.get.putBucketLogging(request))
  def deleteBucketPolicy(
      request: io.github.vigoo.zioaws.s3.model.DeleteBucketPolicyRequest
  ): ZIO[S3, AwsError, Unit] = ZIO.accessM(_.get.deleteBucketPolicy(request))
  def putBucketAnalyticsConfiguration(
      request: io.github.vigoo.zioaws.s3.model.PutBucketAnalyticsConfigurationRequest
  ): ZIO[S3, AwsError, Unit] =
    ZIO.accessM(_.get.putBucketAnalyticsConfiguration(request))
  def deleteBucketInventoryConfiguration(
      request: io.github.vigoo.zioaws.s3.model.DeleteBucketInventoryConfigurationRequest
  ): ZIO[S3, AwsError, Unit] =
    ZIO.accessM(_.get.deleteBucketInventoryConfiguration(request))
  def getBucketAnalyticsConfiguration(
      request: io.github.vigoo.zioaws.s3.model.GetBucketAnalyticsConfigurationRequest
  ): ZIO[
    S3,
    AwsError,
    io.github.vigoo.zioaws.s3.model.GetBucketAnalyticsConfigurationResponse.ReadOnly
  ] = ZIO.accessM(_.get.getBucketAnalyticsConfiguration(request))
  def putObjectAcl(
      request: io.github.vigoo.zioaws.s3.model.PutObjectAclRequest
  ): ZIO[
    S3,
    AwsError,
    io.github.vigoo.zioaws.s3.model.PutObjectAclResponse.ReadOnly
  ] = ZIO.accessM(_.get.putObjectAcl(request))
  def listBucketAnalyticsConfigurations(
      request: io.github.vigoo.zioaws.s3.model.ListBucketAnalyticsConfigurationsRequest
  ): ZIO[
    S3,
    AwsError,
    io.github.vigoo.zioaws.s3.model.ListBucketAnalyticsConfigurationsResponse.ReadOnly
  ] = ZIO.accessM(_.get.listBucketAnalyticsConfigurations(request))
  def deleteBucketLifecycle(
      request: io.github.vigoo.zioaws.s3.model.DeleteBucketLifecycleRequest
  ): ZIO[S3, AwsError, Unit] = ZIO.accessM(_.get.deleteBucketLifecycle(request))
  def getObjectAcl(
      request: io.github.vigoo.zioaws.s3.model.GetObjectAclRequest
  ): ZIO[
    S3,
    AwsError,
    io.github.vigoo.zioaws.s3.model.GetObjectAclResponse.ReadOnly
  ] = ZIO.accessM(_.get.getObjectAcl(request))
  def listBucketInventoryConfigurations(
      request: io.github.vigoo.zioaws.s3.model.ListBucketInventoryConfigurationsRequest
  ): ZIO[
    S3,
    AwsError,
    io.github.vigoo.zioaws.s3.model.ListBucketInventoryConfigurationsResponse.ReadOnly
  ] = ZIO.accessM(_.get.listBucketInventoryConfigurations(request))
  def listMultipartUploads(
      request: io.github.vigoo.zioaws.s3.model.ListMultipartUploadsRequest
  ): ZStream[
    S3,
    AwsError,
    io.github.vigoo.zioaws.s3.model.MultipartUpload.ReadOnly
  ] = ZStream.accessStream(_.get.listMultipartUploads(request))
  def getBucketLifecycleConfiguration(
      request: io.github.vigoo.zioaws.s3.model.GetBucketLifecycleConfigurationRequest
  ): ZIO[
    S3,
    AwsError,
    io.github.vigoo.zioaws.s3.model.GetBucketLifecycleConfigurationResponse.ReadOnly
  ] = ZIO.accessM(_.get.getBucketLifecycleConfiguration(request))
  def getBucketEncryption(
      request: io.github.vigoo.zioaws.s3.model.GetBucketEncryptionRequest
  ): ZIO[
    S3,
    AwsError,
    io.github.vigoo.zioaws.s3.model.GetBucketEncryptionResponse.ReadOnly
  ] = ZIO.accessM(_.get.getBucketEncryption(request))
  def writeGetObjectResponse(
      request: io.github.vigoo.zioaws.s3.model.WriteGetObjectResponseRequest,
      body: ZStream[Any, AwsError, Byte]
  ): ZIO[S3, AwsError, Unit] =
    ZIO.accessM(_.get.writeGetObjectResponse(request, body))
  def getBucketCors(
      request: io.github.vigoo.zioaws.s3.model.GetBucketCorsRequest
  ): ZIO[
    S3,
    AwsError,
    io.github.vigoo.zioaws.s3.model.GetBucketCorsResponse.ReadOnly
  ] = ZIO.accessM(_.get.getBucketCors(request))
  def getObjectRetention(
      request: io.github.vigoo.zioaws.s3.model.GetObjectRetentionRequest
  ): ZIO[
    S3,
    AwsError,
    io.github.vigoo.zioaws.s3.model.GetObjectRetentionResponse.ReadOnly
  ] = ZIO.accessM(_.get.getObjectRetention(request))
  def getBucketLogging(
      request: io.github.vigoo.zioaws.s3.model.GetBucketLoggingRequest
  ): ZIO[
    S3,
    AwsError,
    io.github.vigoo.zioaws.s3.model.GetBucketLoggingResponse.ReadOnly
  ] = ZIO.accessM(_.get.getBucketLogging(request))
  def listParts(
      request: io.github.vigoo.zioaws.s3.model.ListPartsRequest
  ): ZStream[S3, AwsError, io.github.vigoo.zioaws.s3.model.Part.ReadOnly] =
    ZStream.accessStream(_.get.listParts(request))
  def getObjectAttributes(
      request: io.github.vigoo.zioaws.s3.model.GetObjectAttributesRequest
  ): ZIO[
    S3,
    AwsError,
    io.github.vigoo.zioaws.s3.model.GetObjectAttributesResponse.ReadOnly
  ] = ZIO.accessM(_.get.getObjectAttributes(request))
  def listBucketIntelligentTieringConfigurations(
      request: io.github.vigoo.zioaws.s3.model.ListBucketIntelligentTieringConfigurationsRequest
  ): ZIO[
    S3,
    AwsError,
    io.github.vigoo.zioaws.s3.model.ListBucketIntelligentTieringConfigurationsResponse.ReadOnly
  ] = ZIO.accessM(_.get.listBucketIntelligentTieringConfigurations(request))
  def listBucketMetricsConfigurations(
      request: io.github.vigoo.zioaws.s3.model.ListBucketMetricsConfigurationsRequest
  ): ZIO[
    S3,
    AwsError,
    io.github.vigoo.zioaws.s3.model.ListBucketMetricsConfigurationsResponse.ReadOnly
  ] = ZIO.accessM(_.get.listBucketMetricsConfigurations(request))
  def putBucketMetricsConfiguration(
      request: io.github.vigoo.zioaws.s3.model.PutBucketMetricsConfigurationRequest
  ): ZIO[S3, AwsError, Unit] =
    ZIO.accessM(_.get.putBucketMetricsConfiguration(request))
  def deleteBucketAnalyticsConfiguration(
      request: io.github.vigoo.zioaws.s3.model.DeleteBucketAnalyticsConfigurationRequest
  ): ZIO[S3, AwsError, Unit] =
    ZIO.accessM(_.get.deleteBucketAnalyticsConfiguration(request))
  def deleteBucketReplication(
      request: io.github.vigoo.zioaws.s3.model.DeleteBucketReplicationRequest
  ): ZIO[S3, AwsError, Unit] =
    ZIO.accessM(_.get.deleteBucketReplication(request))
  def uploadPartCopy(
      request: io.github.vigoo.zioaws.s3.model.UploadPartCopyRequest
  ): ZIO[
    S3,
    AwsError,
    io.github.vigoo.zioaws.s3.model.UploadPartCopyResponse.ReadOnly
  ] = ZIO.accessM(_.get.uploadPartCopy(request))
  def getObjectLegalHold(
      request: io.github.vigoo.zioaws.s3.model.GetObjectLegalHoldRequest
  ): ZIO[
    S3,
    AwsError,
    io.github.vigoo.zioaws.s3.model.GetObjectLegalHoldResponse.ReadOnly
  ] = ZIO.accessM(_.get.getObjectLegalHold(request))
  def getBucketRequestPayment(
      request: io.github.vigoo.zioaws.s3.model.GetBucketRequestPaymentRequest
  ): ZIO[
    S3,
    AwsError,
    io.github.vigoo.zioaws.s3.model.GetBucketRequestPaymentResponse.ReadOnly
  ] = ZIO.accessM(_.get.getBucketRequestPayment(request))
  def getBucketMetricsConfiguration(
      request: io.github.vigoo.zioaws.s3.model.GetBucketMetricsConfigurationRequest
  ): ZIO[
    S3,
    AwsError,
    io.github.vigoo.zioaws.s3.model.GetBucketMetricsConfigurationResponse.ReadOnly
  ] = ZIO.accessM(_.get.getBucketMetricsConfiguration(request))
  def copyObject(
      request: io.github.vigoo.zioaws.s3.model.CopyObjectRequest
  ): ZIO[
    S3,
    AwsError,
    io.github.vigoo.zioaws.s3.model.CopyObjectResponse.ReadOnly
  ] = ZIO.accessM(_.get.copyObject(request))
  def putBucketWebsite(
      request: io.github.vigoo.zioaws.s3.model.PutBucketWebsiteRequest
  ): ZIO[S3, AwsError, Unit] = ZIO.accessM(_.get.putBucketWebsite(request))
  def getBucketAccelerateConfiguration(
      request: io.github.vigoo.zioaws.s3.model.GetBucketAccelerateConfigurationRequest
  ): ZIO[
    S3,
    AwsError,
    io.github.vigoo.zioaws.s3.model.GetBucketAccelerateConfigurationResponse.ReadOnly
  ] = ZIO.accessM(_.get.getBucketAccelerateConfiguration(request))
  def headBucket(
      request: io.github.vigoo.zioaws.s3.model.HeadBucketRequest
  ): ZIO[S3, AwsError, Unit] = ZIO.accessM(_.get.headBucket(request))
  def deleteObject(
      request: io.github.vigoo.zioaws.s3.model.DeleteObjectRequest
  ): ZIO[
    S3,
    AwsError,
    io.github.vigoo.zioaws.s3.model.DeleteObjectResponse.ReadOnly
  ] = ZIO.accessM(_.get.deleteObject(request))
  def getBucketOwnershipControls(
      request: io.github.vigoo.zioaws.s3.model.GetBucketOwnershipControlsRequest
  ): ZIO[
    S3,
    AwsError,
    io.github.vigoo.zioaws.s3.model.GetBucketOwnershipControlsResponse.ReadOnly
  ] = ZIO.accessM(_.get.getBucketOwnershipControls(request))
  def putBucketReplication(
      request: io.github.vigoo.zioaws.s3.model.PutBucketReplicationRequest
  ): ZIO[S3, AwsError, Unit] = ZIO.accessM(_.get.putBucketReplication(request))
  def deleteBucket(
      request: io.github.vigoo.zioaws.s3.model.DeleteBucketRequest
  ): ZIO[S3, AwsError, Unit] = ZIO.accessM(_.get.deleteBucket(request))
  def putBucketNotificationConfiguration(
      request: io.github.vigoo.zioaws.s3.model.PutBucketNotificationConfigurationRequest
  ): ZIO[S3, AwsError, Unit] =
    ZIO.accessM(_.get.putBucketNotificationConfiguration(request))
  def deleteBucketMetricsConfiguration(
      request: io.github.vigoo.zioaws.s3.model.DeleteBucketMetricsConfigurationRequest
  ): ZIO[S3, AwsError, Unit] =
    ZIO.accessM(_.get.deleteBucketMetricsConfiguration(request))
  def createBucket(
      request: io.github.vigoo.zioaws.s3.model.CreateBucketRequest
  ): ZIO[
    S3,
    AwsError,
    io.github.vigoo.zioaws.s3.model.CreateBucketResponse.ReadOnly
  ] = ZIO.accessM(_.get.createBucket(request))
  def listObjects(
      request: io.github.vigoo.zioaws.s3.model.ListObjectsRequest
  ): ZIO[
    S3,
    AwsError,
    io.github.vigoo.zioaws.s3.model.ListObjectsResponse.ReadOnly
  ] = ZIO.accessM(_.get.listObjects(request))
  def listBuckets(): ZIO[
    S3,
    AwsError,
    io.github.vigoo.zioaws.s3.model.ListBucketsResponse.ReadOnly
  ] = ZIO.accessM(_.get.listBuckets())
  def getBucketTagging(
      request: io.github.vigoo.zioaws.s3.model.GetBucketTaggingRequest
  ): ZIO[
    S3,
    AwsError,
    io.github.vigoo.zioaws.s3.model.GetBucketTaggingResponse.ReadOnly
  ] = ZIO.accessM(_.get.getBucketTagging(request))
  def putObject(
      request: io.github.vigoo.zioaws.s3.model.PutObjectRequest,
      body: ZStream[Any, AwsError, Byte]
  ): ZIO[
    S3,
    AwsError,
    io.github.vigoo.zioaws.s3.model.PutObjectResponse.ReadOnly
  ] = ZIO.accessM(_.get.putObject(request, body))
  def putBucketTagging(
      request: io.github.vigoo.zioaws.s3.model.PutBucketTaggingRequest
  ): ZIO[S3, AwsError, Unit] = ZIO.accessM(_.get.putBucketTagging(request))
  def deleteBucketTagging(
      request: io.github.vigoo.zioaws.s3.model.DeleteBucketTaggingRequest
  ): ZIO[S3, AwsError, Unit] = ZIO.accessM(_.get.deleteBucketTagging(request))
  def putBucketEncryption(
      request: io.github.vigoo.zioaws.s3.model.PutBucketEncryptionRequest
  ): ZIO[S3, AwsError, Unit] = ZIO.accessM(_.get.putBucketEncryption(request))
  def putBucketRequestPayment(
      request: io.github.vigoo.zioaws.s3.model.PutBucketRequestPaymentRequest
  ): ZIO[S3, AwsError, Unit] =
    ZIO.accessM(_.get.putBucketRequestPayment(request))
  def getObject(
      request: io.github.vigoo.zioaws.s3.model.GetObjectRequest
  ): ZIO[S3, AwsError, StreamingOutputResult[
    Any,
    io.github.vigoo.zioaws.s3.model.GetObjectResponse.ReadOnly,
    Byte
  ]] = ZIO.accessM(_.get.getObject(request))
  def putObjectTagging(
      request: io.github.vigoo.zioaws.s3.model.PutObjectTaggingRequest
  ): ZIO[
    S3,
    AwsError,
    io.github.vigoo.zioaws.s3.model.PutObjectTaggingResponse.ReadOnly
  ] = ZIO.accessM(_.get.putObjectTagging(request))
  def deleteBucketCors(
      request: io.github.vigoo.zioaws.s3.model.DeleteBucketCorsRequest
  ): ZIO[S3, AwsError, Unit] = ZIO.accessM(_.get.deleteBucketCors(request))
  def putPublicAccessBlock(
      request: io.github.vigoo.zioaws.s3.model.PutPublicAccessBlockRequest
  ): ZIO[S3, AwsError, Unit] = ZIO.accessM(_.get.putPublicAccessBlock(request))
  def getObjectTorrent(
      request: io.github.vigoo.zioaws.s3.model.GetObjectTorrentRequest
  ): ZIO[S3, AwsError, StreamingOutputResult[
    Any,
    io.github.vigoo.zioaws.s3.model.GetObjectTorrentResponse.ReadOnly,
    Byte
  ]] = ZIO.accessM(_.get.getObjectTorrent(request))
  def getBucketInventoryConfiguration(
      request: io.github.vigoo.zioaws.s3.model.GetBucketInventoryConfigurationRequest
  ): ZIO[
    S3,
    AwsError,
    io.github.vigoo.zioaws.s3.model.GetBucketInventoryConfigurationResponse.ReadOnly
  ] = ZIO.accessM(_.get.getBucketInventoryConfiguration(request))
  def getBucketVersioning(
      request: io.github.vigoo.zioaws.s3.model.GetBucketVersioningRequest
  ): ZIO[
    S3,
    AwsError,
    io.github.vigoo.zioaws.s3.model.GetBucketVersioningResponse.ReadOnly
  ] = ZIO.accessM(_.get.getBucketVersioning(request))
  def putBucketOwnershipControls(
      request: io.github.vigoo.zioaws.s3.model.PutBucketOwnershipControlsRequest
  ): ZIO[S3, AwsError, Unit] =
    ZIO.accessM(_.get.putBucketOwnershipControls(request))
  def headObject(
      request: io.github.vigoo.zioaws.s3.model.HeadObjectRequest
  ): ZIO[
    S3,
    AwsError,
    io.github.vigoo.zioaws.s3.model.HeadObjectResponse.ReadOnly
  ] = ZIO.accessM(_.get.headObject(request))
  def selectObjectContent(
      request: io.github.vigoo.zioaws.s3.model.SelectObjectContentRequest
  ): ZStream[
    S3,
    AwsError,
    io.github.vigoo.zioaws.s3.model.RecordsEvent.ReadOnly
  ] = ZStream.accessStream(_.get.selectObjectContent(request))
  def getBucketWebsite(
      request: io.github.vigoo.zioaws.s3.model.GetBucketWebsiteRequest
  ): ZIO[
    S3,
    AwsError,
    io.github.vigoo.zioaws.s3.model.GetBucketWebsiteResponse.ReadOnly
  ] = ZIO.accessM(_.get.getBucketWebsite(request))
  def deleteBucketIntelligentTieringConfiguration(
      request: io.github.vigoo.zioaws.s3.model.DeleteBucketIntelligentTieringConfigurationRequest
  ): ZIO[S3, AwsError, Unit] =
    ZIO.accessM(_.get.deleteBucketIntelligentTieringConfiguration(request))
  def putBucketInventoryConfiguration(
      request: io.github.vigoo.zioaws.s3.model.PutBucketInventoryConfigurationRequest
  ): ZIO[S3, AwsError, Unit] =
    ZIO.accessM(_.get.putBucketInventoryConfiguration(request))
  def getBucketIntelligentTieringConfiguration(
      request: io.github.vigoo.zioaws.s3.model.GetBucketIntelligentTieringConfigurationRequest
  ): ZIO[
    S3,
    AwsError,
    io.github.vigoo.zioaws.s3.model.GetBucketIntelligentTieringConfigurationResponse.ReadOnly
  ] = ZIO.accessM(_.get.getBucketIntelligentTieringConfiguration(request))
  def getBucketAcl(
      request: io.github.vigoo.zioaws.s3.model.GetBucketAclRequest
  ): ZIO[
    S3,
    AwsError,
    io.github.vigoo.zioaws.s3.model.GetBucketAclResponse.ReadOnly
  ] = ZIO.accessM(_.get.getBucketAcl(request))
  def listObjectsV2(
      request: io.github.vigoo.zioaws.s3.model.ListObjectsV2Request
  ): ZStream[S3, AwsError, io.github.vigoo.zioaws.s3.model.S3Object.ReadOnly] =
    ZStream.accessStream(_.get.listObjectsV2(request))
  def putBucketVersioning(
      request: io.github.vigoo.zioaws.s3.model.PutBucketVersioningRequest
  ): ZIO[S3, AwsError, Unit] = ZIO.accessM(_.get.putBucketVersioning(request))
  def putBucketAcl(
      request: io.github.vigoo.zioaws.s3.model.PutBucketAclRequest
  ): ZIO[S3, AwsError, Unit] = ZIO.accessM(_.get.putBucketAcl(request))
  def getBucketReplication(
      request: io.github.vigoo.zioaws.s3.model.GetBucketReplicationRequest
  ): ZIO[
    S3,
    AwsError,
    io.github.vigoo.zioaws.s3.model.GetBucketReplicationResponse.ReadOnly
  ] = ZIO.accessM(_.get.getBucketReplication(request))
  def getPublicAccessBlock(
      request: io.github.vigoo.zioaws.s3.model.GetPublicAccessBlockRequest
  ): ZIO[
    S3,
    AwsError,
    io.github.vigoo.zioaws.s3.model.GetPublicAccessBlockResponse.ReadOnly
  ] = ZIO.accessM(_.get.getPublicAccessBlock(request))
  def putObjectLegalHold(
      request: io.github.vigoo.zioaws.s3.model.PutObjectLegalHoldRequest
  ): ZIO[
    S3,
    AwsError,
    io.github.vigoo.zioaws.s3.model.PutObjectLegalHoldResponse.ReadOnly
  ] = ZIO.accessM(_.get.putObjectLegalHold(request))
  def getObjectLockConfiguration(
      request: io.github.vigoo.zioaws.s3.model.GetObjectLockConfigurationRequest
  ): ZIO[
    S3,
    AwsError,
    io.github.vigoo.zioaws.s3.model.GetObjectLockConfigurationResponse.ReadOnly
  ] = ZIO.accessM(_.get.getObjectLockConfiguration(request))
  def getBucketLocation(
      request: io.github.vigoo.zioaws.s3.model.GetBucketLocationRequest
  ): ZIO[
    S3,
    AwsError,
    io.github.vigoo.zioaws.s3.model.GetBucketLocationResponse.ReadOnly
  ] = ZIO.accessM(_.get.getBucketLocation(request))
  def deleteObjects(
      request: io.github.vigoo.zioaws.s3.model.DeleteObjectsRequest
  ): ZIO[S3, AwsError, ReadOnly] = ZIO.accessM(_.get.deleteObjects(request))
  def abortMultipartUpload(
      request: io.github.vigoo.zioaws.s3.model.AbortMultipartUploadRequest
  ): ZIO[
    S3,
    AwsError,
    io.github.vigoo.zioaws.s3.model.AbortMultipartUploadResponse.ReadOnly
  ] = ZIO.accessM(_.get.abortMultipartUpload(request))
  def getBucketPolicyStatus(
      request: io.github.vigoo.zioaws.s3.model.GetBucketPolicyStatusRequest
  ): ZIO[
    S3,
    AwsError,
    io.github.vigoo.zioaws.s3.model.GetBucketPolicyStatusResponse.ReadOnly
  ] = ZIO.accessM(_.get.getBucketPolicyStatus(request))
  def deleteBucketOwnershipControls(
      request: io.github.vigoo.zioaws.s3.model.DeleteBucketOwnershipControlsRequest
  ): ZIO[S3, AwsError, Unit] =
    ZIO.accessM(_.get.deleteBucketOwnershipControls(request))
  def putObjectRetention(
      request: io.github.vigoo.zioaws.s3.model.PutObjectRetentionRequest
  ): ZIO[
    S3,
    AwsError,
    io.github.vigoo.zioaws.s3.model.PutObjectRetentionResponse.ReadOnly
  ] = ZIO.accessM(_.get.putObjectRetention(request))
  def putBucketCors(
      request: io.github.vigoo.zioaws.s3.model.PutBucketCorsRequest
  ): ZIO[S3, AwsError, Unit] = ZIO.accessM(_.get.putBucketCors(request))
  def deleteObjectTagging(
      request: io.github.vigoo.zioaws.s3.model.DeleteObjectTaggingRequest
  ): ZIO[
    S3,
    AwsError,
    io.github.vigoo.zioaws.s3.model.DeleteObjectTaggingResponse.ReadOnly
  ] = ZIO.accessM(_.get.deleteObjectTagging(request))
  def deletePublicAccessBlock(
      request: io.github.vigoo.zioaws.s3.model.DeletePublicAccessBlockRequest
  ): ZIO[S3, AwsError, Unit] =
    ZIO.accessM(_.get.deletePublicAccessBlock(request))
  def deleteBucketEncryption(
      request: io.github.vigoo.zioaws.s3.model.DeleteBucketEncryptionRequest
  ): ZIO[S3, AwsError, Unit] =
    ZIO.accessM(_.get.deleteBucketEncryption(request))
  def completeMultipartUpload(
      request: io.github.vigoo.zioaws.s3.model.CompleteMultipartUploadRequest
  ): ZIO[
    S3,
    AwsError,
    io.github.vigoo.zioaws.s3.model.CompleteMultipartUploadResponse.ReadOnly
  ] = ZIO.accessM(_.get.completeMultipartUpload(request))
  def getObjectTagging(
      request: io.github.vigoo.zioaws.s3.model.GetObjectTaggingRequest
  ): ZIO[
    S3,
    AwsError,
    io.github.vigoo.zioaws.s3.model.GetObjectTaggingResponse.ReadOnly
  ] = ZIO.accessM(_.get.getObjectTagging(request))
  def putObjectLockConfiguration(
      request: io.github.vigoo.zioaws.s3.model.PutObjectLockConfigurationRequest
  ): ZIO[
    S3,
    AwsError,
    io.github.vigoo.zioaws.s3.model.PutObjectLockConfigurationResponse.ReadOnly
  ] = ZIO.accessM(_.get.putObjectLockConfiguration(request))
  def putBucketAccelerateConfiguration(
      request: io.github.vigoo.zioaws.s3.model.PutBucketAccelerateConfigurationRequest
  ): ZIO[S3, AwsError, Unit] =
    ZIO.accessM(_.get.putBucketAccelerateConfiguration(request))
  def getBucketNotificationConfiguration(
      request: io.github.vigoo.zioaws.s3.model.GetBucketNotificationConfigurationRequest
  ): ZIO[
    S3,
    AwsError,
    io.github.vigoo.zioaws.s3.model.GetBucketNotificationConfigurationResponse.ReadOnly
  ] = ZIO.accessM(_.get.getBucketNotificationConfiguration(request))
}
