package io.github.vigoo.zioaws.servicediscovery.model
import io.github.vigoo.zioaws.servicediscovery.model.primitives.{
  ResourceDescription,
  ResourceId,
  NamespaceNameHttp
}
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CreateHttpNamespaceRequest(
    name: NamespaceNameHttp,
    creatorRequestId: Option[ResourceId] = None,
    description: Option[ResourceDescription] = None,
    tags: Option[Iterable[io.github.vigoo.zioaws.servicediscovery.model.Tag]] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicediscovery.model.CreateHttpNamespaceRequest = {
    import CreateHttpNamespaceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicediscovery.model.CreateHttpNamespaceRequest
      .builder()
      .name(name: java.lang.String)
      .optionallyWith(creatorRequestId.map(value => value: java.lang.String))(
        _.creatorRequestId
      )
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.servicediscovery.model.CreateHttpNamespaceRequest.ReadOnly =
    io.github.vigoo.zioaws.servicediscovery.model.CreateHttpNamespaceRequest
      .wrap(buildAwsValue())
}
object CreateHttpNamespaceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicediscovery.model.CreateHttpNamespaceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.servicediscovery.model.CreateHttpNamespaceRequest =
      io.github.vigoo.zioaws.servicediscovery.model.CreateHttpNamespaceRequest(
        nameValue,
        creatorRequestIdValue.map(value => value),
        descriptionValue.map(value => value),
        tagsValue.map(value =>
          value.map { item =>
            item.editable
          }
        )
      )
    def nameValue: NamespaceNameHttp
    def creatorRequestIdValue: Option[ResourceId]
    def descriptionValue: Option[ResourceDescription]
    def tagsValue: Option[
      List[io.github.vigoo.zioaws.servicediscovery.model.Tag.ReadOnly]
    ]
    def name: ZIO[Any, Nothing, NamespaceNameHttp] = ZIO.succeed(nameValue)
    def creatorRequestId: ZIO[Any, AwsError, ResourceId] =
      AwsError.unwrapOptionField("creatorRequestId", creatorRequestIdValue)
    def description: ZIO[Any, AwsError, ResourceDescription] =
      AwsError.unwrapOptionField("description", descriptionValue)
    def tags: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.servicediscovery.model.Tag.ReadOnly
    ]] = AwsError.unwrapOptionField("tags", tagsValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.servicediscovery.model.CreateHttpNamespaceRequest
  ) extends io.github.vigoo.zioaws.servicediscovery.model.CreateHttpNamespaceRequest.ReadOnly {
    override def nameValue: NamespaceNameHttp = impl.name(): NamespaceNameHttp
    override def creatorRequestIdValue: Option[ResourceId] =
      scala.Option(impl.creatorRequestId()).map(value => value: ResourceId)
    override def descriptionValue: Option[ResourceDescription] =
      scala.Option(impl.description()).map(value => value: ResourceDescription)
    override def tagsValue: Option[
      List[io.github.vigoo.zioaws.servicediscovery.model.Tag.ReadOnly]
    ] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.servicediscovery.model.Tag.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicediscovery.model.CreateHttpNamespaceRequest
  ): io.github.vigoo.zioaws.servicediscovery.model.CreateHttpNamespaceRequest.ReadOnly =
    new Wrapper(impl)
}
