package io.github.vigoo.zioaws.servicediscovery.model
import io.github.vigoo.zioaws.servicediscovery.model.primitives.OperationId
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CreateHttpNamespaceResponse(
    operationId: Option[OperationId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicediscovery.model.CreateHttpNamespaceResponse = {
    import CreateHttpNamespaceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicediscovery.model.CreateHttpNamespaceResponse
      .builder()
      .optionallyWith(operationId.map(value => value: java.lang.String))(
        _.operationId
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.servicediscovery.model.CreateHttpNamespaceResponse.ReadOnly =
    io.github.vigoo.zioaws.servicediscovery.model.CreateHttpNamespaceResponse
      .wrap(buildAwsValue())
}
object CreateHttpNamespaceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicediscovery.model.CreateHttpNamespaceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.servicediscovery.model.CreateHttpNamespaceResponse =
      io.github.vigoo.zioaws.servicediscovery.model
        .CreateHttpNamespaceResponse(operationIdValue.map(value => value))
    def operationIdValue: Option[OperationId]
    def operationId: ZIO[Any, AwsError, OperationId] =
      AwsError.unwrapOptionField("operationId", operationIdValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.servicediscovery.model.CreateHttpNamespaceResponse
  ) extends io.github.vigoo.zioaws.servicediscovery.model.CreateHttpNamespaceResponse.ReadOnly {
    override def operationIdValue: Option[OperationId] =
      scala.Option(impl.operationId()).map(value => value: OperationId)
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicediscovery.model.CreateHttpNamespaceResponse
  ): io.github.vigoo.zioaws.servicediscovery.model.CreateHttpNamespaceResponse.ReadOnly =
    new Wrapper(impl)
}
