package io.github.vigoo.zioaws.servicediscovery.model
import io.github.vigoo.zioaws.servicediscovery.model.primitives.{
  ResourceDescription,
  ResourceId,
  NamespaceNamePrivate
}
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CreatePrivateDnsNamespaceRequest(
    name: NamespaceNamePrivate,
    creatorRequestId: Option[ResourceId] = None,
    description: Option[ResourceDescription] = None,
    vpc: ResourceId,
    tags: Option[Iterable[io.github.vigoo.zioaws.servicediscovery.model.Tag]] =
      None,
    properties: Option[
      io.github.vigoo.zioaws.servicediscovery.model.PrivateDnsNamespaceProperties
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicediscovery.model.CreatePrivateDnsNamespaceRequest = {
    import CreatePrivateDnsNamespaceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicediscovery.model.CreatePrivateDnsNamespaceRequest
      .builder()
      .name(name: java.lang.String)
      .optionallyWith(creatorRequestId.map(value => value: java.lang.String))(
        _.creatorRequestId
      )
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .vpc(vpc: java.lang.String)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(properties.map(value => value.buildAwsValue()))(
        _.properties
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.servicediscovery.model.CreatePrivateDnsNamespaceRequest.ReadOnly =
    io.github.vigoo.zioaws.servicediscovery.model.CreatePrivateDnsNamespaceRequest
      .wrap(buildAwsValue())
}
object CreatePrivateDnsNamespaceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicediscovery.model.CreatePrivateDnsNamespaceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.servicediscovery.model.CreatePrivateDnsNamespaceRequest =
      io.github.vigoo.zioaws.servicediscovery.model
        .CreatePrivateDnsNamespaceRequest(
          nameValue,
          creatorRequestIdValue.map(value => value),
          descriptionValue.map(value => value),
          vpcValue,
          tagsValue.map(value =>
            value.map { item =>
              item.editable
            }
          ),
          propertiesValue.map(value => value.editable)
        )
    def nameValue: NamespaceNamePrivate
    def creatorRequestIdValue: Option[ResourceId]
    def descriptionValue: Option[ResourceDescription]
    def vpcValue: ResourceId
    def tagsValue: Option[
      List[io.github.vigoo.zioaws.servicediscovery.model.Tag.ReadOnly]
    ]
    def propertiesValue: Option[
      io.github.vigoo.zioaws.servicediscovery.model.PrivateDnsNamespaceProperties.ReadOnly
    ]
    def name: ZIO[Any, Nothing, NamespaceNamePrivate] = ZIO.succeed(nameValue)
    def creatorRequestId: ZIO[Any, AwsError, ResourceId] =
      AwsError.unwrapOptionField("creatorRequestId", creatorRequestIdValue)
    def description: ZIO[Any, AwsError, ResourceDescription] =
      AwsError.unwrapOptionField("description", descriptionValue)
    def vpc: ZIO[Any, Nothing, ResourceId] = ZIO.succeed(vpcValue)
    def tags: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.servicediscovery.model.Tag.ReadOnly
    ]] = AwsError.unwrapOptionField("tags", tagsValue)
    def properties: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.servicediscovery.model.PrivateDnsNamespaceProperties.ReadOnly
    ] = AwsError.unwrapOptionField("properties", propertiesValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.servicediscovery.model.CreatePrivateDnsNamespaceRequest
  ) extends io.github.vigoo.zioaws.servicediscovery.model.CreatePrivateDnsNamespaceRequest.ReadOnly {
    override def nameValue: NamespaceNamePrivate =
      impl.name(): NamespaceNamePrivate
    override def creatorRequestIdValue: Option[ResourceId] =
      scala.Option(impl.creatorRequestId()).map(value => value: ResourceId)
    override def descriptionValue: Option[ResourceDescription] =
      scala.Option(impl.description()).map(value => value: ResourceDescription)
    override def vpcValue: ResourceId = impl.vpc(): ResourceId
    override def tagsValue: Option[
      List[io.github.vigoo.zioaws.servicediscovery.model.Tag.ReadOnly]
    ] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.servicediscovery.model.Tag.wrap(item)
        }.toList
      )
    override def propertiesValue: Option[
      io.github.vigoo.zioaws.servicediscovery.model.PrivateDnsNamespaceProperties.ReadOnly
    ] = scala
      .Option(impl.properties())
      .map(value =>
        io.github.vigoo.zioaws.servicediscovery.model.PrivateDnsNamespaceProperties
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicediscovery.model.CreatePrivateDnsNamespaceRequest
  ): io.github.vigoo.zioaws.servicediscovery.model.CreatePrivateDnsNamespaceRequest.ReadOnly =
    new Wrapper(impl)
}
