package io.github.vigoo.zioaws.servicediscovery.model
import io.github.vigoo.zioaws.servicediscovery.model.primitives.{
  ResourceDescription,
  ResourceId,
  NamespaceNamePublic
}
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CreatePublicDnsNamespaceRequest(
    name: NamespaceNamePublic,
    creatorRequestId: Option[ResourceId] = None,
    description: Option[ResourceDescription] = None,
    tags: Option[Iterable[io.github.vigoo.zioaws.servicediscovery.model.Tag]] =
      None,
    properties: Option[
      io.github.vigoo.zioaws.servicediscovery.model.PublicDnsNamespaceProperties
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicediscovery.model.CreatePublicDnsNamespaceRequest = {
    import CreatePublicDnsNamespaceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicediscovery.model.CreatePublicDnsNamespaceRequest
      .builder()
      .name(name: java.lang.String)
      .optionallyWith(creatorRequestId.map(value => value: java.lang.String))(
        _.creatorRequestId
      )
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(properties.map(value => value.buildAwsValue()))(
        _.properties
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.servicediscovery.model.CreatePublicDnsNamespaceRequest.ReadOnly =
    io.github.vigoo.zioaws.servicediscovery.model.CreatePublicDnsNamespaceRequest
      .wrap(buildAwsValue())
}
object CreatePublicDnsNamespaceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicediscovery.model.CreatePublicDnsNamespaceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.servicediscovery.model.CreatePublicDnsNamespaceRequest =
      io.github.vigoo.zioaws.servicediscovery.model
        .CreatePublicDnsNamespaceRequest(
          nameValue,
          creatorRequestIdValue.map(value => value),
          descriptionValue.map(value => value),
          tagsValue.map(value =>
            value.map { item =>
              item.editable
            }
          ),
          propertiesValue.map(value => value.editable)
        )
    def nameValue: NamespaceNamePublic
    def creatorRequestIdValue: Option[ResourceId]
    def descriptionValue: Option[ResourceDescription]
    def tagsValue: Option[
      List[io.github.vigoo.zioaws.servicediscovery.model.Tag.ReadOnly]
    ]
    def propertiesValue: Option[
      io.github.vigoo.zioaws.servicediscovery.model.PublicDnsNamespaceProperties.ReadOnly
    ]
    def name: ZIO[Any, Nothing, NamespaceNamePublic] = ZIO.succeed(nameValue)
    def creatorRequestId: ZIO[Any, AwsError, ResourceId] =
      AwsError.unwrapOptionField("creatorRequestId", creatorRequestIdValue)
    def description: ZIO[Any, AwsError, ResourceDescription] =
      AwsError.unwrapOptionField("description", descriptionValue)
    def tags: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.servicediscovery.model.Tag.ReadOnly
    ]] = AwsError.unwrapOptionField("tags", tagsValue)
    def properties: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.servicediscovery.model.PublicDnsNamespaceProperties.ReadOnly
    ] = AwsError.unwrapOptionField("properties", propertiesValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.servicediscovery.model.CreatePublicDnsNamespaceRequest
  ) extends io.github.vigoo.zioaws.servicediscovery.model.CreatePublicDnsNamespaceRequest.ReadOnly {
    override def nameValue: NamespaceNamePublic =
      impl.name(): NamespaceNamePublic
    override def creatorRequestIdValue: Option[ResourceId] =
      scala.Option(impl.creatorRequestId()).map(value => value: ResourceId)
    override def descriptionValue: Option[ResourceDescription] =
      scala.Option(impl.description()).map(value => value: ResourceDescription)
    override def tagsValue: Option[
      List[io.github.vigoo.zioaws.servicediscovery.model.Tag.ReadOnly]
    ] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.servicediscovery.model.Tag.wrap(item)
        }.toList
      )
    override def propertiesValue: Option[
      io.github.vigoo.zioaws.servicediscovery.model.PublicDnsNamespaceProperties.ReadOnly
    ] = scala
      .Option(impl.properties())
      .map(value =>
        io.github.vigoo.zioaws.servicediscovery.model.PublicDnsNamespaceProperties
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicediscovery.model.CreatePublicDnsNamespaceRequest
  ): io.github.vigoo.zioaws.servicediscovery.model.CreatePublicDnsNamespaceRequest.ReadOnly =
    new Wrapper(impl)
}
