package io.github.vigoo.zioaws.servicediscovery.model
import io.github.vigoo.zioaws.servicediscovery.model.primitives.OperationId
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CreatePublicDnsNamespaceResponse(
    operationId: Option[OperationId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicediscovery.model.CreatePublicDnsNamespaceResponse = {
    import CreatePublicDnsNamespaceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicediscovery.model.CreatePublicDnsNamespaceResponse
      .builder()
      .optionallyWith(operationId.map(value => value: java.lang.String))(
        _.operationId
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.servicediscovery.model.CreatePublicDnsNamespaceResponse.ReadOnly =
    io.github.vigoo.zioaws.servicediscovery.model.CreatePublicDnsNamespaceResponse
      .wrap(buildAwsValue())
}
object CreatePublicDnsNamespaceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicediscovery.model.CreatePublicDnsNamespaceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.servicediscovery.model.CreatePublicDnsNamespaceResponse =
      io.github.vigoo.zioaws.servicediscovery.model
        .CreatePublicDnsNamespaceResponse(operationIdValue.map(value => value))
    def operationIdValue: Option[OperationId]
    def operationId: ZIO[Any, AwsError, OperationId] =
      AwsError.unwrapOptionField("operationId", operationIdValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.servicediscovery.model.CreatePublicDnsNamespaceResponse
  ) extends io.github.vigoo.zioaws.servicediscovery.model.CreatePublicDnsNamespaceResponse.ReadOnly {
    override def operationIdValue: Option[OperationId] =
      scala.Option(impl.operationId()).map(value => value: OperationId)
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicediscovery.model.CreatePublicDnsNamespaceResponse
  ): io.github.vigoo.zioaws.servicediscovery.model.CreatePublicDnsNamespaceResponse.ReadOnly =
    new Wrapper(impl)
}
