package io.github.vigoo.zioaws.servicediscovery.model
import io.github.vigoo.zioaws.servicediscovery.model.primitives.{
  ResourceDescription,
  ResourceId,
  ServiceName
}
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CreateServiceRequest(
    name: ServiceName,
    namespaceId: Option[ResourceId] = None,
    creatorRequestId: Option[ResourceId] = None,
    description: Option[ResourceDescription] = None,
    dnsConfig: Option[io.github.vigoo.zioaws.servicediscovery.model.DnsConfig] =
      None,
    healthCheckConfig: Option[
      io.github.vigoo.zioaws.servicediscovery.model.HealthCheckConfig
    ] = None,
    healthCheckCustomConfig: Option[
      io.github.vigoo.zioaws.servicediscovery.model.HealthCheckCustomConfig
    ] = None,
    tags: Option[Iterable[io.github.vigoo.zioaws.servicediscovery.model.Tag]] =
      None,
    `type`: Option[
      io.github.vigoo.zioaws.servicediscovery.model.ServiceTypeOption
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicediscovery.model.CreateServiceRequest = {
    import CreateServiceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicediscovery.model.CreateServiceRequest
      .builder()
      .name(name: java.lang.String)
      .optionallyWith(namespaceId.map(value => value: java.lang.String))(
        _.namespaceId
      )
      .optionallyWith(creatorRequestId.map(value => value: java.lang.String))(
        _.creatorRequestId
      )
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(dnsConfig.map(value => value.buildAwsValue()))(
        _.dnsConfig
      )
      .optionallyWith(healthCheckConfig.map(value => value.buildAwsValue()))(
        _.healthCheckConfig
      )
      .optionallyWith(
        healthCheckCustomConfig.map(value => value.buildAwsValue())
      )(_.healthCheckCustomConfig)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.servicediscovery.model.CreateServiceRequest.ReadOnly =
    io.github.vigoo.zioaws.servicediscovery.model.CreateServiceRequest
      .wrap(buildAwsValue())
}
object CreateServiceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicediscovery.model.CreateServiceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.servicediscovery.model.CreateServiceRequest =
      io.github.vigoo.zioaws.servicediscovery.model.CreateServiceRequest(
        nameValue,
        namespaceIdValue.map(value => value),
        creatorRequestIdValue.map(value => value),
        descriptionValue.map(value => value),
        dnsConfigValue.map(value => value.editable),
        healthCheckConfigValue.map(value => value.editable),
        healthCheckCustomConfigValue.map(value => value.editable),
        tagsValue.map(value =>
          value.map { item =>
            item.editable
          }
        ),
        typeValue.map(value => value)
      )
    def nameValue: ServiceName
    def namespaceIdValue: Option[ResourceId]
    def creatorRequestIdValue: Option[ResourceId]
    def descriptionValue: Option[ResourceDescription]
    def dnsConfigValue: Option[
      io.github.vigoo.zioaws.servicediscovery.model.DnsConfig.ReadOnly
    ]
    def healthCheckConfigValue: Option[
      io.github.vigoo.zioaws.servicediscovery.model.HealthCheckConfig.ReadOnly
    ]
    def healthCheckCustomConfigValue: Option[
      io.github.vigoo.zioaws.servicediscovery.model.HealthCheckCustomConfig.ReadOnly
    ]
    def tagsValue: Option[
      List[io.github.vigoo.zioaws.servicediscovery.model.Tag.ReadOnly]
    ]
    def typeValue: Option[
      io.github.vigoo.zioaws.servicediscovery.model.ServiceTypeOption
    ]
    def name: ZIO[Any, Nothing, ServiceName] = ZIO.succeed(nameValue)
    def namespaceId: ZIO[Any, AwsError, ResourceId] =
      AwsError.unwrapOptionField("namespaceId", namespaceIdValue)
    def creatorRequestId: ZIO[Any, AwsError, ResourceId] =
      AwsError.unwrapOptionField("creatorRequestId", creatorRequestIdValue)
    def description: ZIO[Any, AwsError, ResourceDescription] =
      AwsError.unwrapOptionField("description", descriptionValue)
    def dnsConfig: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.servicediscovery.model.DnsConfig.ReadOnly
    ] = AwsError.unwrapOptionField("dnsConfig", dnsConfigValue)
    def healthCheckConfig: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.servicediscovery.model.HealthCheckConfig.ReadOnly
    ] = AwsError.unwrapOptionField("healthCheckConfig", healthCheckConfigValue)
    def healthCheckCustomConfig: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.servicediscovery.model.HealthCheckCustomConfig.ReadOnly
    ] = AwsError.unwrapOptionField(
      "healthCheckCustomConfig",
      healthCheckCustomConfigValue
    )
    def tags: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.servicediscovery.model.Tag.ReadOnly
    ]] = AwsError.unwrapOptionField("tags", tagsValue)
    def `type`: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.servicediscovery.model.ServiceTypeOption
    ] = AwsError.unwrapOptionField("type", typeValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.servicediscovery.model.CreateServiceRequest
  ) extends io.github.vigoo.zioaws.servicediscovery.model.CreateServiceRequest.ReadOnly {
    override def nameValue: ServiceName = impl.name(): ServiceName
    override def namespaceIdValue: Option[ResourceId] =
      scala.Option(impl.namespaceId()).map(value => value: ResourceId)
    override def creatorRequestIdValue: Option[ResourceId] =
      scala.Option(impl.creatorRequestId()).map(value => value: ResourceId)
    override def descriptionValue: Option[ResourceDescription] =
      scala.Option(impl.description()).map(value => value: ResourceDescription)
    override def dnsConfigValue: Option[
      io.github.vigoo.zioaws.servicediscovery.model.DnsConfig.ReadOnly
    ] = scala
      .Option(impl.dnsConfig())
      .map(value =>
        io.github.vigoo.zioaws.servicediscovery.model.DnsConfig.wrap(value)
      )
    override def healthCheckConfigValue: Option[
      io.github.vigoo.zioaws.servicediscovery.model.HealthCheckConfig.ReadOnly
    ] = scala
      .Option(impl.healthCheckConfig())
      .map(value =>
        io.github.vigoo.zioaws.servicediscovery.model.HealthCheckConfig
          .wrap(value)
      )
    override def healthCheckCustomConfigValue: Option[
      io.github.vigoo.zioaws.servicediscovery.model.HealthCheckCustomConfig.ReadOnly
    ] = scala
      .Option(impl.healthCheckCustomConfig())
      .map(value =>
        io.github.vigoo.zioaws.servicediscovery.model.HealthCheckCustomConfig
          .wrap(value)
      )
    override def tagsValue: Option[
      List[io.github.vigoo.zioaws.servicediscovery.model.Tag.ReadOnly]
    ] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.servicediscovery.model.Tag.wrap(item)
        }.toList
      )
    override def typeValue: Option[
      io.github.vigoo.zioaws.servicediscovery.model.ServiceTypeOption
    ] = scala
      .Option(impl.`type`())
      .map(value =>
        io.github.vigoo.zioaws.servicediscovery.model.ServiceTypeOption
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicediscovery.model.CreateServiceRequest
  ): io.github.vigoo.zioaws.servicediscovery.model.CreateServiceRequest.ReadOnly =
    new Wrapper(impl)
}
